/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import org.apache.http.StatusLine;

public class Utils {
    protected static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static boolean isEqual(Object obj1, Object obj2) {
        if (obj1 != null) {
            return obj2 != null && obj1.equals(obj2);
        }
        return obj2 == null;
    }

    public static boolean isTransientError(StatusLine status) {
        int code = status.getStatusCode();
        return code == 500 || code == 502 || code == 503 || code == 504;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] byteArrayResultForQuery(SQLiteStorageEngine database, String query, String[] args) throws SQLException {
        byte[] result = null;
        Cursor cursor = null;
        try {
            cursor = database.rawQuery(query, args);
            if (cursor.moveToNext()) {
                result = cursor.getBlob(0);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

