/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.util;

import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Logger;
import com.couchbase.lite.util.SystemLogger;
import com.couchbase.lite.util.TextUtils;
import java.io.InputStream;

public class LoggerFactory {
    public static Logger createLogger() {
        String classname = "";
        String resource = "services/com.couchbase.lite.util.Logger";
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (inputStream == null) {
                Log.d("CBLite", "Unable to load %s. Falling back to SystemLogger", resource);
                return new SystemLogger();
            }
            byte[] bytes = TextUtils.read(inputStream);
            classname = new String(bytes);
            if (classname == null || classname.isEmpty()) {
                Log.d("CBLite", "Unable to load %s. Falling back to SystemLogger", resource);
                return new SystemLogger();
            }
            Log.v("CBLite", "Loading logger: %s", classname);
            Class<?> clazz = Class.forName(classname);
            Logger logger = (Logger)clazz.newInstance();
            return logger;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to logger.  Resource: " + resource + " classname: " + classname, e);
        }
    }
}

