/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class SequenceMap {
    private TreeSet<Long> sequences = new TreeSet();
    private long lastSequence = 0L;
    private List<String> values = new ArrayList<String>(100);
    private long firstValueSequence = 1L;

    public synchronized long addValue(String value) {
        this.sequences.add(++this.lastSequence);
        this.values.add(value);
        return this.lastSequence;
    }

    public synchronized void removeSequence(long sequence) {
        this.sequences.remove(sequence);
    }

    public synchronized boolean isEmpty() {
        return this.sequences.isEmpty();
    }

    public synchronized long getCheckpointedSequence() {
        long sequence = this.lastSequence;
        if (!this.sequences.isEmpty()) {
            sequence = this.sequences.first() - 1L;
        }
        if (sequence > this.firstValueSequence) {
            int numToRemove = (int)(sequence - this.firstValueSequence);
            for (int i = 0; i < numToRemove; ++i) {
                this.values.remove(0);
            }
            this.firstValueSequence += (long)numToRemove;
        }
        return sequence;
    }

    public synchronized String getCheckpointedValue() {
        int index = (int)(this.getCheckpointedSequence() - this.firstValueSequence);
        return index >= 0 ? this.values.get(index) : null;
    }
}

