/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.AuthenticatorImpl;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import com.couchbase.lite.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;

public class RemoteRequest
implements Runnable {
    private static final int MAX_RETRIES = 2;
    private static final int RETRY_DELAY_MS = 10000;
    protected ScheduledExecutorService workExecutor;
    protected final HttpClientFactory clientFactory;
    protected String method;
    protected URL url;
    protected Object body;
    protected Authenticator authenticator;
    protected RemoteRequestCompletionBlock onPreCompletion;
    protected RemoteRequestCompletionBlock onCompletion;
    protected RemoteRequestCompletionBlock onPostCompletion;
    private int retryCount;
    private Database db;
    protected Map<String, Object> requestHeaders;

    public RemoteRequest(ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, String method, URL url, Object body, Database db, Map<String, Object> requestHeaders, RemoteRequestCompletionBlock onCompletion) {
        this.clientFactory = clientFactory;
        this.method = method;
        this.url = url;
        this.body = body;
        this.onCompletion = onCompletion;
        this.workExecutor = workExecutor;
        this.requestHeaders = requestHeaders;
        this.db = db;
    }

    @Override
    public void run() {
        HttpClient httpClient = this.clientFactory.getHttpClient();
        ClientConnectionManager manager = httpClient.getConnectionManager();
        HttpUriRequest request = this.createConcreteRequest();
        this.preemptivelySetAuthCredentials(httpClient);
        request.addHeader("Accept", "multipart/related, application/json");
        this.addRequestHeaders(request);
        this.setBody(request);
        this.executeRequest(httpClient, request);
    }

    protected void addRequestHeaders(HttpUriRequest request) {
        for (String requestHeaderKey : this.requestHeaders.keySet()) {
            request.addHeader(requestHeaderKey, this.requestHeaders.get(requestHeaderKey).toString());
        }
    }

    public void setOnPostCompletion(RemoteRequestCompletionBlock onPostCompletion) {
        this.onPostCompletion = onPostCompletion;
    }

    public void setOnPreCompletion(RemoteRequestCompletionBlock onPreCompletion) {
        this.onPreCompletion = onPreCompletion;
    }

    protected HttpUriRequest createConcreteRequest() {
        HttpGet request = null;
        if (this.method.equalsIgnoreCase("GET")) {
            request = new HttpGet(this.url.toExternalForm());
        } else if (this.method.equalsIgnoreCase("PUT")) {
            request = new HttpPut(this.url.toExternalForm());
        } else if (this.method.equalsIgnoreCase("POST")) {
            request = new HttpPost(this.url.toExternalForm());
        }
        return request;
    }

    protected void setBody(HttpUriRequest request) {
        if (this.body != null && request instanceof HttpEntityEnclosingRequestBase) {
            byte[] bodyBytes = null;
            try {
                bodyBytes = Manager.getObjectMapper().writeValueAsBytes(this.body);
            }
            catch (Exception e) {
                Log.e("RemoteRequest", "Error serializing body of request", e);
            }
            ByteArrayEntity entity = new ByteArrayEntity(bodyBytes);
            entity.setContentType("application/json");
            ((HttpEntityEnclosingRequestBase)request).setEntity((HttpEntity)entity);
        }
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected boolean retryRequest() {
        if (this.retryCount >= 2) {
            return false;
        }
        this.workExecutor.schedule(this, 10000L, TimeUnit.MILLISECONDS);
        ++this.retryCount;
        Log.d("RemoteRequest", "Will retry in %d ms", 10000);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRequest(HttpClient httpClient, HttpUriRequest request) {
        HttpResponse response;
        Throwable error;
        Object fullBody;
        block15: {
            fullBody = null;
            error = null;
            response = null;
            try {
                response = httpClient.execute(request);
                try {
                    if (httpClient instanceof DefaultHttpClient) {
                        DefaultHttpClient defaultHttpClient = (DefaultHttpClient)httpClient;
                        this.clientFactory.addCookies(defaultHttpClient.getCookieStore().getCookies());
                    }
                }
                catch (Exception e) {
                    Log.e("RemoteRequest", "Unable to add in cookies to global store", e);
                }
                StatusLine status = response.getStatusLine();
                if (Utils.isTransientError(status) && this.retryRequest()) {
                    return;
                }
                if (status.getStatusCode() >= 300) {
                    Log.e("RemoteRequest", "Got error status: %d for %s.  Reason: %s", status.getStatusCode(), request, status.getReasonPhrase());
                    error = new HttpResponseException(status.getStatusCode(), status.getReasonPhrase());
                    break block15;
                }
                HttpEntity temp = response.getEntity();
                if (temp == null) break block15;
                InputStream stream = null;
                try {
                    stream = temp.getContent();
                    fullBody = Manager.getObjectMapper().readValue(stream, Object.class);
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (ClientProtocolException e) {
                Log.e("RemoteRequest", "client protocol exception", e);
                error = e;
            }
            catch (IOException e) {
                Log.e("RemoteRequest", "io exception", e);
                error = e;
                if (!this.retryRequest()) break block15;
                return;
            }
        }
        this.respondWithResult(fullBody, error, response);
    }

    protected void preemptivelySetAuthCredentials(HttpClient httpClient) {
        boolean isUrlBasedUserInfo = false;
        String userInfo = this.url.getUserInfo();
        if (userInfo != null) {
            isUrlBasedUserInfo = true;
        } else if (this.authenticator != null) {
            AuthenticatorImpl auth = (AuthenticatorImpl)this.authenticator;
            userInfo = auth.authUserInfo();
        }
        if (userInfo != null) {
            if (userInfo.contains(":") && !userInfo.trim().equals(":")) {
                String[] userInfoElements = userInfo.split(":");
                String username = isUrlBasedUserInfo ? URIUtils.decode(userInfoElements[0]) : userInfoElements[0];
                String password = isUrlBasedUserInfo ? URIUtils.decode(userInfoElements[1]) : userInfoElements[1];
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                if (httpClient instanceof DefaultHttpClient) {
                    DefaultHttpClient dhc = (DefaultHttpClient)httpClient;
                    HttpRequestInterceptor preemptiveAuth = new HttpRequestInterceptor((Credentials)credentials){
                        final /* synthetic */ Credentials val$credentials;
                        {
                            this.val$credentials = credentials;
                        }

                        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                            if (authState.getAuthScheme() == null) {
                                authState.setAuthScheme((AuthScheme)new BasicScheme());
                                authState.setCredentials(this.val$credentials);
                            }
                        }
                    };
                    dhc.addRequestInterceptor(preemptiveAuth, 0);
                }
            } else {
                Log.w("RemoteRequest", "RemoteRequest Unable to parse user info, not setting credentials");
            }
        }
    }

    public void respondWithResult(final Object result, final Throwable error, final HttpResponse response) {
        if (this.workExecutor != null) {
            this.workExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (RemoteRequest.this.onPreCompletion != null) {
                            RemoteRequest.this.onPreCompletion.onCompletion(response, error);
                        }
                        RemoteRequest.this.onCompletion.onCompletion(result, error);
                        if (RemoteRequest.this.onPostCompletion != null) {
                            RemoteRequest.this.onPostCompletion.onCompletion(response, error);
                        }
                    }
                    catch (Exception e) {
                        Log.e("RemoteRequest", "RemoteRequestCompletionBlock throw Exception", e);
                    }
                }
            });
        } else {
            Log.e("RemoteRequest", "Work executor was null!");
        }
    }
}

