/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.support.KMPMatch;
import com.couchbase.lite.support.MultipartReaderDelegate;
import com.couchbase.lite.support.Range;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.util.ByteArrayBuffer;

public class MultipartReader {
    private static Charset utf8 = Charset.forName("UTF-8");
    private static byte[] kCRLFCRLF = new String("\r\n\r\n").getBytes(utf8);
    private MultipartReaderState state;
    private ByteArrayBuffer buffer;
    private String contentType;
    private byte[] boundary;
    private MultipartReaderDelegate delegate;
    public Map<String, String> headers;

    public MultipartReader(String contentType, MultipartReaderDelegate delegate) {
        this.contentType = contentType;
        this.delegate = delegate;
        this.buffer = new ByteArrayBuffer(1024);
        this.state = MultipartReaderState.kAtStart;
        this.parseContentType();
    }

    public byte[] getBoundary() {
        return this.boundary;
    }

    public byte[] getBoundaryWithoutLeadingCRLF() {
        byte[] rawBoundary = this.getBoundary();
        byte[] result = Arrays.copyOfRange(rawBoundary, 2, rawBoundary.length);
        return result;
    }

    public boolean finished() {
        return this.state == MultipartReaderState.kAtEnd;
    }

    private byte[] eomBytes() {
        return new String("--").getBytes(Charset.forName("UTF-8"));
    }

    private boolean memcmp(byte[] array1, byte[] array2, int len) {
        boolean equals = true;
        for (int i = 0; i < len; ++i) {
            if (array1[i] == array2[i]) continue;
            equals = false;
        }
        return equals;
    }

    public Range searchFor(byte[] pattern, int start) {
        KMPMatch searcher = new KMPMatch();
        int matchIndex = searcher.indexOf(this.buffer.toByteArray(), pattern, start);
        if (matchIndex != -1) {
            return new Range(matchIndex, pattern.length);
        }
        return new Range(matchIndex, 0);
    }

    public void parseHeaders(String headersStr) {
        this.headers = new HashMap<String, String>();
        if (headersStr != null && headersStr.length() > 0) {
            headersStr = headersStr.trim();
            StringTokenizer tokenizer = new StringTokenizer(headersStr, "\r\n");
            while (tokenizer.hasMoreTokens()) {
                String header = tokenizer.nextToken();
                if (!header.contains(":")) {
                    throw new IllegalArgumentException("Missing ':' in header line: " + header);
                }
                StringTokenizer headerTokenizer = new StringTokenizer(header, ":");
                String key = headerTokenizer.nextToken().trim();
                String value = headerTokenizer.nextToken().trim();
                this.headers.put(key, value);
            }
        }
    }

    private void deleteUpThrough(int location) {
        byte[] newBuffer = Arrays.copyOfRange(this.buffer.toByteArray(), location, this.buffer.length());
        this.buffer.clear();
        this.buffer.append(newBuffer, 0, newBuffer.length);
    }

    private void trimBuffer() {
        int boundaryLen;
        int bufLen = this.buffer.length();
        if (bufLen > (boundaryLen = this.getBoundary().length)) {
            byte[] dataToAppend = Arrays.copyOfRange(this.buffer.toByteArray(), 0, bufLen - boundaryLen);
            this.delegate.appendToPart(dataToAppend);
            this.deleteUpThrough(bufLen - boundaryLen);
        }
    }

    public void appendData(byte[] data) {
        MultipartReaderState nextState;
        if (this.buffer == null) {
            return;
        }
        if (data.length == 0) {
            return;
        }
        this.buffer.append(data, 0, data.length);
        do {
            nextState = MultipartReaderState.kUninitialized;
            int bufLen = this.buffer.length();
            switch (this.state) {
                case kAtStart: {
                    byte[] boundaryWithoutLeadingCRLF = this.getBoundaryWithoutLeadingCRLF();
                    if (bufLen < boundaryWithoutLeadingCRLF.length) break;
                    if (this.memcmp(this.buffer.toByteArray(), boundaryWithoutLeadingCRLF, boundaryWithoutLeadingCRLF.length)) {
                        this.deleteUpThrough(boundaryWithoutLeadingCRLF.length);
                        nextState = MultipartReaderState.kInHeaders;
                        break;
                    }
                    nextState = MultipartReaderState.kInPrologue;
                    break;
                }
                case kInPrologue: 
                case kInBody: {
                    if (bufLen < this.boundary.length) break;
                    int start = Math.max(0, bufLen - data.length - this.boundary.length);
                    Range r = this.searchFor(this.boundary, start);
                    if (r.getLength() > 0) {
                        if (this.state == MultipartReaderState.kInBody) {
                            byte[] dataToAppend = Arrays.copyOfRange(this.buffer.toByteArray(), 0, r.getLocation());
                            this.delegate.appendToPart(dataToAppend);
                            this.delegate.finishedPart();
                        }
                        this.deleteUpThrough(r.getLocation() + r.getLength());
                        nextState = MultipartReaderState.kInHeaders;
                        break;
                    }
                    this.trimBuffer();
                    break;
                }
                case kInHeaders: {
                    if (bufLen >= 2 && this.memcmp(this.buffer.toByteArray(), this.eomBytes(), 2)) {
                        this.state = MultipartReaderState.kAtEnd;
                        this.close();
                        return;
                    }
                    Range r = this.searchFor(kCRLFCRLF, 0);
                    if (r.getLength() <= 0) break;
                    byte[] headersBytes = Arrays.copyOf(this.buffer.toByteArray(), r.getLocation());
                    String headersString = new String(headersBytes, utf8);
                    this.parseHeaders(headersString);
                    this.deleteUpThrough(r.getLocation() + r.getLength());
                    this.delegate.startedPart(this.headers);
                    nextState = MultipartReaderState.kInBody;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected data after end of MIME body");
                }
            }
            if (nextState == MultipartReaderState.kUninitialized) continue;
            this.state = nextState;
        } while (nextState != MultipartReaderState.kUninitialized && this.buffer.length() > 0);
    }

    private void close() {
        this.buffer = null;
        this.boundary = null;
    }

    private void parseContentType() {
        StringTokenizer tokenizer = new StringTokenizer(this.contentType, ";");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String param = tokenizer.nextToken().trim();
            if (first) {
                if (!param.startsWith("multipart/")) {
                    throw new IllegalArgumentException(this.contentType + " does not start with multipart/");
                }
                first = false;
                continue;
            }
            if (!param.startsWith("boundary=")) continue;
            String tempBoundary = param.substring(9);
            if (tempBoundary.startsWith("\"")) {
                if (tempBoundary.length() < 2 || !tempBoundary.endsWith("\"")) {
                    throw new IllegalArgumentException(this.contentType + " is not valid");
                }
                tempBoundary = tempBoundary.substring(1, tempBoundary.length() - 1);
            }
            if (tempBoundary.length() < 1) {
                throw new IllegalArgumentException(this.contentType + " has zero-length boundary");
            }
            tempBoundary = String.format("\r\n--%s", tempBoundary);
            this.boundary = tempBoundary.getBytes(Charset.forName("UTF-8"));
            break;
        }
    }

    private static enum MultipartReaderState {
        kUninitialized,
        kAtStart,
        kInPrologue,
        kInBody,
        kInHeaders,
        kAtEnd,
        kFailed;

    }
}

