/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.Manager;
import com.couchbase.lite.util.Log;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LazyJsonObject<K, V>
extends AbstractMap<K, V> {
    private boolean parsed = false;
    private byte[] json;
    private Map<K, V> cache = new HashMap();

    public LazyJsonObject(byte[] json) {
        if (json[0] != 123) {
            throw new IllegalArgumentException("data must represent a JSON Object");
        }
        this.json = json;
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V get(Object key) {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        this.parseJson();
        return this.cache.get(key);
    }

    @Override
    public V remove(Object key) {
        if (this.cache.containsKey(key)) {
            return this.cache.remove(key);
        }
        this.parseJson();
        return this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.cache.containsKey(key)) {
            return this.cache.containsKey(key);
        }
        this.parseJson();
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.cache.containsValue(value)) {
            return this.cache.containsValue(value);
        }
        this.parseJson();
        return this.cache.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        this.parseJson();
        return this.cache.keySet();
    }

    @Override
    public int size() {
        this.parseJson();
        return this.cache.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.parseJson();
        return this.cache.entrySet();
    }

    @Override
    public Collection<V> values() {
        this.parseJson();
        return this.cache.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseJson() {
        if (this.parsed) {
            return;
        }
        try {
            Map parsedprops = (Map)Manager.getObjectMapper().readValue(this.json, Object.class);
            parsedprops.putAll(this.cache);
            this.cache = parsedprops;
        }
        catch (Exception e) {
            Log.e("CBLite", this.getClass().getName() + ": Failed to parse Json data: ", e);
        }
        finally {
            this.parsed = true;
            this.json = null;
        }
    }
}

