/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.support.HttpClientFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class CouchbaseLiteHttpClientFactory
implements HttpClientFactory {
    private CookieStore cookieStore;
    private SSLSocketFactory sslSocketFactory;
    private BasicHttpParams basicHttpParams;
    public static final int DEFAULT_CONNECTION_TIMEOUT_SECONDS = 60;
    public static final int DEFAULT_SO_TIMEOUT_SECONDS = 60;

    public CouchbaseLiteHttpClientFactory(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    @InterfaceAudience.Private
    public void setSSLSocketFactory(SSLSocketFactory sslSocketFactoryFromUser) {
        if (this.sslSocketFactory != null) {
            throw new RuntimeException("SSLSocketFactory already set");
        }
        this.sslSocketFactory = sslSocketFactoryFromUser;
    }

    @InterfaceAudience.Private
    public void setBasicHttpParams(BasicHttpParams basicHttpParams) {
        this.basicHttpParams = basicHttpParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public HttpClient getHttpClient() {
        if (this.basicHttpParams == null) {
            this.basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)this.basicHttpParams, (int)60000);
            HttpConnectionParams.setSoTimeout((HttpParams)this.basicHttpParams, (int)60000);
        }
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        schemeRegistry.register(new Scheme("https", (SocketFactory)(this.sslSocketFactory == null ? sslSocketFactory : this.sslSocketFactory), 443));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager((HttpParams)this.basicHttpParams, schemeRegistry);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)this.basicHttpParams);
        CouchbaseLiteHttpClientFactory couchbaseLiteHttpClientFactory = this;
        synchronized (couchbaseLiteHttpClientFactory) {
            client.setCookieStore(this.cookieStore);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    public void addCookies(List<Cookie> cookies) {
        if (this.cookieStore == null) {
            return;
        }
        CouchbaseLiteHttpClientFactory couchbaseLiteHttpClientFactory = this;
        synchronized (couchbaseLiteHttpClientFactory) {
            for (Cookie cookie : cookies) {
                this.cookieStore.addCookie(cookie);
            }
        }
    }

    @Override
    public void deleteCookie(String name) {
        if (this.cookieStore == null) {
            return;
        }
        List cookies = this.cookieStore.getCookies();
        ArrayList<Cookie> retainedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (cookie.getName().equals(name)) continue;
            retainedCookies.add(cookie);
        }
        this.cookieStore.clear();
        for (Cookie retainedCookie : retainedCookies) {
            this.cookieStore.addCookie(retainedCookie);
        }
    }

    @Override
    @InterfaceAudience.Private
    public CookieStore getCookieStore() {
        return this.cookieStore;
    }
}

