/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.support;

import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Batcher<T> {
    private ScheduledExecutorService workExecutor;
    private ScheduledFuture<?> flushFuture;
    private int capacity;
    private int delay;
    private int scheduledDelay;
    private LinkedHashSet<T> inbox;
    private BatchProcessor<T> processor;
    private boolean scheduled = false;
    private long lastProcessedTime;
    private Runnable processNowRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                Batcher.this.processNow();
            }
            catch (Exception e) {
                Log.e("Sync", this + ": BatchProcessor throw exception", e);
            }
        }
    };

    public Batcher(ScheduledExecutorService workExecutor, int capacity, int delay, BatchProcessor<T> processor) {
        this.workExecutor = workExecutor;
        this.capacity = capacity;
        this.delay = delay;
        this.processor = processor;
    }

    public synchronized void queueObjects(List<T> objects) {
        Log.v("Sync", "%s: queueObjects called with %d objects. ", this, objects.size());
        if (objects.size() == 0) {
            return;
        }
        if (this.inbox == null) {
            this.inbox = new LinkedHashSet();
        }
        Log.v("Sync", "%s: inbox size before adding objects: %d", this, this.inbox.size());
        this.inbox.addAll(objects);
        if (this.inbox.size() < this.capacity) {
            Log.v("Sync", "%s: inbox.size() < capacity, schedule processing", this);
            int delayToUse = this.delay;
            long delta = System.currentTimeMillis() - this.lastProcessedTime;
            if (delta >= (long)this.delay) {
                Log.v("Sync", "%s: delta %s >= delay %s --> using delay 0", this, delta, this.delay);
                delayToUse = 0;
            } else {
                Log.v("Sync", "%s: delta %s < delay --> using delay %s", this, delta, this.delay, delayToUse);
            }
            this.scheduleWithDelay(delayToUse);
        } else {
            Log.v("Sync", "%s: inbox.size() >= capacity, process immediately", this);
            this.unschedule();
            this.processNow();
        }
    }

    public void queueObject(T object) {
        List<Object> objects = Arrays.asList(object);
        this.queueObjects(objects);
    }

    public void flush() {
        this.unschedule();
        this.processNow();
    }

    public void flushAll() {
        while (this.inbox.size() > 0) {
            this.unschedule();
            ArrayList<T> toProcess = new ArrayList<T>();
            toProcess.addAll(this.inbox);
            this.processor.process(toProcess);
            this.lastProcessedTime = System.currentTimeMillis();
        }
    }

    public void clear() {
        Log.v("Sync", "%s: clear() called, setting inbox to null", this);
        this.unschedule();
        this.inbox = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        Batcher batcher = this;
        synchronized (batcher) {
            if (this.inbox == null) {
                return 0;
            }
            return this.inbox.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNow() {
        Log.v("Sync", this + ": processNow() called");
        this.scheduled = false;
        ArrayList<Object> toProcess = new ArrayList<Object>();
        Batcher batcher = this;
        synchronized (batcher) {
            if (this.inbox == null || this.inbox.size() == 0) {
                Log.v("Sync", this + ": processNow() called, but inbox is empty");
                return;
            }
            if (this.inbox.size() <= this.capacity) {
                Log.v("Sync", "%s: inbox.size() <= capacity, adding %d items from inbox -> toProcess", this, this.inbox.size());
                toProcess.addAll(this.inbox);
                this.inbox = null;
            } else {
                Log.v("Sync", "%s: processNow() called, inbox size: %d", this, this.inbox.size());
                int i = 0;
                for (Object e : this.inbox) {
                    toProcess.add(e);
                    if (++i < this.capacity) continue;
                    break;
                }
                for (Object e : toProcess) {
                    Log.v("Sync", "%s: processNow() removing %s from inbox", this, e);
                    this.inbox.remove(e);
                }
                Log.v("Sync", "%s: inbox.size() > capacity, moving %d items from inbox -> toProcess array", this, toProcess.size());
                this.scheduleWithDelay(0);
            }
        }
        if (toProcess != null && toProcess.size() > 0) {
            Log.v("Sync", "%s: invoking processor with %d items ", this, toProcess.size());
            this.processor.process(toProcess);
        } else {
            Log.v("Sync", "%s: nothing to process", this);
        }
        this.lastProcessedTime = System.currentTimeMillis();
    }

    private void scheduleWithDelay(int suggestedDelay) {
        Log.v("Sync", "%s: scheduleWithDelay called with delay: %d ms", this, suggestedDelay);
        if (this.scheduled && suggestedDelay < this.scheduledDelay) {
            Log.v("Sync", "%s: already scheduled and: %d < %d --> unscheduling", this, suggestedDelay, this.scheduledDelay);
            this.unschedule();
        }
        if (!this.scheduled) {
            Log.v("Sync", "not already scheduled");
            this.scheduled = true;
            this.scheduledDelay = suggestedDelay;
            Log.v("Sync", "workExecutor.schedule() with delay: %d ms", suggestedDelay);
            this.flushFuture = this.workExecutor.schedule(this.processNowRunnable, (long)suggestedDelay, TimeUnit.MILLISECONDS);
        }
    }

    private void unschedule() {
        Log.v("Sync", this + ": unschedule() called");
        this.scheduled = false;
        if (this.flushFuture != null) {
            boolean didCancel = this.flushFuture.cancel(false);
            Log.v("Sync", "tried to cancel flushFuture, result: %s", didCancel);
        } else {
            Log.v("Sync", "flushFuture was null, doing nothing");
        }
    }
}

