/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.storage;

import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.TextUtils;
import java.io.InputStream;

public class SQLiteStorageEngineFactory {
    public static SQLiteStorageEngine createStorageEngine() {
        String classname = "";
        String resource = "services/com.couchbase.lite.storage.SQLiteStorageEngine";
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            byte[] bytes = TextUtils.read(inputStream);
            classname = new String(bytes);
            Log.d("CBLite", "Loading storage engine: %s", classname);
            Class<?> clazz = Class.forName(classname);
            SQLiteStorageEngine storageEngine = (SQLiteStorageEngine)clazz.newInstance();
            return storageEngine;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load storage.  Resource: " + resource + " classname: " + classname, e);
        }
    }
}

