/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.router;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.Attachment;
import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Misc;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.Reducer;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.View;
import com.couchbase.lite.auth.FacebookAuthorizer;
import com.couchbase.lite.auth.PersonaAuthorizer;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.Body;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.router.Header;
import com.couchbase.lite.router.RouterCallbackBlock;
import com.couchbase.lite.router.URLConnection;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.support.Version;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.client.HttpResponseException;

public class Router
implements Database.ChangeListener {
    private Manager manager;
    private Database db;
    private URLConnection connection;
    private Map<String, String> queries;
    private boolean changesIncludesDocs = false;
    private RouterCallbackBlock callbackBlock;
    private boolean responseSent = false;
    private boolean waiting = false;
    private ReplicationFilter changesFilter;
    private boolean longpoll = false;

    public static String getVersionString() {
        return Version.getVersion();
    }

    public Router(Manager manager, URLConnection connection) {
        this.manager = manager;
        this.connection = connection;
    }

    public void setCallbackBlock(RouterCallbackBlock callbackBlock) {
        this.callbackBlock = callbackBlock;
    }

    public Map<String, String> getQueries() {
        String queryString;
        if (this.queries == null && (queryString = this.connection.getURL().getQuery()) != null && queryString.length() > 0) {
            this.queries = new HashMap<String, String>();
            for (String component : queryString.split("&")) {
                int location = component.indexOf(61);
                if (location <= 0) continue;
                String key = component.substring(0, location);
                String value = component.substring(location + 1);
                this.queries.put(key, value);
            }
        }
        return this.queries;
    }

    public boolean getBooleanValueFromBody(String paramName, Map<String, Object> bodyDict, boolean defaultVal) {
        boolean value = defaultVal;
        if (bodyDict.containsKey(paramName)) {
            value = Boolean.TRUE.equals(bodyDict.get(paramName));
        }
        return value;
    }

    public String getQuery(String param) {
        String value;
        Map<String, String> queries = this.getQueries();
        if (queries != null && (value = queries.get(param)) != null) {
            return URLDecoder.decode(value);
        }
        return null;
    }

    public boolean getBooleanQuery(String param) {
        String value = this.getQuery(param);
        return value != null && !"false".equals(value) && !"0".equals(value);
    }

    public int getIntQuery(String param, int defaultValue) {
        int result = defaultValue;
        String value = this.getQuery(param);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public Object getJSONQuery(String param) {
        String value = this.getQuery(param);
        if (value == null) {
            return null;
        }
        Object result = null;
        try {
            result = Manager.getObjectMapper().readValue(value, Object.class);
        }
        catch (Exception e) {
            Log.w("Unable to parse JSON Query", e);
        }
        return result;
    }

    public boolean cacheWithEtag(String etag) {
        String eTag = String.format("\"%s\"", etag);
        this.connection.getResHeader().add("Etag", eTag);
        String requestIfNoneMatch = this.connection.getRequestProperty("If-None-Match");
        return eTag.equals(requestIfNoneMatch);
    }

    public Map<String, Object> getBodyAsDictionary() {
        try {
            InputStream contentStream = this.connection.getRequestInputStream();
            Map bodyMap = (Map)Manager.getObjectMapper().readValue(contentStream, Map.class);
            return bodyMap;
        }
        catch (IOException e) {
            Log.w("Router", "WARNING: Exception parsing body into dictionary", e);
            return null;
        }
    }

    public EnumSet<Database.TDContentOptions> getContentOptions() {
        EnumSet<Database.TDContentOptions> result = EnumSet.noneOf(Database.TDContentOptions.class);
        if (this.getBooleanQuery("attachments")) {
            result.add(Database.TDContentOptions.TDIncludeAttachments);
        }
        if (this.getBooleanQuery("local_seq")) {
            result.add(Database.TDContentOptions.TDIncludeLocalSeq);
        }
        if (this.getBooleanQuery("conflicts")) {
            result.add(Database.TDContentOptions.TDIncludeConflicts);
        }
        if (this.getBooleanQuery("revs")) {
            result.add(Database.TDContentOptions.TDIncludeRevs);
        }
        if (this.getBooleanQuery("revs_info")) {
            result.add(Database.TDContentOptions.TDIncludeRevsInfo);
        }
        return result;
    }

    public boolean getQueryOptions(QueryOptions options) {
        Object key;
        options.setSkip(this.getIntQuery("skip", options.getSkip()));
        options.setLimit(this.getIntQuery("limit", options.getLimit()));
        options.setGroupLevel(this.getIntQuery("group_level", options.getGroupLevel()));
        options.setDescending(this.getBooleanQuery("descending"));
        options.setIncludeDocs(this.getBooleanQuery("include_docs"));
        options.setUpdateSeq(this.getBooleanQuery("update_seq"));
        if (this.getQuery("inclusive_end") != null) {
            options.setInclusiveEnd(this.getBooleanQuery("inclusive_end"));
        }
        if (this.getQuery("reduce") != null) {
            options.setReduce(this.getBooleanQuery("reduce"));
        }
        options.setGroup(this.getBooleanQuery("group"));
        options.setContentOptions(this.getContentOptions());
        Object keysParam = this.getJSONQuery("keys");
        if (keysParam != null && !(keysParam instanceof List)) {
            return false;
        }
        ArrayList<Object> keys = (ArrayList<Object>)keysParam;
        if (keys == null && (key = this.getJSONQuery("key")) != null) {
            keys = new ArrayList<Object>();
            keys.add(key);
        }
        if (keys != null) {
            options.setKeys((List<Object>)keys);
        } else {
            options.setStartKey(this.getJSONQuery("startkey"));
            options.setEndKey(this.getJSONQuery("endkey"));
            if (this.getJSONQuery("startkey_docid") != null) {
                options.setStartKeyDocId(this.getJSONQuery("startkey_docid").toString());
            }
            if (this.getJSONQuery("endkey_docid") != null) {
                options.setEndKeyDocId(this.getJSONQuery("endkey_docid").toString());
            }
        }
        return true;
    }

    public String getMultipartRequestType() {
        String accept = this.connection.getRequestProperty("Accept");
        if (accept.startsWith("multipart/")) {
            return accept;
        }
        return null;
    }

    public Status openDB() {
        if (this.db == null) {
            return new Status(500);
        }
        if (!this.db.exists()) {
            return new Status(404);
        }
        if (!this.db.open()) {
            return new Status(500);
        }
        return new Status(200);
    }

    public static List<String> splitPath(URL url) {
        String pathString = url.getPath();
        if (pathString.startsWith("/")) {
            pathString = pathString.substring(1);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (pathString.length() == 0) {
            return result;
        }
        for (String component : pathString.split("/")) {
            result.add(URLDecoder.decode(component));
        }
        return result;
    }

    public void sendResponse() {
        if (!this.responseSent) {
            this.responseSent = true;
            if (this.callbackBlock != null) {
                this.callbackBlock.onResponseReady();
            }
        }
    }

    public void start() {
        String responseType;
        String accept;
        HashMap<String, Object> result;
        String errorMessage;
        String method = this.connection.getRequestMethod();
        if ("HEAD".equals(method)) {
            method = "GET";
        }
        String message = String.format("do_%s", method);
        List<String> path = Router.splitPath(this.connection.getURL());
        if (path == null) {
            this.connection.setResponseCode(400);
            try {
                this.connection.getResponseOutputStream().close();
            }
            catch (IOException e) {
                Log.e("Router", "Error closing empty output stream");
            }
            this.sendResponse();
            return;
        }
        int pathLen = path.size();
        if (pathLen > 0) {
            String dbName = path.get(0);
            if (dbName.startsWith("_")) {
                message = message + dbName;
            } else {
                message = message + "_Database";
                if (!Manager.isValidDatabaseName(dbName)) {
                    Header resHeader = this.connection.getResHeader();
                    if (resHeader != null) {
                        resHeader.add("Content-Type", "application/json");
                    }
                    HashMap<String, Object> result2 = new HashMap<String, Object>();
                    result2.put("error", "Invalid database");
                    result2.put("status", 400);
                    this.connection.setResponseBody(new Body(result2));
                    ByteArrayInputStream bais = new ByteArrayInputStream(this.connection.getResponseBody().getJson());
                    this.connection.setResponseInputStream(bais);
                    this.connection.setResponseCode(400);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e("Router", "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
                boolean mustExist = false;
                this.db = this.manager.getDatabaseWithoutOpening(dbName, mustExist);
                if (this.db == null) {
                    this.connection.setResponseCode(400);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e("Router", "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
            }
        } else {
            message = message + "Root";
        }
        String docID = null;
        if (this.db != null && pathLen > 1) {
            message = message.replaceFirst("_Database", "_Document");
            Status status = this.openDB();
            if (!status.isSuccessful()) {
                this.connection.setResponseCode(status.getCode());
                try {
                    this.connection.getResponseOutputStream().close();
                }
                catch (IOException e) {
                    Log.e("Router", "Error closing empty output stream");
                }
                this.sendResponse();
                return;
            }
            String name = path.get(1);
            if (!name.startsWith("_")) {
                if (!Database.isValidDocumentId(name)) {
                    this.connection.setResponseCode(400);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e("Router", "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
                docID = name;
            } else if ("_design".equals(name) || "_local".equals(name)) {
                if (pathLen <= 2) {
                    this.connection.setResponseCode(404);
                    try {
                        this.connection.getResponseOutputStream().close();
                    }
                    catch (IOException e) {
                        Log.e("Router", "Error closing empty output stream");
                    }
                    this.sendResponse();
                    return;
                }
                docID = name + "/" + path.get(2);
                path.set(1, docID);
                path.remove(2);
                --pathLen;
            } else if (name.startsWith("_design") || name.startsWith("_local")) {
                docID = name;
            } else {
                message = message + name;
                if (pathLen > 2) {
                    List<String> subList = path.subList(2, pathLen - 1);
                    StringBuilder sb = new StringBuilder();
                    Iterator<String> iter = subList.iterator();
                    while (iter.hasNext()) {
                        sb.append(iter.next());
                        if (!iter.hasNext()) continue;
                        sb.append("/");
                    }
                    docID = sb.toString();
                }
            }
        }
        String attachmentName = null;
        if (docID != null && pathLen > 2) {
            message = message.replaceFirst("_Document", "_Attachment");
            attachmentName = path.get(2);
            if (attachmentName.startsWith("_") && docID.startsWith("_design")) {
                message = message.replaceFirst("_Attachment", "_DesignDocument");
                docID = docID.substring(8);
                attachmentName = pathLen > 3 ? path.get(3) : null;
            } else if (pathLen > 3) {
                List<String> subList = path.subList(2, pathLen);
                StringBuilder sb = new StringBuilder();
                Iterator<String> iter = subList.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    if (!iter.hasNext()) continue;
                    sb.append("/");
                }
                attachmentName = sb.toString();
            }
        }
        Status status = null;
        try {
            Method m = Router.class.getMethod(message, Database.class, String.class, String.class);
            status = (Status)m.invoke((Object)this, this.db, docID, attachmentName);
        }
        catch (NoSuchMethodException msme) {
            try {
                errorMessage = String.format("Router unable to route request to %s", message);
                Log.e("Router", errorMessage);
                result = new HashMap();
                result.put("error", "not_found");
                result.put("reason", errorMessage);
                this.connection.setResponseBody(new Body(result));
                Method m = Router.class.getMethod("do_UNKNOWN", Database.class, String.class, String.class);
                status = (Status)m.invoke((Object)this, this.db, docID, attachmentName);
            }
            catch (Exception e) {
                Log.e("Router", "Router attempted do_UNKNWON fallback, but that threw an exception", e);
                result = new HashMap<String, Object>();
                result.put("error", "not_found");
                result.put("reason", "Router unable to route request");
                this.connection.setResponseBody(new Body(result));
                status = new Status(404);
            }
        }
        catch (Exception e) {
            errorMessage = "Router unable to route request to " + message;
            Log.e("Router", errorMessage, e);
            result = new HashMap();
            result.put("error", "not_found");
            result.put("reason", errorMessage + e.toString());
            this.connection.setResponseBody(new Body(result));
            status = e instanceof CouchbaseLiteException ? ((CouchbaseLiteException)e).getCBLStatus() : new Status(404);
        }
        if (status.isSuccessful() && this.connection.getResponseBody() == null && this.connection.getHeaderField("Content-Type") == null) {
            this.connection.setResponseBody(new Body("{\"ok\":true}".getBytes()));
        }
        if (!status.isSuccessful() && this.connection.getResponseBody() == null) {
            HashMap<String, Object> result3 = new HashMap<String, Object>();
            result3.put("status", status.getCode());
            this.connection.setResponseBody(new Body(result3));
        }
        if (this.connection.getResponseBody() != null && this.connection.getResponseBody().isValidJSON()) {
            Header resHeader = this.connection.getResHeader();
            if (resHeader != null) {
                resHeader.add("Content-Type", "application/json");
            } else {
                Log.w("Router", "Cannot add Content-Type header because getResHeader() returned null");
            }
        }
        if ((accept = this.connection.getRequestProperty("Accept")) != null && !"*/*".equals(accept) && (responseType = this.connection.getBaseContentType()) != null && accept.indexOf(responseType) < 0) {
            Log.e("Router", "Error 406: Can't satisfy request Accept: %s", accept);
            status = new Status(406);
        }
        this.connection.getResHeader().add("Server", String.format("Couchbase Lite %s", Router.getVersionString()));
        if (status.getCode() != 0) {
            this.connection.setResponseCode(status.getCode());
            if (this.connection.getResponseBody() != null) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.connection.getResponseBody().getJson());
                this.connection.setResponseInputStream(bais);
            } else {
                try {
                    this.connection.getResponseOutputStream().close();
                }
                catch (IOException e) {
                    Log.e("Router", "Error closing empty output stream");
                }
            }
            this.sendResponse();
        }
    }

    public void stop() {
        this.callbackBlock = null;
        if (this.db != null) {
            this.db.removeChangeListener(this);
        }
    }

    public Status do_UNKNOWN(Database db, String docID, String attachmentName) {
        return new Status(400);
    }

    public void setResponseLocation(URL url) {
        int startOfQuery;
        String location = url.getPath();
        String query = url.getQuery();
        if (query != null && (startOfQuery = location.indexOf(query)) > 0) {
            location = location.substring(0, startOfQuery);
        }
        this.connection.getResHeader().add("Location", location);
    }

    public Status do_GETRoot(Database _db, String _docID, String _attachmentName) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("CBLite", "Welcome");
        info.put("couchdb", "Welcome");
        info.put("version", Router.getVersionString());
        this.connection.setResponseBody(new Body(info));
        return new Status(200);
    }

    public Status do_GET_all_dbs(Database _db, String _docID, String _attachmentName) {
        List<String> dbs = this.manager.getAllDatabaseNames();
        this.connection.setResponseBody(new Body(dbs));
        return new Status(200);
    }

    public Status do_GET_session(Database _db, String _docID, String _attachmentName) {
        HashMap<String, Object> session = new HashMap<String, Object>();
        HashMap<String, String[]> userCtx = new HashMap<String, String[]>();
        String[] roles = new String[]{"_admin"};
        session.put("ok", true);
        userCtx.put("name", null);
        userCtx.put("roles", roles);
        session.put("userCtx", userCtx);
        this.connection.setResponseBody(new Body(session));
        return new Status(200);
    }

    public Status do_POST_replicate(Database _db, String _docID, String _attachmentName) {
        boolean cancel;
        Replication replicator;
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        try {
            replicator = this.manager.getReplicator(body);
        }
        catch (CouchbaseLiteException e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", e.toString());
            this.connection.setResponseBody(new Body(result));
            return e.getCBLStatus();
        }
        Boolean cancelBoolean = (Boolean)body.get("cancel");
        boolean bl = cancel = cancelBoolean != null && cancelBoolean != false;
        if (!cancel) {
            replicator.start();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("session_id", replicator.getSessionID());
            this.connection.setResponseBody(new Body(result));
        } else {
            replicator.stop();
        }
        return new Status(200);
    }

    public Status do_GET_uuids(Database _db, String _docID, String _attachmentName) {
        int count = Math.min(1000, this.getIntQuery("count", 1));
        ArrayList<String> uuids = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            uuids.add(Database.generateDocumentId());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("uuids", uuids);
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_GET_active_tasks(Database _db, String _docID, String _attachmentName) {
        ArrayList activities = new ArrayList();
        for (Database db : this.manager.allOpenDatabases()) {
            List<Replication> activeReplicators = db.getActiveReplications();
            if (activeReplicators == null) continue;
            for (Replication replicator : activeReplicators) {
                String source = replicator.getRemoteUrl().toExternalForm();
                String target = db.getName();
                if (!replicator.isPull()) {
                    String tmp = source;
                    source = target;
                    target = tmp;
                }
                int processed = replicator.getCompletedChangesCount();
                int total = replicator.getChangesCount();
                String status = String.format("Processed %d / %d changes", processed, total);
                int progress = total > 0 ? Math.round((float)(100 * processed) / (float)total) : 0;
                HashMap<String, Object> activity = new HashMap<String, Object>();
                activity.put("type", "Replication");
                activity.put("task", replicator.getSessionID());
                activity.put("source", source);
                activity.put("target", target);
                activity.put("status", status);
                activity.put("progress", progress);
                if (replicator.getLastError() != null) {
                    String msg = String.format("Replicator error: %s.  Repl: %s.  Source: %s, Target: %s", replicator.getLastError(), replicator, source, target);
                    Log.e("Router", msg);
                    Throwable error = replicator.getLastError();
                    int statusCode = 400;
                    if (error instanceof HttpResponseException) {
                        statusCode = ((HttpResponseException)error).getStatusCode();
                    }
                    Object[] errorObjects = new Object[]{statusCode, replicator.getLastError().toString()};
                    activity.put("error", errorObjects);
                }
                activities.add(activity);
            }
        }
        this.connection.setResponseBody(new Body(activities));
        return new Status(200);
    }

    public Status do_GET_Database(Database _db, String _docID, String _attachmentName) {
        Status status = this.openDB();
        if (!status.isSuccessful()) {
            return status;
        }
        int num_docs = this.db.getDocumentCount();
        long update_seq = this.db.getLastSequenceNumber();
        long instanceStartTimeMicroseconds = this.db.getStartTime() * 1000L;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("db_name", this.db.getName());
        result.put("db_uuid", this.db.publicUUID());
        result.put("doc_count", num_docs);
        result.put("update_seq", update_seq);
        result.put("disk_size", this.db.totalDataSize());
        result.put("instance_start_time", instanceStartTimeMicroseconds);
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_PUT_Database(Database _db, String _docID, String _attachmentName) {
        if (this.db.exists()) {
            return new Status(412);
        }
        if (!this.db.open()) {
            return new Status(500);
        }
        this.setResponseLocation(this.connection.getURL());
        return new Status(201);
    }

    public Status do_DELETE_Database(Database _db, String _docID, String _attachmentName) throws CouchbaseLiteException {
        if (this.getQuery("rev") != null) {
            return new Status(400);
        }
        this.db.delete();
        return new Status(200);
    }

    private void convertCBLQueryRowsToMaps(Map<String, Object> allDocsResult) {
        ArrayList<Map<String, Object>> rowsAsMaps = new ArrayList<Map<String, Object>>();
        List rows = (List)allDocsResult.get("rows");
        if (rows != null) {
            for (QueryRow row : rows) {
                rowsAsMaps.add(row.asJSONDictionary());
            }
        }
        allDocsResult.put("rows", rowsAsMaps);
    }

    public Status do_POST_Database(Database _db, String _docID, String _attachmentName) {
        Status status = this.openDB();
        if (!status.isSuccessful()) {
            return status;
        }
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        return this.update(this.db, null, body, false);
    }

    public Status do_GET_Document_all_docs(Database _db, String _docID, String _attachmentName) throws CouchbaseLiteException {
        QueryOptions options = new QueryOptions();
        if (!this.getQueryOptions(options)) {
            return new Status(400);
        }
        Map<String, Object> result = this.db.getAllDocs(options);
        this.convertCBLQueryRowsToMaps(result);
        if (result == null) {
            return new Status(500);
        }
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_POST_Document_all_docs(Database _db, String _docID, String _attachmentName) throws CouchbaseLiteException {
        QueryOptions options = new QueryOptions();
        if (!this.getQueryOptions(options)) {
            return new Status(400);
        }
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        List keys = (List)body.get("keys");
        options.setKeys(keys);
        Map<String, Object> result = null;
        result = this.db.getAllDocs(options);
        this.convertCBLQueryRowsToMaps(result);
        if (result == null) {
            return new Status(500);
        }
        this.connection.setResponseBody(new Body(result));
        return new Status(200);
    }

    public Status do_POST_facebook_token(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        String email = (String)body.get("email");
        String remoteUrl = (String)body.get("remote_url");
        String accessToken = (String)body.get("access_token");
        if (email != null && remoteUrl != null && accessToken != null) {
            try {
                URL siteUrl = new URL(remoteUrl);
            }
            catch (MalformedURLException e) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("error", "invalid remote_url: " + e.getLocalizedMessage());
                this.connection.setResponseBody(new Body(result));
                return new Status(400);
            }
            try {
                FacebookAuthorizer.registerAccessToken(accessToken, email, remoteUrl);
            }
            catch (Exception e) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("error", "error registering access token: " + e.getLocalizedMessage());
                this.connection.setResponseBody(new Body(result));
                return new Status(400);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ok", "registered");
            this.connection.setResponseBody(new Body(result));
            return new Status(200);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("error", "required fields: access_token, email, remote_url");
        this.connection.setResponseBody(new Body(result));
        return new Status(400);
    }

    public Status do_POST_persona_assertion(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        String assertion = (String)body.get("assertion");
        if (assertion == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "required fields: assertion");
            this.connection.setResponseBody(new Body(result));
            return new Status(400);
        }
        try {
            String email = PersonaAuthorizer.registerAssertion(assertion);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ok", "registered");
            result.put("email", email);
            this.connection.setResponseBody(new Body(result));
            return new Status(200);
        }
        catch (Exception e) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("error", "error registering persona assertion: " + e.getLocalizedMessage());
            this.connection.setResponseBody(new Body(result));
            return new Status(400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status do_POST_Document_bulk_docs(Database _db, String _docID, String _attachmentName) {
        Map<String, Object> bodyDict = this.getBodyAsDictionary();
        if (bodyDict == null) {
            return new Status(400);
        }
        List docs = (List)bodyDict.get("docs");
        boolean noNewEdits = !this.getBooleanValueFromBody("new_edits", bodyDict, true);
        boolean allOrNothing = this.getBooleanValueFromBody("all_or_nothing", bodyDict, false);
        boolean ok = false;
        this.db.beginTransaction();
        ArrayList results = new ArrayList();
        try {
            for (Map doc : docs) {
                String docID = (String)doc.get("_id");
                RevisionInternal rev = null;
                Status status = new Status(200);
                Body docBody = new Body(doc);
                if (noNewEdits) {
                    rev = new RevisionInternal(docBody, this.db);
                    if (rev.getRevId() == null || rev.getDocId() == null || !rev.getDocId().equals(docID)) {
                        status = new Status(400);
                    } else {
                        List<String> history = Database.parseCouchDBRevisionHistory(doc);
                        this.db.forceInsert(rev, history, null);
                    }
                } else {
                    Status outStatus = new Status();
                    rev = this.update(this.db, docID, docBody, false, allOrNothing, outStatus);
                    status.setCode(outStatus.getCode());
                }
                HashMap<String, Object> result = null;
                if (status.isSuccessful()) {
                    result = new HashMap<String, Object>();
                    result.put("ok", true);
                    result.put("id", docID);
                    if (rev != null) {
                        result.put("rev", rev.getRevId());
                    }
                } else {
                    if (allOrNothing) {
                        Status status2 = status;
                        return status2;
                    }
                    if (status.getCode() == 403) {
                        result = new HashMap();
                        result.put("error", "validation failed");
                        result.put("id", docID);
                    } else if (status.getCode() == 409) {
                        result = new HashMap();
                        result.put("error", "conflict");
                        result.put("id", docID);
                    } else {
                        Status status3 = status;
                        return status3;
                    }
                }
                if (result == null) continue;
                results.add(result);
            }
            Log.w("Router", "%s finished inserting %d revisions in bulk", this, docs.size());
            ok = true;
        }
        catch (Exception e) {
            Log.e("Router", "%s: Exception inserting revisions in bulk", e, this);
        }
        finally {
            this.db.endTransaction(ok);
        }
        this.connection.setResponseBody(new Body(results));
        return new Status(201);
    }

    public Status do_POST_Document_revs_diff(Database _db, String _docID, String _attachmentName) {
        RevisionList revs = new RevisionList();
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(493);
        }
        for (String docID : body.keySet()) {
            List revIDs = (List)body.get(docID);
            for (String revID : revIDs) {
                RevisionInternal rev = new RevisionInternal(docID, revID, false, this.db);
                revs.add(rev);
            }
        }
        try {
            this.db.findMissingRevisions(revs);
        }
        catch (SQLException e) {
            Log.e("Router", "Exception", e);
            return new Status(590);
        }
        HashMap<String, Object> diffs = new HashMap<String, Object>();
        for (RevisionInternal rev : revs) {
            String docID = rev.getDocId();
            ArrayList<String> missingRevs = null;
            HashMap<String, ArrayList<String>> idObj = (HashMap<String, ArrayList<String>>)diffs.get(docID);
            if (idObj != null) {
                missingRevs = (ArrayList<String>)idObj.get("missing");
            } else {
                idObj = new HashMap<String, ArrayList<String>>();
            }
            if (missingRevs == null) {
                missingRevs = new ArrayList<String>();
                idObj.put("missing", missingRevs);
                diffs.put(docID, idObj);
            }
            missingRevs.add(rev.getRevId());
        }
        this.connection.setResponseBody(new Body(diffs));
        return new Status(200);
    }

    public Status do_POST_Document_compact(Database _db, String _docID, String _attachmentName) {
        Status status = new Status(200);
        try {
            _db.compact();
        }
        catch (CouchbaseLiteException e) {
            status = e.getCBLStatus();
        }
        if (status.getCode() < 300) {
            Status outStatus = new Status();
            outStatus.setCode(202);
            return outStatus;
        }
        return status;
    }

    public Status do_POST_Document_purge(Database _db, String ignored1, String ignored2) {
        Map<String, Object> body = this.getBodyAsDictionary();
        if (body == null) {
            return new Status(400);
        }
        final HashMap<String, List> docsToRevs = new HashMap<String, List>();
        for (String key : body.keySet()) {
            Object val = body.get(key);
            if (!(val instanceof List)) continue;
            docsToRevs.put(key, (List)val);
        }
        final ArrayList asyncApiCallResponse = new ArrayList();
        Future future = this.db.runAsync(new AsyncTask(){

            @Override
            public void run(Database database) {
                Map<String, Object> purgedRevisions = Router.this.db.purgeRevisions(docsToRevs);
                asyncApiCallResponse.add(purgedRevisions);
            }
        });
        try {
            future.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.e("Router", "Exception waiting for future", e);
            return new Status(500);
        }
        catch (ExecutionException e) {
            Log.e("Router", "Exception waiting for future", e);
            return new Status(500);
        }
        catch (TimeoutException e) {
            Log.e("Router", "Exception waiting for future", e);
            return new Status(500);
        }
        Map purgedRevisions = (Map)asyncApiCallResponse.get(0);
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        responseMap.put("purged", purgedRevisions);
        Body responseBody = new Body(responseMap);
        this.connection.setResponseBody(responseBody);
        return new Status(200);
    }

    public Status do_POST_Document_ensure_full_commit(Database _db, String _docID, String _attachmentName) {
        return new Status(200);
    }

    public Map<String, Object> changesDictForRevision(RevisionInternal rev) {
        HashMap<String, String> changesDict = new HashMap<String, String>();
        changesDict.put("rev", rev.getRevId());
        ArrayList<HashMap<String, String>> changes = new ArrayList<HashMap<String, String>>();
        changes.add(changesDict);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("seq", rev.getSequence());
        result.put("id", rev.getDocId());
        result.put("changes", changes);
        if (rev.isDeleted()) {
            result.put("deleted", true);
        }
        if (this.changesIncludesDocs) {
            result.put("doc", rev.getProperties());
        }
        return result;
    }

    public Map<String, Object> responseBodyForChanges(List<RevisionInternal> changes, long since) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        for (RevisionInternal rev : changes) {
            Map<String, Object> changeDict = this.changesDictForRevision(rev);
            results.add(changeDict);
        }
        if (changes.size() > 0) {
            since = changes.get(changes.size() - 1).getSequence();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("results", results);
        result.put("last_seq", since);
        return result;
    }

    public Map<String, Object> responseBodyForChangesWithConflicts(List<RevisionInternal> changes, long since) {
        Long lastSeq;
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();
        String lastDocID = null;
        Map<String, Object> lastEntry = null;
        for (RevisionInternal rev : changes) {
            String docID = rev.getDocId();
            if (docID.equals(lastDocID)) {
                HashMap<String, String> changesDict = new HashMap<String, String>();
                changesDict.put("rev", rev.getRevId());
                List inchanges = (List)lastEntry.get("changes");
                inchanges.add(changesDict);
                continue;
            }
            lastEntry = this.changesDictForRevision(rev);
            entries.add(lastEntry);
            lastDocID = docID;
        }
        Collections.sort(entries, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> e1, Map<String, Object> e2) {
                return Misc.TDSequenceCompare((Long)e1.get("seq"), (Long)e2.get("seq"));
            }
        });
        if (entries.size() == 0) {
            lastSeq = since;
        } else {
            lastSeq = (Long)((Map)entries.get(entries.size() - 1)).get("seq");
            if (lastSeq == null) {
                lastSeq = since;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("results", entries);
        result.put("last_seq", lastSeq);
        return result;
    }

    public void sendContinuousChange(RevisionInternal rev) {
        Map<String, Object> changeDict = this.changesDictForRevision(rev);
        try {
            String jsonString = Manager.getObjectMapper().writeValueAsString(changeDict);
            if (this.callbackBlock != null) {
                byte[] json = (jsonString + "\n").getBytes();
                OutputStream os = this.connection.getResponseOutputStream();
                try {
                    os.write(json);
                    os.flush();
                }
                catch (Exception e) {
                    Log.e("Router", "IOException writing to internal streams", e);
                }
            }
        }
        catch (Exception e) {
            Log.w("Unable to serialize change to JSON", e);
        }
    }

    @Override
    public void changed(Database.ChangeEvent event) {
        List<DocumentChange> changes = event.getChanges();
        for (DocumentChange change : changes) {
            RevisionInternal rev = change.getAddedRevision();
            Map<String, Object> paramsFixMe = null;
            boolean allowRevision = event.getSource().runFilter(this.changesFilter, paramsFixMe, rev);
            if (!allowRevision) {
                return;
            }
            if (this.longpoll) {
                Log.w("Router", "Router: Sending longpoll response");
                this.sendResponse();
                ArrayList<RevisionInternal> revs = new ArrayList<RevisionInternal>();
                revs.add(rev);
                Map<String, Object> body = this.responseBodyForChanges(revs, 0L);
                if (this.callbackBlock == null) continue;
                byte[] data = null;
                try {
                    data = Manager.getObjectMapper().writeValueAsBytes(body);
                }
                catch (Exception e) {
                    Log.w("Router", "Error serializing JSON", e);
                }
                OutputStream os = this.connection.getResponseOutputStream();
                try {
                    os.write(data);
                    os.close();
                }
                catch (IOException e) {
                    Log.e("Router", "IOException writing to internal streams", e);
                }
                continue;
            }
            Log.w("Router", "Router: Sending continous change chunk");
            this.sendContinuousChange(rev);
        }
    }

    public Status do_GET_Document_changes(Database _db, String docID, String _attachmentName) {
        boolean continuous;
        RevisionList changes;
        ChangesOptions options = new ChangesOptions();
        this.changesIncludesDocs = this.getBooleanQuery("include_docs");
        options.setIncludeDocs(this.changesIncludesDocs);
        String style = this.getQuery("style");
        if (style != null && style.equals("all_docs")) {
            options.setIncludeConflicts(true);
        }
        options.setContentOptions(this.getContentOptions());
        options.setSortBySequence(!options.isIncludeConflicts());
        options.setLimit(this.getIntQuery("limit", options.getLimit()));
        int since = this.getIntQuery("since", 0);
        String filterName = this.getQuery("filter");
        if (filterName != null) {
            this.changesFilter = this.db.getFilter(filterName);
            if (this.changesFilter == null) {
                return new Status(404);
            }
        }
        if ((changes = this.db.changesSince(since, options, this.changesFilter)) == null) {
            return new Status(500);
        }
        String feed = this.getQuery("feed");
        this.longpoll = "longpoll".equals(feed);
        boolean bl = continuous = !this.longpoll && "continuous".equals(feed);
        if (continuous || this.longpoll && changes.size() == 0) {
            this.connection.setChunked(true);
            this.connection.setResponseCode(200);
            this.sendResponse();
            if (continuous) {
                for (RevisionInternal rev : changes) {
                    this.sendContinuousChange(rev);
                }
            }
            this.db.addChangeListener(this);
            return new Status(0);
        }
        if (options.isIncludeConflicts()) {
            this.connection.setResponseBody(new Body(this.responseBodyForChangesWithConflicts(changes, since)));
        } else {
            this.connection.setResponseBody(new Body(this.responseBodyForChanges(changes, since)));
        }
        return new Status(200);
    }

    public String getRevIDFromIfMatchHeader() {
        String ifMatch = this.connection.getRequestProperty("If-Match");
        if (ifMatch == null) {
            return null;
        }
        if (ifMatch.length() > 2 && ifMatch.startsWith("\"") && ifMatch.endsWith("\"")) {
            return ifMatch.substring(1, ifMatch.length() - 2);
        }
        return null;
    }

    public String setResponseEtag(RevisionInternal rev) {
        String eTag = String.format("\"%s\"", rev.getRevId());
        this.connection.getResHeader().add("Etag", eTag);
        return eTag;
    }

    public Status do_GET_Document(Database _db, String docID, String _attachmentName) {
        try {
            boolean isLocalDoc = docID.startsWith("_local");
            EnumSet<Database.TDContentOptions> options = this.getContentOptions();
            String openRevsParam = this.getQuery("open_revs");
            if (openRevsParam == null || isLocalDoc) {
                String revID = this.getQuery("rev");
                RevisionInternal rev = null;
                if (isLocalDoc) {
                    rev = this.db.getLocalDocument(docID, revID);
                } else {
                    String ancestorId;
                    rev = this.db.getDocumentWithIDAndRev(docID, revID, options);
                    List attsSince = (List)this.getJSONQuery("atts_since");
                    if (attsSince != null && (ancestorId = this.db.findCommonAncestorOf(rev, attsSince)) != null) {
                        int generation = RevisionInternal.generationFromRevID(ancestorId);
                        this.db.stubOutAttachmentsIn(rev, generation + 1);
                    }
                }
                if (rev == null) {
                    return new Status(404);
                }
                if (this.cacheWithEtag(rev.getRevId())) {
                    return new Status(304);
                }
                this.connection.setResponseBody(rev.getBody());
            } else {
                String acceptMultipart;
                ArrayList result = null;
                if (openRevsParam.equals("all")) {
                    RevisionList allRevs = this.db.getAllRevisionsOfDocumentID(docID, true);
                    result = new ArrayList(allRevs.size());
                    for (RevisionInternal rev : allRevs) {
                        try {
                            this.db.loadRevisionBody(rev, options);
                        }
                        catch (CouchbaseLiteException e) {
                            if (e.getCBLStatus().getCode() != 500) {
                                HashMap<String, String> dict = new HashMap<String, String>();
                                dict.put("missing", rev.getRevId());
                                result.add(dict);
                            }
                            throw e;
                        }
                        HashMap<String, Map<String, Object>> dict = new HashMap<String, Map<String, Object>>();
                        dict.put("ok", rev.getProperties());
                        result.add(dict);
                    }
                } else {
                    List openRevs = (List)this.getJSONQuery("open_revs");
                    if (openRevs == null) {
                        return new Status(400);
                    }
                    result = new ArrayList(openRevs.size());
                    for (String revID : openRevs) {
                        HashMap<String, Object> dict;
                        RevisionInternal rev = this.db.getDocumentWithIDAndRev(docID, revID, options);
                        if (rev != null) {
                            dict = new HashMap<String, Object>();
                            dict.put("ok", rev.getProperties());
                            result.add(dict);
                            continue;
                        }
                        dict = new HashMap();
                        dict.put("missing", revID);
                        result.add(dict);
                    }
                }
                if ((acceptMultipart = this.getMultipartRequestType()) != null) {
                    throw new UnsupportedOperationException();
                }
                this.connection.setResponseBody(new Body(result));
            }
            return new Status(200);
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
    }

    public Status do_GET_Attachment(Database _db, String docID, String _attachmentName) {
        try {
            EnumSet<Database.TDContentOptions> options = this.getContentOptions();
            options.add(Database.TDContentOptions.TDNoBody);
            String revID = this.getQuery("rev");
            RevisionInternal rev = this.db.getDocumentWithIDAndRev(docID, revID, options);
            if (rev == null) {
                return new Status(404);
            }
            if (this.cacheWithEtag(rev.getRevId())) {
                return new Status(304);
            }
            String type = null;
            String acceptEncoding = this.connection.getRequestProperty("accept-encoding");
            Attachment contents = this.db.getAttachmentForSequence(rev.getSequence(), _attachmentName);
            if (contents == null) {
                return new Status(404);
            }
            type = contents.getContentType();
            if (type != null) {
                this.connection.getResHeader().add("Content-Type", type);
            }
            if (acceptEncoding != null && acceptEncoding.contains("gzip") && contents.getGZipped()) {
                this.connection.getResHeader().add("Content-Encoding", "gzip");
            }
            this.connection.setResponseInputStream(contents.getContent());
            return new Status(200);
        }
        catch (CouchbaseLiteException e) {
            return e.getCBLStatus();
        }
    }

    public RevisionInternal update(Database _db, String docID, Body body, boolean deleting, boolean allowConflict, Status outStatus) {
        assert (body != null);
        boolean isLocalDoc = docID != null && docID.startsWith("_local");
        String prevRevID = null;
        if (!deleting) {
            Boolean deletingBoolean = (Boolean)body.getPropertyForKey("_deleted");
            boolean bl = deleting = deletingBoolean != null && deletingBoolean != false;
            if (docID == null) {
                if (isLocalDoc) {
                    outStatus.setCode(405);
                    return null;
                }
                docID = (String)body.getPropertyForKey("_id");
                if (docID == null) {
                    if (deleting) {
                        outStatus.setCode(400);
                        return null;
                    }
                    docID = Database.generateDocumentId();
                }
            }
            prevRevID = (String)body.getPropertyForKey("_rev");
        } else {
            prevRevID = this.getQuery("rev");
        }
        if (prevRevID == null) {
            prevRevID = this.getRevIDFromIfMatchHeader();
        }
        RevisionInternal rev = new RevisionInternal(docID, null, deleting, this.db);
        rev.setBody(body);
        RevisionInternal result = null;
        try {
            result = isLocalDoc ? _db.putLocalRevision(rev, prevRevID) : _db.putRevision(rev, prevRevID, allowConflict);
            if (deleting) {
                outStatus.setCode(200);
            } else {
                outStatus.setCode(201);
            }
        }
        catch (CouchbaseLiteException e) {
            e.printStackTrace();
            Log.e("Router", "Error updating doc: %s", e, docID);
            outStatus.setCode(e.getCBLStatus().getCode());
        }
        return result;
    }

    public Status update(Database _db, String docID, Map<String, Object> bodyDict, boolean deleting) {
        String revParam;
        Body body = new Body(bodyDict);
        Status status = new Status();
        if (docID != null && !docID.isEmpty() && (revParam = this.getQuery("rev")) != null && bodyDict != null && bodyDict.size() > 0) {
            String revProp = (String)bodyDict.get("_rev");
            if (revProp == null) {
                bodyDict.put("_rev", revParam);
                body = new Body(bodyDict);
            } else if (!revParam.equals(revProp)) {
                throw new IllegalArgumentException("Mismatch between _rev and rev");
            }
        }
        RevisionInternal rev = this.update(_db, docID, body, deleting, false, status);
        if (status.isSuccessful()) {
            this.cacheWithEtag(rev.getRevId());
            if (!deleting) {
                URL url = this.connection.getURL();
                String urlString = url.toExternalForm();
                if (docID != null) {
                    urlString = urlString + "/" + rev.getDocId();
                    try {
                        url = new URL(urlString);
                    }
                    catch (MalformedURLException e) {
                        Log.w("Malformed URL", e);
                    }
                }
                this.setResponseLocation(url);
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("ok", true);
            result.put("id", rev.getDocId());
            result.put("rev", rev.getRevId());
            this.connection.setResponseBody(new Body(result));
        }
        return status;
    }

    public Status do_PUT_Document(Database _db, String docID, String _attachmentName) throws CouchbaseLiteException {
        Status status = new Status(201);
        Map<String, Object> bodyDict = this.getBodyAsDictionary();
        if (bodyDict == null) {
            throw new CouchbaseLiteException(400);
        }
        if (this.getQuery("new_edits") == null || this.getQuery("new_edits") != null && new Boolean(this.getQuery("new_edits")).booleanValue()) {
            status = this.update(_db, docID, bodyDict, false);
        } else {
            Body body = new Body(bodyDict);
            RevisionInternal rev = new RevisionInternal(body, _db);
            if (rev.getRevId() == null || rev.getDocId() == null || !rev.getDocId().equals(docID)) {
                throw new CouchbaseLiteException(400);
            }
            List<String> history = Database.parseCouchDBRevisionHistory(body.getProperties());
            this.db.forceInsert(rev, history, null);
        }
        return status;
    }

    public Status do_DELETE_Document(Database _db, String docID, String _attachmentName) {
        return this.update(_db, docID, null, true);
    }

    public Status updateAttachment(String attachment, String docID, InputStream contentStream) throws CouchbaseLiteException {
        Status status = new Status(200);
        String revID = this.getQuery("rev");
        if (revID == null) {
            revID = this.getRevIDFromIfMatchHeader();
        }
        BlobStoreWriter body = new BlobStoreWriter(this.db.getAttachments());
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            StreamUtils.copyStream(contentStream, dataStream);
            body.appendData(dataStream.toByteArray());
            body.finish();
        }
        catch (IOException e) {
            throw new CouchbaseLiteException(491);
        }
        RevisionInternal rev = this.db.updateAttachment(attachment, body, this.connection.getRequestProperty("content-type"), AttachmentInternal.AttachmentEncoding.AttachmentEncodingNone, docID, revID);
        HashMap<String, Object> resultDict = new HashMap<String, Object>();
        resultDict.put("ok", true);
        resultDict.put("id", rev.getDocId());
        resultDict.put("rev", rev.getRevId());
        this.connection.setResponseBody(new Body(resultDict));
        this.cacheWithEtag(rev.getRevId());
        if (contentStream != null) {
            this.setResponseLocation(this.connection.getURL());
        }
        return status;
    }

    public Status do_PUT_Attachment(Database _db, String docID, String _attachmentName) throws CouchbaseLiteException {
        return this.updateAttachment(_attachmentName, docID, this.connection.getRequestInputStream());
    }

    public Status do_DELETE_Attachment(Database _db, String docID, String _attachmentName) throws CouchbaseLiteException {
        return this.updateAttachment(_attachmentName, docID, null);
    }

    public View compileView(String viewName, Map<String, Object> viewProps) {
        String mapSource;
        String language = (String)viewProps.get("language");
        if (language == null) {
            language = "javascript";
        }
        if ((mapSource = (String)viewProps.get("map")) == null) {
            return null;
        }
        Mapper mapBlock = View.getCompiler().compileMap(mapSource, language);
        if (mapBlock == null) {
            Log.w("Router", "View %s has unknown map function: %s", viewName, mapSource);
            return null;
        }
        String reduceSource = (String)viewProps.get("reduce");
        Reducer reduceBlock = null;
        if (reduceSource != null && (reduceBlock = View.getCompiler().compileReduce(reduceSource, language)) == null) {
            Log.w("Router", "View %s has unknown reduce function: %s", viewName, reduceBlock);
            return null;
        }
        View view = this.db.getView(viewName);
        view.setMapReduce(mapBlock, reduceBlock, "1");
        String collation = (String)viewProps.get("collation");
        if ("raw".equals(collation)) {
            view.setCollation(View.TDViewCollation.TDViewCollationRaw);
        }
        return view;
    }

    public Status queryDesignDoc(String designDoc, String viewName, List<Object> keys) throws CouchbaseLiteException {
        String tdViewName = String.format("%s/%s", designDoc, viewName);
        View view = this.db.getExistingView(tdViewName);
        if (view == null || view.getMap() == null) {
            RevisionInternal rev = this.db.getDocumentWithIDAndRev(String.format("_design/%s", designDoc), null, EnumSet.noneOf(Database.TDContentOptions.class));
            if (rev == null) {
                return new Status(404);
            }
            Map views = (Map)rev.getProperties().get("views");
            Map viewProps = (Map)views.get(viewName);
            if (viewProps == null) {
                return new Status(404);
            }
            view = this.compileView(tdViewName, viewProps);
            if (view == null) {
                return new Status(500);
            }
        }
        QueryOptions options = new QueryOptions();
        if (view.getReduce() != null) {
            options.setReduce(true);
        }
        if (!this.getQueryOptions(options)) {
            return new Status(400);
        }
        if (keys != null) {
            options.setKeys(keys);
        }
        view.updateIndex();
        long lastSequenceIndexed = view.getLastSequenceIndexed();
        if (keys == null) {
            long eTag;
            long l = eTag = options.isIncludeDocs() ? this.db.getLastSequenceNumber() : lastSequenceIndexed;
            if (this.cacheWithEtag(String.format("%d", eTag))) {
                return new Status(304);
            }
        }
        List<QueryRow> queryRows = view.queryWithOptions(options);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        for (QueryRow queryRow : queryRows) {
            rows.add(queryRow.asJSONDictionary());
        }
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        responseBody.put("rows", rows);
        responseBody.put("total_rows", rows.size());
        responseBody.put("offset", options.getSkip());
        if (options.isUpdateSeq()) {
            responseBody.put("update_seq", lastSequenceIndexed);
        }
        this.connection.setResponseBody(new Body(responseBody));
        return new Status(200);
    }

    public Status do_GET_DesignDocument(Database _db, String designDocID, String viewName) throws CouchbaseLiteException {
        return this.queryDesignDoc(designDocID, viewName, null);
    }

    public Status do_POST_DesignDocument(Database _db, String designDocID, String viewName) throws CouchbaseLiteException {
        Map<String, Object> bodyDict = this.getBodyAsDictionary();
        if (bodyDict == null) {
            return new Status(400);
        }
        List keys = (List)bodyDict.get("keys");
        return this.queryDesignDoc(designDocID, viewName, keys);
    }

    public String toString() {
        String url = "Unknown";
        if (this.connection != null && this.connection.getURL() != null) {
            url = this.connection.getURL().toExternalForm();
        }
        return String.format("Router [%s]", url);
    }
}

