/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.NetworkReachabilityListener;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.auth.Authenticator;
import com.couchbase.lite.auth.AuthenticatorImpl;
import com.couchbase.lite.auth.FacebookAuthorizer;
import com.couchbase.lite.auth.PersonaAuthorizer;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.support.Batcher;
import com.couchbase.lite.support.CouchbaseLiteHttpClientFactory;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.PersistentCookieStore;
import com.couchbase.lite.support.RemoteMultipartDownloaderRequest;
import com.couchbase.lite.support.RemoteMultipartRequest;
import com.couchbase.lite.support.RemoteRequest;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.TextUtils;
import com.couchbase.lite.util.URIUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpResponseException;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.impl.cookie.BasicClientCookie2;

public abstract class Replication
implements NetworkReachabilityListener {
    private static int lastSessionID = 0;
    protected boolean continuous;
    protected String filterName;
    protected ScheduledExecutorService workExecutor;
    protected Database db;
    protected URL remote;
    protected String lastSequence;
    protected boolean lastSequenceChanged;
    protected Map<String, Object> remoteCheckpoint;
    protected boolean savingCheckpoint;
    protected boolean overdueForSave;
    protected boolean running;
    protected boolean active;
    protected Throwable error;
    protected String sessionID;
    protected Batcher<RevisionInternal> batcher;
    protected int asyncTaskCount;
    protected AtomicInteger completedChangesCount;
    private AtomicInteger changesCount;
    protected boolean online;
    protected HttpClientFactory clientFactory;
    private final List<ChangeListener> changeListeners;
    protected List<String> documentIDs;
    protected Map<String, Object> filterParams;
    protected ExecutorService remoteRequestExecutor;
    protected Authenticator authenticator;
    private ReplicationStatus status = ReplicationStatus.REPLICATION_STOPPED;
    protected Map<String, Object> requestHeaders;
    private int revisionsFailed;
    private ScheduledFuture retryIfReadyFuture;
    private final Map<RemoteRequest, Future> requests;
    private String serverType;
    private String remoteCheckpointDocID;
    private CollectionUtils.Functor<Map<String, Object>, Map<String, Object>> propertiesTransformationBlock;
    protected CollectionUtils.Functor<RevisionInternal, RevisionInternal> revisionBodyTransformationBlock;
    protected static final int PROCESSOR_DELAY = 500;
    protected static final int INBOX_CAPACITY = 100;
    protected static final int RETRY_DELAY = 60;
    protected static final int EXECUTOR_THREAD_POOL_SIZE = 5;
    public static final String BY_CHANNEL_FILTER_NAME = "sync_gateway/bychannel";
    public static final String CHANNELS_QUERY_PARAM = "channels";
    public static final String REPLICATOR_DATABASE_NAME = "_replicator";

    @InterfaceAudience.Private
    Replication(Database db, URL remote, boolean continuous, ScheduledExecutorService workExecutor) {
        this(db, remote, continuous, null, workExecutor);
    }

    @InterfaceAudience.Private
    Replication(Database db, URL remote, boolean continuous, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor) {
        this.db = db;
        this.continuous = continuous;
        this.workExecutor = workExecutor;
        this.remote = remote;
        this.remoteRequestExecutor = Executors.newFixedThreadPool(5);
        this.changeListeners = new CopyOnWriteArrayList<ChangeListener>();
        this.online = true;
        this.requestHeaders = new HashMap<String, Object>();
        this.requests = new ConcurrentHashMap<RemoteRequest, Future>();
        this.completedChangesCount = new AtomicInteger(0);
        this.changesCount = new AtomicInteger(0);
        if (remote.getQuery() != null && !remote.getQuery().isEmpty()) {
            String facebookAccessToken;
            URI uri = URI.create(remote.toExternalForm());
            String personaAssertion = URIUtils.getQueryParameter(uri, "personaAssertion");
            if (personaAssertion != null && !personaAssertion.isEmpty()) {
                String email = PersonaAuthorizer.registerAssertion(personaAssertion);
                PersonaAuthorizer authorizer = new PersonaAuthorizer(email);
                this.setAuthenticator(authorizer);
            }
            if ((facebookAccessToken = URIUtils.getQueryParameter(uri, "facebookAccessToken")) != null && !facebookAccessToken.isEmpty()) {
                String email = URIUtils.getQueryParameter(uri, "email");
                FacebookAuthorizer authorizer = new FacebookAuthorizer(email);
                URL remoteWithQueryRemoved = null;
                try {
                    remoteWithQueryRemoved = new URL(remote.getProtocol(), remote.getHost(), remote.getPort(), remote.getPath());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
                FacebookAuthorizer.registerAccessToken(facebookAccessToken, email, remoteWithQueryRemoved.toExternalForm());
                this.setAuthenticator(authorizer);
            }
            try {
                this.remote = new URL(remote.getProtocol(), remote.getHost(), remote.getPort(), remote.getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.batcher = new Batcher<RevisionInternal>(workExecutor, 100, 500, new BatchProcessor<RevisionInternal>(){

            @Override
            public void process(List<RevisionInternal> inbox) {
                try {
                    Log.v("Sync", "*** %s: BEGIN processInbox (%d sequences)", this, inbox.size());
                    Replication.this.processInbox(new RevisionList(inbox));
                    Log.v("Sync", "*** %s: END processInbox (lastSequence=%s)", this, Replication.this.lastSequence);
                    Replication.this.updateActive();
                }
                catch (Exception e) {
                    Log.e("Sync", "ERROR: processInbox failed: ", e);
                    throw new RuntimeException(e);
                }
            }
        });
        this.setClientFactory(clientFactory);
    }

    @InterfaceAudience.Private
    protected void setClientFactory(HttpClientFactory clientFactory) {
        Manager manager = null;
        if (this.db != null) {
            manager = this.db.getManager();
        }
        HttpClientFactory managerClientFactory = null;
        if (manager != null) {
            managerClientFactory = manager.getDefaultHttpClientFactory();
        }
        if (clientFactory != null) {
            this.clientFactory = clientFactory;
        } else if (managerClientFactory != null) {
            this.clientFactory = managerClientFactory;
        } else {
            PersistentCookieStore cookieStore = this.db.getPersistentCookieStore();
            this.clientFactory = new CouchbaseLiteHttpClientFactory(cookieStore);
        }
    }

    @InterfaceAudience.Public
    public Database getLocalDatabase() {
        return this.db;
    }

    @InterfaceAudience.Public
    public URL getRemoteUrl() {
        return this.remote;
    }

    @InterfaceAudience.Public
    public abstract boolean isPull();

    @InterfaceAudience.Public
    public abstract boolean shouldCreateTarget();

    @InterfaceAudience.Public
    public abstract void setCreateTarget(boolean var1);

    @InterfaceAudience.Public
    public boolean isContinuous() {
        return this.continuous;
    }

    @InterfaceAudience.Public
    public void setContinuous(boolean continuous) {
        if (!this.isRunning()) {
            this.continuous = continuous;
        }
    }

    @InterfaceAudience.Public
    public String getFilter() {
        return this.filterName;
    }

    @InterfaceAudience.Public
    public void setFilter(String filterName) {
        this.filterName = filterName;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getFilterParams() {
        return this.filterParams;
    }

    @InterfaceAudience.Public
    public void setFilterParams(Map<String, Object> filterParams) {
        this.filterParams = filterParams;
    }

    @InterfaceAudience.Public
    public List<String> getChannels() {
        if (this.filterParams == null || this.filterParams.isEmpty()) {
            return new ArrayList<String>();
        }
        String params = (String)this.filterParams.get(CHANNELS_QUERY_PARAM);
        if (!this.isPull() || this.getFilter() == null || !this.getFilter().equals(BY_CHANNEL_FILTER_NAME) || params == null || params.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] paramsArray = params.split(",");
        return new ArrayList<String>(Arrays.asList(paramsArray));
    }

    @InterfaceAudience.Public
    public void setChannels(List<String> channels) {
        if (channels != null && !channels.isEmpty()) {
            if (!this.isPull()) {
                Log.w("Sync", "filterChannels can only be set in pull replications");
                return;
            }
            this.setFilter(BY_CHANNEL_FILTER_NAME);
            HashMap<String, Object> filterParams = new HashMap<String, Object>();
            filterParams.put(CHANNELS_QUERY_PARAM, TextUtils.join(",", channels));
            this.setFilterParams(filterParams);
        } else if (this.getFilter().equals(BY_CHANNEL_FILTER_NAME)) {
            this.setFilter(null);
            this.setFilterParams(null);
        }
    }

    @InterfaceAudience.Public
    public Map<String, Object> getHeaders() {
        return this.requestHeaders;
    }

    @InterfaceAudience.Public
    public void setHeaders(Map<String, Object> requestHeadersParam) {
        if (requestHeadersParam != null && !((Object)this.requestHeaders).equals(requestHeadersParam)) {
            this.requestHeaders = requestHeadersParam;
        }
    }

    @InterfaceAudience.Public
    public List<String> getDocIds() {
        return this.documentIDs;
    }

    @InterfaceAudience.Public
    public void setDocIds(List<String> docIds) {
        this.documentIDs = docIds;
    }

    @InterfaceAudience.Public
    public ReplicationStatus getStatus() {
        return this.status;
    }

    @InterfaceAudience.Public
    public int getCompletedChangesCount() {
        return this.completedChangesCount.get();
    }

    @InterfaceAudience.Public
    public int getChangesCount() {
        return this.changesCount.get();
    }

    @InterfaceAudience.Public
    public boolean isRunning() {
        return this.running;
    }

    @InterfaceAudience.Public
    public Throwable getLastError() {
        return this.error;
    }

    @InterfaceAudience.Public
    public void start() {
        if (!this.db.isOpen()) {
            Log.w("Sync", "Not starting replication because db.isOpen() returned false.");
            return;
        }
        if (this.running) {
            return;
        }
        this.db.addReplication(this);
        this.db.addActiveReplication(this);
        final CollectionUtils.Functor<Map<String, Object>, Map<String, Object>> xformer = this.propertiesTransformationBlock;
        if (xformer != null) {
            this.revisionBodyTransformationBlock = new CollectionUtils.Functor<RevisionInternal, RevisionInternal>(){

                @Override
                public RevisionInternal invoke(RevisionInternal rev) {
                    Map<String, Object> properties = rev.getProperties();
                    Map xformedProperties = (Map)xformer.invoke(properties);
                    if (xformedProperties == null) {
                        rev = null;
                    } else if (xformedProperties != properties) {
                        assert (xformedProperties != null);
                        assert (xformedProperties.get("_id").equals(properties.get("_id")));
                        assert (xformedProperties.get("_rev").equals(properties.get("_rev")));
                        RevisionInternal nuRev = new RevisionInternal(rev.getProperties(), Replication.this.db);
                        nuRev.setProperties(xformedProperties);
                        rev = nuRev;
                    }
                    return rev;
                }
            };
        }
        this.sessionID = String.format("repl%03d", ++lastSessionID);
        Log.v("Sync", "%s: STARTING ...", this);
        this.running = true;
        this.lastSequence = null;
        this.checkSession();
        this.db.getManager().getContext().getNetworkReachabilityManager().addNetworkReachabilityListener(this);
    }

    @InterfaceAudience.Public
    public void stop() {
        if (!this.running) {
            return;
        }
        Log.v("Sync", "%s: STOPPING...", this);
        this.batcher.clear();
        this.continuous = false;
        this.stopRemoteRequests();
        this.cancelPendingRetryIfReady();
        if (this.db != null) {
            this.db.forgetReplication(this);
        } else {
            Log.w("Sync", "%s: not calling db.forgetReplication(), since db is null", this);
        }
        if (this.running && this.asyncTaskCount <= 0) {
            Log.v("Sync", "%s: calling stopped()", this);
            this.stopped();
        } else {
            Log.v("Sync", "%s: not calling stopped().  running: %s asyncTaskCount: %d", this, this.running, this.asyncTaskCount);
        }
    }

    @InterfaceAudience.Public
    public void restart() {
        this.stop();
        this.start();
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @InterfaceAudience.Public
    public String toString() {
        String maskedRemoteWithoutCredentials = this.remote != null ? this.remote.toExternalForm() : "";
        maskedRemoteWithoutCredentials = maskedRemoteWithoutCredentials.replaceAll("://.*:.*@", "://---:---@");
        String name = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + maskedRemoteWithoutCredentials + "]";
        return name;
    }

    @InterfaceAudience.Public
    public void setCookie(String name, String value, String path, long maxAge, boolean secure, boolean httpOnly) {
        Date now = new Date();
        Date expirationDate = new Date(now.getTime() + maxAge);
        this.setCookie(name, value, path, expirationDate, secure, httpOnly);
    }

    @InterfaceAudience.Public
    public void setCookie(String name, String value, String path, Date expirationDate, boolean secure, boolean httpOnly) {
        if (this.remote == null) {
            throw new IllegalStateException("Cannot setCookie since remote == null");
        }
        BasicClientCookie2 cookie = new BasicClientCookie2(name, value);
        cookie.setDomain(this.remote.getHost());
        if (path != null && path.length() > 0) {
            cookie.setPath(path);
        } else {
            cookie.setPath(this.remote.getPath());
        }
        cookie.setExpiryDate(expirationDate);
        cookie.setSecure(secure);
        List<Cookie> cookies = Arrays.asList(cookie);
        this.clientFactory.addCookies(cookies);
    }

    @InterfaceAudience.Public
    public void deleteCookie(String name) {
        this.clientFactory.deleteCookie(name);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    @InterfaceAudience.Public
    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @InterfaceAudience.Public
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    @InterfaceAudience.Private
    public void databaseClosing() {
        this.saveLastSequence();
        this.stop();
        this.clearDbRef();
    }

    private void clearDbRef() {
        if (this.savingCheckpoint && this.lastSequence != null && this.db != null) {
            if (!this.db.isOpen()) {
                Log.w("Sync", "Not attempting to setLastSequence, db is closed");
            } else {
                this.db.setLastSequence(this.lastSequence, this.remoteCheckpointDocID(), !this.isPull());
            }
            Log.v("Sync", "%s: clearDbRef() setting db to null", this);
            this.db = null;
        }
    }

    @InterfaceAudience.Private
    public String getLastSequence() {
        return this.lastSequence;
    }

    @InterfaceAudience.Private
    public void setLastSequence(String lastSequenceIn) {
        if (lastSequenceIn != null && !lastSequenceIn.equals(this.lastSequence)) {
            Log.v("Sync", "%s: Setting lastSequence to %s from(%s)", this, lastSequenceIn, this.lastSequence);
            this.lastSequence = lastSequenceIn;
            if (!this.lastSequenceChanged) {
                this.lastSequenceChanged = true;
                this.workExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        Replication.this.saveLastSequence();
                    }
                }, 2000L, TimeUnit.MILLISECONDS);
            }
        }
    }

    @InterfaceAudience.Private
    void addToCompletedChangesCount(int delta) {
        int previousVal = this.completedChangesCount.getAndAdd(delta);
        Log.v("Sync", "%s: Incrementing completedChangesCount count from %s by adding %d -> %d", this, previousVal, delta, this.completedChangesCount.get());
        this.notifyChangeListeners();
    }

    @InterfaceAudience.Private
    void addToChangesCount(int delta) {
        int previousVal = this.changesCount.getAndAdd(delta);
        if (this.changesCount.get() < 0) {
            Log.w("Sync", "Changes count is negative, this could indicate an error");
        }
        Log.v("Sync", "%s: Incrementing changesCount count from %s by adding %d -> %d", this, previousVal, delta, this.changesCount.get());
        this.notifyChangeListeners();
    }

    @InterfaceAudience.Private
    public String getSessionID() {
        return this.sessionID;
    }

    @InterfaceAudience.Private
    protected void checkSession() {
        if (this.getAuthenticator() != null && ((AuthenticatorImpl)this.getAuthenticator()).usesCookieBasedLogin()) {
            this.checkSessionAtPath("/_session");
        } else {
            this.fetchRemoteCheckpointDoc();
        }
    }

    @InterfaceAudience.Private
    protected void checkSessionAtPath(final String sessionPath) {
        Log.d("Sync", "%s: checkSessionAtPath() calling asyncTaskStarted()", this);
        this.asyncTaskStarted();
        this.sendAsyncRequest("GET", sessionPath, null, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable error) {
                try {
                    if (error != null) {
                        if (error instanceof HttpResponseException && ((HttpResponseException)error).getStatusCode() == 404 && sessionPath.equalsIgnoreCase("/_session")) {
                            Replication.this.checkSessionAtPath("_session");
                            return;
                        }
                        Log.e("Sync", this + ": Session check failed", error);
                        Replication.this.setError(error);
                    } else {
                        Map response = (Map)result;
                        Map userCtx = (Map)response.get("userCtx");
                        String username = (String)userCtx.get("name");
                        if (username != null && username.length() > 0) {
                            Log.d("Sync", "%s Active session, logged in as %s", this, username);
                            Replication.this.fetchRemoteCheckpointDoc();
                        } else {
                            Log.d("Sync", "%s No active session, going to login", this);
                            Replication.this.login();
                        }
                    }
                }
                finally {
                    Replication.this.asyncTaskFinished(1);
                }
            }
        });
    }

    @InterfaceAudience.Private
    public abstract void beginReplicating();

    @InterfaceAudience.Private
    protected void stopped() {
        Log.v("Sync", "%s: STOPPED", this);
        this.running = false;
        this.notifyChangeListeners();
        this.saveLastSequence();
        this.batcher = null;
        if (this.db != null) {
            this.db.getManager().getContext().getNetworkReachabilityManager().removeNetworkReachabilityListener(this);
        }
        this.clearDbRef();
    }

    @InterfaceAudience.Private
    private void notifyChangeListeners() {
        this.updateProgress();
        for (ChangeListener listener : this.changeListeners) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            listener.changed(changeEvent);
        }
    }

    @InterfaceAudience.Private
    protected void login() {
        Map<String, String> loginParameters = ((AuthenticatorImpl)this.getAuthenticator()).loginParametersForSite(this.remote);
        if (loginParameters == null) {
            Log.d("Sync", "%s: %s has no login parameters, so skipping login", this, this.getAuthenticator());
            this.fetchRemoteCheckpointDoc();
            return;
        }
        final String loginPath = ((AuthenticatorImpl)this.getAuthenticator()).loginPathForSite(this.remote);
        Log.d("Sync", "%s: Doing login with %s at %s", this, this.getAuthenticator().getClass(), loginPath);
        this.asyncTaskStarted();
        this.sendAsyncRequest("POST", loginPath, loginParameters, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                try {
                    if (e != null) {
                        Log.d("Sync", "%s: Login failed for path: %s", this, loginPath);
                        Replication.this.setError(e);
                    } else {
                        Log.v("Sync", "%s: Successfully logged in!", this);
                        Replication.this.fetchRemoteCheckpointDoc();
                    }
                }
                finally {
                    Replication.this.asyncTaskFinished(1);
                }
            }
        });
    }

    @InterfaceAudience.Private
    public synchronized void asyncTaskStarted() {
        if (this.asyncTaskCount++ == 0) {
            this.updateActive();
        }
    }

    @InterfaceAudience.Private
    public synchronized void asyncTaskFinished(int numTasks) {
        this.asyncTaskCount -= numTasks;
        assert (this.asyncTaskCount >= 0);
        if (this.asyncTaskCount == 0) {
            this.updateActive();
        }
    }

    @InterfaceAudience.Private
    public void updateActive() {
        try {
            boolean newActive;
            int batcherCount = 0;
            if (this.batcher != null) {
                batcherCount = this.batcher.count();
            } else {
                Log.w("Sync", "%s: batcher object is null.", this);
            }
            boolean bl = newActive = batcherCount > 0 || this.asyncTaskCount > 0;
            if (this.active != newActive) {
                Log.d("Sync", "%s: Progress: set active = %s asyncTaskCount: %d batcherCount: ", this, newActive, this.asyncTaskCount, batcherCount);
                this.active = newActive;
                this.notifyChangeListeners();
                if (!this.active) {
                    if (!this.continuous) {
                        Log.d("Sync", "%s since !continuous, calling stopped()", this);
                        this.stopped();
                    } else if (this.error != null) {
                        Log.d("Sync", "%s: Failed to xfer %d revisions, will retry in %d sec", this, this.revisionsFailed, 60);
                        this.cancelPendingRetryIfReady();
                        this.scheduleRetryIfReady();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.e("Sync", "Exception in updateActive()", e);
        }
    }

    @InterfaceAudience.Private
    public void addToInbox(RevisionInternal rev) {
        this.batcher.queueObject(rev);
        this.updateActive();
    }

    @InterfaceAudience.Private
    protected void processInbox(RevisionList inbox) {
    }

    @InterfaceAudience.Private
    public void sendAsyncRequest(String method, String relativePath, Object body, RemoteRequestCompletionBlock onCompletion) {
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            URL url = new URL(urlStr);
            this.sendAsyncRequest(method, url, body, onCompletion);
        }
        catch (MalformedURLException e) {
            Log.e("Sync", "Malformed URL for async request", e);
        }
    }

    @InterfaceAudience.Private
    String buildRelativeURLString(String relativePath) {
        String remoteUrlString = this.remote.toExternalForm();
        if (remoteUrlString.endsWith("/") && relativePath.startsWith("/")) {
            remoteUrlString = remoteUrlString.substring(0, remoteUrlString.length() - 1);
        }
        return remoteUrlString + relativePath;
    }

    @InterfaceAudience.Private
    public void sendAsyncRequest(String method, URL url, Object body, RemoteRequestCompletionBlock onCompletion) {
        final RemoteRequest request = new RemoteRequest(this.workExecutor, this.clientFactory, method, url, body, this.getLocalDatabase(), this.getHeaders(), onCompletion);
        request.setAuthenticator(this.getAuthenticator());
        request.setOnPreCompletion(new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(Object result, Throwable e) {
                HttpResponse response;
                Header serverHeader;
                if (Replication.this.serverType == null && result instanceof HttpResponse && (serverHeader = (response = (HttpResponse)result).getFirstHeader("Server")) != null) {
                    String serverVersion = serverHeader.getValue();
                    Log.v("Sync", "serverVersion: %s", serverVersion);
                    Replication.this.serverType = serverVersion;
                }
            }
        });
        request.setOnPostCompletion(new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(Object result, Throwable e) {
                Replication.this.requests.remove(request);
            }
        });
        if (this.remoteRequestExecutor.isTerminated()) {
            String msg = "sendAsyncRequest called, but remoteRequestExecutor has been terminated";
            throw new IllegalStateException(msg);
        }
        Future<?> future = this.remoteRequestExecutor.submit(request);
        this.requests.put(request, future);
    }

    @InterfaceAudience.Private
    public void sendAsyncMultipartDownloaderRequest(String method, String relativePath, Object body, Database db, RemoteRequestCompletionBlock onCompletion) {
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            URL url = new URL(urlStr);
            RemoteMultipartDownloaderRequest request = new RemoteMultipartDownloaderRequest(this.workExecutor, this.clientFactory, method, url, body, db, this.getHeaders(), onCompletion);
            request.setAuthenticator(this.getAuthenticator());
            this.remoteRequestExecutor.execute(request);
        }
        catch (MalformedURLException e) {
            Log.e("Sync", "Malformed URL for async request", e);
        }
    }

    @InterfaceAudience.Private
    public void sendAsyncMultipartRequest(String method, String relativePath, MultipartEntity multiPartEntity, RemoteRequestCompletionBlock onCompletion) {
        URL url = null;
        try {
            String urlStr = this.buildRelativeURLString(relativePath);
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        RemoteMultipartRequest request = new RemoteMultipartRequest(this.workExecutor, this.clientFactory, method, url, multiPartEntity, this.getLocalDatabase(), this.getHeaders(), onCompletion);
        request.setAuthenticator(this.getAuthenticator());
        this.remoteRequestExecutor.execute(request);
    }

    @InterfaceAudience.Private
    void maybeCreateRemoteDB() {
    }

    @InterfaceAudience.Private
    public String remoteCheckpointDocID() {
        if (this.remoteCheckpointDocID != null) {
            return this.remoteCheckpointDocID;
        }
        if (this.db == null) {
            return null;
        }
        TreeMap<String, Object> filterParamsCanonical = null;
        if (this.getFilterParams() != null) {
            filterParamsCanonical = new TreeMap<String, Object>(this.getFilterParams());
        }
        ArrayList<String> docIdsSorted = null;
        if (this.getDocIds() != null) {
            docIdsSorted = new ArrayList<String>(this.getDocIds());
            Collections.sort(docIdsSorted);
        }
        TreeMap<String, Object> spec = new TreeMap<String, Object>();
        spec.put("localUUID", this.db.privateUUID());
        spec.put("remoteURL", this.remote.toExternalForm());
        spec.put("push", !this.isPull());
        spec.put("continuous", this.isContinuous());
        if (this.getFilter() != null) {
            spec.put("filter", this.getFilter());
        }
        if (filterParamsCanonical != null) {
            spec.put("filterParams", filterParamsCanonical);
        }
        if (docIdsSorted != null) {
            spec.put("docids", docIdsSorted);
        }
        byte[] inputBytes = null;
        try {
            this.db.getManager();
            inputBytes = Manager.getObjectMapper().writeValueAsBytes(spec);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remoteCheckpointDocID = Misc.TDHexSHA1Digest(inputBytes);
        return this.remoteCheckpointDocID;
    }

    @InterfaceAudience.Private
    private boolean is404(Throwable e) {
        if (e instanceof HttpResponseException) {
            return ((HttpResponseException)e).getStatusCode() == 404;
        }
        return false;
    }

    @InterfaceAudience.Private
    public void fetchRemoteCheckpointDoc() {
        this.lastSequenceChanged = false;
        String checkpointId = this.remoteCheckpointDocID();
        final String localLastSequence = this.db.lastSequenceWithCheckpointId(checkpointId);
        this.asyncTaskStarted();
        this.sendAsyncRequest("GET", "/_local/" + checkpointId, null, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                try {
                    if (e != null && !Replication.this.is404(e)) {
                        Log.w("Sync", "%s: error getting remote checkpoint", e, this);
                        Replication.this.setError(e);
                    } else {
                        Map response;
                        if (e != null && Replication.this.is404(e)) {
                            Log.d("Sync", "%s: 404 error getting remote checkpoint %s, calling maybeCreateRemoteDB", this, Replication.this.remoteCheckpointDocID());
                            Replication.this.maybeCreateRemoteDB();
                        }
                        Replication.this.remoteCheckpoint = response = (Map)result;
                        String remoteLastSequence = null;
                        if (response != null) {
                            remoteLastSequence = (String)response.get("lastSequence");
                        }
                        if (remoteLastSequence != null && remoteLastSequence.equals(localLastSequence)) {
                            Replication.this.lastSequence = localLastSequence;
                            Log.d("Sync", "%s: Replicating from lastSequence=%s", this, Replication.this.lastSequence);
                        } else {
                            Log.d("Sync", "%s: lastSequence mismatch: I had: %s, remote had: %s", this, localLastSequence, remoteLastSequence);
                        }
                        Replication.this.beginReplicating();
                    }
                }
                finally {
                    Replication.this.asyncTaskFinished(1);
                }
            }
        });
    }

    @InterfaceAudience.Private
    public void saveLastSequence() {
        if (!this.lastSequenceChanged) {
            return;
        }
        if (this.savingCheckpoint) {
            this.overdueForSave = true;
            return;
        }
        this.lastSequenceChanged = false;
        this.overdueForSave = false;
        Log.d("Sync", "%s: saveLastSequence() called. lastSequence: %s", this, this.lastSequence);
        final HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.remoteCheckpoint != null) {
            body.putAll(this.remoteCheckpoint);
        }
        body.put("lastSequence", this.lastSequence);
        String remoteCheckpointDocID = this.remoteCheckpointDocID();
        if (remoteCheckpointDocID == null) {
            Log.w("Sync", "%s: remoteCheckpointDocID is null, aborting saveLastSequence()", this);
            return;
        }
        this.savingCheckpoint = true;
        final String checkpointID = remoteCheckpointDocID;
        Log.d("Sync", "%s: put remote _local document.  checkpointID: %s", this, checkpointID);
        this.sendAsyncRequest("PUT", "/_local/" + checkpointID, body, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(Object result, Throwable e) {
                Replication.this.savingCheckpoint = false;
                if (e != null) {
                    Log.w("Sync", "%s: Unable to save remote checkpoint", e, this);
                }
                if (Replication.this.db == null) {
                    Log.w("Sync", "%s: Database is null, ignoring remote checkpoint response", this);
                    return;
                }
                if (!Replication.this.db.isOpen()) {
                    Log.w("Sync", "%s: Database is closed, ignoring remote checkpoint response", this);
                    return;
                }
                if (e != null) {
                    switch (Replication.this.getStatusFromError(e)) {
                        case 404: {
                            Replication.this.remoteCheckpoint = null;
                            Replication.this.overdueForSave = true;
                            break;
                        }
                        case 409: {
                            Replication.this.refreshRemoteCheckpointDoc();
                            break;
                        }
                    }
                } else {
                    Map response = (Map)result;
                    body.put("_rev", response.get("rev"));
                    Replication.this.remoteCheckpoint = body;
                    Replication.this.db.setLastSequence(Replication.this.lastSequence, checkpointID, !Replication.this.isPull());
                }
                if (Replication.this.overdueForSave) {
                    Replication.this.saveLastSequence();
                }
            }
        });
    }

    @InterfaceAudience.Public
    public boolean goOffline() {
        if (!this.online) {
            return false;
        }
        if (this.db == null) {
            return false;
        }
        this.db.runAsync(new AsyncTask(){

            @Override
            public void run(Database database) {
                Log.d("Sync", "%s: Going offline", this);
                Replication.this.online = false;
                Replication.this.stopRemoteRequests();
                Replication.this.updateProgress();
                Replication.this.notifyChangeListeners();
            }
        });
        return true;
    }

    @InterfaceAudience.Public
    public boolean goOnline() {
        if (this.online) {
            return false;
        }
        if (this.db == null) {
            return false;
        }
        this.db.runAsync(new AsyncTask(){

            @Override
            public void run(Database database) {
                Log.d("Sync", "%s: Going online", this);
                Replication.this.online = true;
                if (Replication.this.running) {
                    Replication.this.lastSequence = null;
                    Replication.this.setError(null);
                }
                Replication.this.remoteRequestExecutor = Executors.newCachedThreadPool();
                Replication.this.checkSession();
                Replication.this.notifyChangeListeners();
            }
        });
        return true;
    }

    @InterfaceAudience.Private
    private void stopRemoteRequests() {
        Log.v("Sync", "%s: stopRemoteRequests() cancelling: %d requests", this, this.requests.size());
        for (RemoteRequest request : this.requests.keySet()) {
            Future future = this.requests.get(request);
            if (future == null) continue;
            Log.v("Sync", "%s: cancelling future %s for request: %s isCancelled: %s isDone: %s", this, future, request, future.isCancelled(), future.isDone());
            boolean result = future.cancel(true);
            Log.v("Sync", "%s: cancelled future, result: %s", this, result);
        }
    }

    @InterfaceAudience.Private
    void updateProgress() {
        this.status = !this.isRunning() ? ReplicationStatus.REPLICATION_STOPPED : (!this.online ? ReplicationStatus.REPLICATION_OFFLINE : (this.active ? ReplicationStatus.REPLICATION_ACTIVE : ReplicationStatus.REPLICATION_IDLE));
    }

    @InterfaceAudience.Private
    protected void setError(Throwable throwable) {
        if (throwable != this.error) {
            Log.e("Sync", "%s: Progress: set error = %s", this, throwable);
            this.error = throwable;
            this.notifyChangeListeners();
        }
    }

    @InterfaceAudience.Private
    protected void revisionFailed() {
        ++this.revisionsFailed;
    }

    protected RevisionInternal transformRevision(RevisionInternal rev) {
        if (this.revisionBodyTransformationBlock != null) {
            try {
                final int generation = rev.getGeneration();
                RevisionInternal xformed = this.revisionBodyTransformationBlock.invoke(rev);
                if (xformed == null) {
                    return null;
                }
                if (xformed != rev) {
                    assert (xformed.getDocId().equals(rev.getDocId()));
                    assert (xformed.getRevId().equals(rev.getRevId()));
                    assert (xformed.getProperties().get("_revisions").equals(rev.getProperties().get("_revisions")));
                    if (xformed.getProperties().get("_attachments") != null) {
                        RevisionInternal mx;
                        xformed = mx = new RevisionInternal(xformed.getProperties(), this.db);
                        mx.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

                            @Override
                            public Map<String, Object> invoke(Map<String, Object> info) {
                                if (info.get("revpos") != null) {
                                    return info;
                                }
                                if (info.get("data") == null) {
                                    throw new IllegalStateException("Transformer added attachment without adding data");
                                }
                                HashMap<String, Object> nuInfo = new HashMap<String, Object>(info);
                                nuInfo.put("revpos", generation);
                                return nuInfo;
                            }
                        });
                    }
                    rev = xformed;
                }
            }
            catch (Exception e) {
                Log.w("Sync", "%s: Exception transforming a revision of doc '%s", e, this, rev.getDocId());
            }
        }
        return rev;
    }

    @InterfaceAudience.Private
    protected void retry() {
        this.setError(null);
    }

    @InterfaceAudience.Private
    protected void retryIfReady() {
        if (!this.running) {
            return;
        }
        if (this.online) {
            Log.d("Sync", "%s: RETRYING, to transfer missed revisions", this);
            this.revisionsFailed = 0;
            this.cancelPendingRetryIfReady();
            this.retry();
        } else {
            this.scheduleRetryIfReady();
        }
    }

    @InterfaceAudience.Private
    protected void cancelPendingRetryIfReady() {
        if (this.retryIfReadyFuture != null && !this.retryIfReadyFuture.isCancelled()) {
            this.retryIfReadyFuture.cancel(true);
        }
    }

    @InterfaceAudience.Private
    protected void scheduleRetryIfReady() {
        this.retryIfReadyFuture = this.workExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                Replication.this.retryIfReady();
            }
        }, 60L, TimeUnit.SECONDS);
    }

    @InterfaceAudience.Private
    private int getStatusFromError(Throwable t) {
        if (t instanceof CouchbaseLiteException) {
            CouchbaseLiteException couchbaseLiteException = (CouchbaseLiteException)t;
            return couchbaseLiteException.getCBLStatus().getCode();
        }
        return -1;
    }

    @InterfaceAudience.Private
    private void refreshRemoteCheckpointDoc() {
        Log.d("Sync", "%s: Refreshing remote checkpoint to get its _rev...", this);
        this.savingCheckpoint = true;
        this.asyncTaskStarted();
        this.sendAsyncRequest("GET", "/_local/" + this.remoteCheckpointDocID(), null, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                try {
                    if (Replication.this.db == null) {
                        Log.w("Sync", "%s: db == null while refreshing remote checkpoint.  aborting", this);
                        return;
                    }
                    Replication.this.savingCheckpoint = false;
                    if (e != null && Replication.this.getStatusFromError(e) != 404) {
                        Log.e("Sync", "%s: Error refreshing remote checkpoint", e, this);
                    } else {
                        Log.d("Sync", "%s: Refreshed remote checkpoint: %s", this, result);
                        Replication.this.remoteCheckpoint = (Map)result;
                        Replication.this.lastSequenceChanged = true;
                        Replication.this.saveLastSequence();
                    }
                }
                finally {
                    Replication.this.asyncTaskFinished(1);
                }
            }
        });
    }

    @InterfaceAudience.Private
    protected Status statusFromBulkDocsResponseItem(Map<String, Object> item) {
        try {
            if (!item.containsKey("error")) {
                return new Status(200);
            }
            String errorStr = (String)item.get("error");
            if (errorStr == null || errorStr.isEmpty()) {
                return new Status(200);
            }
            String statusString = (String)item.get("status");
            int status = Integer.parseInt(statusString);
            if (status >= 400) {
                return new Status(status);
            }
            if (errorStr.equalsIgnoreCase("unauthorized")) {
                return new Status(401);
            }
            if (errorStr.equalsIgnoreCase("forbidden")) {
                return new Status(403);
            }
            if (errorStr.equalsIgnoreCase("conflict")) {
                return new Status(409);
            }
            return new Status(589);
        }
        catch (Exception e) {
            Log.e("CBLite", "Exception getting status from " + item, e);
            return new Status(200);
        }
    }

    @Override
    @InterfaceAudience.Private
    public void networkReachable() {
        this.goOnline();
    }

    @Override
    @InterfaceAudience.Private
    public void networkUnreachable() {
        this.goOffline();
    }

    @InterfaceAudience.Private
    boolean serverIsSyncGatewayVersion(String minVersion) {
        String prefix = "Couchbase Sync Gateway/";
        if (this.serverType == null) {
            return false;
        }
        if (this.serverType.startsWith(prefix)) {
            String versionString = this.serverType.substring(prefix.length());
            return versionString.compareTo(minVersion) >= 0;
        }
        return false;
    }

    @InterfaceAudience.Private
    void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @InterfaceAudience.Private
    HttpClientFactory getClientFactory() {
        return this.clientFactory;
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private Replication source;

        public ChangeEvent(Replication source) {
            this.source = source;
        }

        public Replication getSource() {
            return this.source;
        }
    }

    public static enum ReplicationStatus {
        REPLICATION_STOPPED,
        REPLICATION_OFFLINE,
        REPLICATION_IDLE,
        REPLICATION_ACTIVE;

    }
}

