/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;

@InterfaceAudience.Private
public final class Pusher
extends Replication
implements Database.ChangeListener {
    private boolean createTarget = false;
    private boolean creatingTarget;
    private boolean observing = false;
    private ReplicationFilter filter;
    private boolean dontSendMultipart = false;
    SortedSet<Long> pendingSequences;
    Long maxPendingSequence;

    @InterfaceAudience.Private
    public Pusher(Database db, URL remote, boolean continuous, ScheduledExecutorService workExecutor) {
        this(db, remote, continuous, null, workExecutor);
    }

    @InterfaceAudience.Private
    public Pusher(Database db, URL remote, boolean continuous, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor) {
        super(db, remote, continuous, clientFactory, workExecutor);
    }

    @Override
    @InterfaceAudience.Public
    public boolean isPull() {
        return false;
    }

    @Override
    @InterfaceAudience.Public
    public boolean shouldCreateTarget() {
        return this.createTarget;
    }

    @Override
    @InterfaceAudience.Public
    public void setCreateTarget(boolean createTarget) {
        this.createTarget = createTarget;
    }

    @Override
    @InterfaceAudience.Public
    public void stop() {
        this.stopObserving();
        super.stop();
    }

    @InterfaceAudience.Private
    private void addPending(RevisionInternal revisionInternal) {
        long seq = revisionInternal.getSequence();
        this.pendingSequences.add(seq);
        if (seq > this.maxPendingSequence) {
            this.maxPendingSequence = seq;
        }
    }

    @InterfaceAudience.Private
    private void removePending(RevisionInternal revisionInternal) {
        boolean wasFirst;
        long seq = revisionInternal.getSequence();
        if (this.pendingSequences.isEmpty()) {
            Log.w("Sync", "%s: removePending called, but pendingSequences.isEmpty()", this);
            return;
        }
        boolean bl = wasFirst = seq == this.pendingSequences.first();
        if (!this.pendingSequences.contains(seq)) {
            Log.w("Sync", "%s: removePending: sequence %s not in set, for rev %s", this, seq, revisionInternal);
        }
        this.pendingSequences.remove(seq);
        if (wasFirst) {
            long maxCompleted;
            if (this.pendingSequences.size() == 0) {
                maxCompleted = this.maxPendingSequence;
            } else {
                maxCompleted = this.pendingSequences.first();
                --maxCompleted;
            }
            this.setLastSequence(Long.toString(maxCompleted));
        }
    }

    @Override
    @InterfaceAudience.Private
    void maybeCreateRemoteDB() {
        if (!this.createTarget) {
            return;
        }
        this.creatingTarget = true;
        Log.v("Sync", "Remote db might not exist; creating it...");
        this.asyncTaskStarted();
        this.sendAsyncRequest("PUT", "", null, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                block3: {
                    try {
                        Pusher.this.creatingTarget = false;
                        if (e != null && e instanceof HttpResponseException && ((HttpResponseException)e).getStatusCode() != 412) {
                            Log.e("Sync", this + ": Failed to create remote db", e);
                            Pusher.this.setError(e);
                            Pusher.this.stop();
                            break block3;
                        }
                        Log.v("Sync", "%s: Created remote db", this);
                        Pusher.this.createTarget = false;
                        Pusher.this.beginReplicating();
                    }
                    catch (Throwable throwable) {
                        Log.d("Sync", "%s: maybeCreateRemoteDB.onComplete() calling asyncTaskFinished()", this);
                        Pusher.this.asyncTaskFinished(1);
                        throw throwable;
                    }
                }
                Log.d("Sync", "%s: maybeCreateRemoteDB.onComplete() calling asyncTaskFinished()", this);
                Pusher.this.asyncTaskFinished(1);
            }
        });
    }

    @Override
    @InterfaceAudience.Private
    public void beginReplicating() {
        Log.d("Sync", "%s: beginReplicating() called", this);
        if (this.creatingTarget) {
            Log.d("Sync", "%s: creatingTarget == true, doing nothing", this);
            return;
        }
        this.pendingSequences = Collections.synchronizedSortedSet(new TreeSet());
        try {
            this.maxPendingSequence = Long.parseLong(this.lastSequence);
        }
        catch (NumberFormatException e) {
            Log.w("Sync", "Error converting lastSequence: %s to long.  Using 0", this.lastSequence);
            this.maxPendingSequence = new Long(0L);
        }
        if (this.filterName != null) {
            this.filter = this.db.getFilter(this.filterName);
        }
        if (this.filterName != null && this.filter == null) {
            Log.w("Sync", "%s: No ReplicationFilter registered for filter '%s'; ignoring", this, this.filterName);
        }
        long lastSequenceLong = 0L;
        if (this.lastSequence != null) {
            lastSequenceLong = Long.parseLong(this.lastSequence);
        }
        ChangesOptions options = new ChangesOptions();
        options.setIncludeConflicts(true);
        RevisionList changes = this.db.changesSince(lastSequenceLong, options, this.filter);
        if (changes.size() > 0) {
            this.batcher.queueObjects(changes);
            this.batcher.flush();
        }
        if (this.continuous) {
            this.observing = true;
            this.db.addChangeListener(this);
        }
    }

    @InterfaceAudience.Private
    private void stopObserving() {
        if (this.observing) {
            this.observing = false;
            this.db.removeChangeListener(this);
        }
    }

    @Override
    @InterfaceAudience.Private
    public void changed(Database.ChangeEvent event) {
        List<DocumentChange> changes = event.getChanges();
        for (DocumentChange change : changes) {
            URL source = change.getSourceUrl();
            if (source != null && source.equals(this.remote)) {
                return;
            }
            RevisionInternal rev = change.getAddedRevision();
            Map<String, Object> paramsFixMe = null;
            if (!this.getLocalDatabase().runFilter(this.filter, paramsFixMe, rev)) continue;
            this.addToInbox(rev);
        }
    }

    @Override
    @InterfaceAudience.Private
    protected void processInbox(final RevisionList changes) {
        HashMap<String, ArrayList<String>> diffs = new HashMap<String, ArrayList<String>>();
        for (RevisionInternal rev : changes) {
            String docID = rev.getDocId();
            ArrayList<String> revs = (ArrayList<String>)diffs.get(docID);
            if (revs == null) {
                revs = new ArrayList<String>();
                diffs.put(docID, revs);
            }
            revs.add(rev.getRevId());
            this.addPending(rev);
        }
        Log.v("Sync", "%s: posting to /_revs_diff", this);
        this.asyncTaskStarted();
        this.sendAsyncRequest("POST", "/_revs_diff", diffs, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object response, Throwable e) {
                block13: {
                    try {
                        Log.v("Sync", "%s: got /_revs_diff response");
                        Map results = (Map)response;
                        if (e != null) {
                            Pusher.this.setError(e);
                            Pusher.this.revisionFailed();
                            break block13;
                        }
                        if (results.size() != 0) {
                            ArrayList<Object> docsToSend = new ArrayList<Object>();
                            RevisionList revsToSend = new RevisionList();
                            for (RevisionInternal rev : changes) {
                                RevisionInternal loadedRev;
                                Map<String, Object> properties = null;
                                Map revResults = (Map)results.get(rev.getDocId());
                                if (revResults == null) continue;
                                List revs = (List)revResults.get("missing");
                                if (revs == null || !revs.contains(rev.getRevId())) {
                                    Pusher.this.removePending(rev);
                                    continue;
                                }
                                EnumSet<Database.TDContentOptions> contentOptions = EnumSet.of(Database.TDContentOptions.TDIncludeAttachments);
                                if (!Pusher.this.dontSendMultipart && Pusher.this.revisionBodyTransformationBlock == null) {
                                    contentOptions.add(Database.TDContentOptions.TDBigAttachmentsFollow);
                                }
                                try {
                                    loadedRev = Pusher.this.db.loadRevisionBody(rev, contentOptions);
                                    properties = new HashMap<String, Object>(rev.getProperties());
                                }
                                catch (CouchbaseLiteException e1) {
                                    Log.w("Sync", "%s Couldn't get local contents of %s", rev, Pusher.this);
                                    Pusher.this.revisionFailed();
                                    continue;
                                }
                                RevisionInternal populatedRev = Pusher.this.transformRevision(loadedRev);
                                List possibleAncestors = (List)revResults.get("possible_ancestors");
                                properties = new HashMap<String, Object>(populatedRev.getProperties());
                                Map<String, Object> revisions = Pusher.this.db.getRevisionHistoryDictStartingFromAnyAncestor(populatedRev, possibleAncestors);
                                properties.put("_revisions", revisions);
                                populatedRev.setProperties(properties);
                                if (properties.containsKey("_attachments")) {
                                    int minRevPos = Pusher.findCommonAncestor(populatedRev, possibleAncestors);
                                    Database.stubOutAttachmentsInRevBeforeRevPos(populatedRev, minRevPos + 1, false);
                                    properties = populatedRev.getProperties();
                                    if (!Pusher.this.dontSendMultipart && Pusher.this.uploadMultipartRevision(populatedRev)) continue;
                                }
                                if (properties == null || !properties.containsKey("_id")) {
                                    throw new IllegalStateException("properties must contain a document _id");
                                }
                                revsToSend.add(rev);
                                docsToSend.add(properties);
                            }
                            Pusher.this.uploadBulkDocs(docsToSend, revsToSend);
                            break block13;
                        }
                        for (RevisionInternal revisionInternal : changes) {
                            Pusher.this.removePending(revisionInternal);
                        }
                    }
                    finally {
                        Pusher.this.asyncTaskFinished(1);
                    }
                }
            }
        });
    }

    @InterfaceAudience.Private
    protected void uploadBulkDocs(List<Object> docsToSend, final RevisionList changes) {
        final int numDocsToSend = docsToSend.size();
        if (numDocsToSend == 0) {
            return;
        }
        Log.v("Sync", "%s: POSTing " + numDocsToSend + " revisions to _bulk_docs: %s", this, docsToSend);
        this.addToChangesCount(numDocsToSend);
        HashMap<String, Object> bulkDocsBody = new HashMap<String, Object>();
        bulkDocsBody.put("docs", docsToSend);
        bulkDocsBody.put("new_edits", false);
        this.asyncTaskStarted();
        this.sendAsyncRequest("POST", "/_bulk_docs", bulkDocsBody, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                try {
                    if (e == null) {
                        HashSet<String> failedIDs = new HashSet<String>();
                        List items = (List)result;
                        for (Map item : items) {
                            Status status = Pusher.this.statusFromBulkDocsResponseItem(item);
                            if (!status.isError()) continue;
                            Log.w("Sync", "%s: _bulk_docs got an error: %s", item, this);
                            if (status.getCode() == 403) continue;
                            String docID = (String)item.get("id");
                            failedIDs.add(docID);
                        }
                        for (RevisionInternal revisionInternal : changes) {
                            if (failedIDs.contains(revisionInternal.getDocId())) continue;
                            Pusher.this.removePending(revisionInternal);
                        }
                    }
                    if (e != null) {
                        Pusher.this.setError(e);
                        Pusher.this.revisionFailed();
                    } else {
                        Log.v("Sync", "%s: POSTed to _bulk_docs", Pusher.this);
                    }
                    Pusher.this.addToCompletedChangesCount(numDocsToSend);
                }
                finally {
                    Pusher.this.asyncTaskFinished(1);
                }
            }
        });
    }

    @InterfaceAudience.Private
    private boolean uploadMultipartRevision(final RevisionInternal revision) {
        MultipartEntity multiPart = null;
        Map<String, Object> revProps = revision.getProperties();
        Map attachments = (Map)revProps.get("_attachments");
        for (String attachmentKey : attachments.keySet()) {
            String base64Digest;
            BlobKey blobKey;
            BlobStore blobStore;
            InputStream inputStream;
            Map attachment = (Map)attachments.get(attachmentKey);
            if (!attachment.containsKey("follows")) continue;
            if (multiPart == null) {
                multiPart = new MultipartEntity();
                try {
                    String json = Manager.getObjectMapper().writeValueAsString(revProps);
                    Charset utf8charset = Charset.forName("UTF-8");
                    multiPart.addPart("param1", new StringBody(json, "application/json", utf8charset));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if ((inputStream = (blobStore = this.db.getAttachments()).blobStreamForKey(blobKey = new BlobKey(base64Digest = (String)attachment.get("digest")))) == null) {
                Log.w("Sync", "Unable to find blob file for blobKey: %s - Skipping upload of multipart revision.", blobKey);
                multiPart = null;
                continue;
            }
            String contentType = null;
            if (attachment.containsKey("content_type")) {
                contentType = (String)attachment.get("content_type");
            } else if (attachment.containsKey("content-type")) {
                Log.w("Sync", "Found attachment that uses content-type field name instead of content_type (see couchbase-lite-android issue #80): %s", attachment);
            }
            multiPart.addPart(attachmentKey, new InputStreamBody(inputStream, contentType, attachmentKey));
        }
        if (multiPart == null) {
            return false;
        }
        String path = String.format("/%s?new_edits=false", revision.getDocId());
        Log.d("Sync", "Uploading multipart request.  Revision: %s", revision);
        this.addToChangesCount(1);
        this.asyncTaskStarted();
        this.sendAsyncMultipartRequest("PUT", path, multiPart, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                try {
                    if (e != null) {
                        if (e instanceof HttpResponseException) {
                            if (((HttpResponseException)e).getStatusCode() == 415) {
                                Pusher.this.dontSendMultipart = true;
                                Pusher.this.uploadJsonRevision(revision);
                            }
                        } else {
                            Log.e("Sync", "Exception uploading multipart request", e);
                            Pusher.this.setError(e);
                            Pusher.this.revisionFailed();
                        }
                    } else {
                        Log.v("Sync", "Uploaded multipart request.");
                        Pusher.this.removePending(revision);
                    }
                }
                finally {
                    Pusher.this.addToCompletedChangesCount(1);
                    Pusher.this.asyncTaskFinished(1);
                }
            }
        });
        return true;
    }

    private void uploadJsonRevision(final RevisionInternal rev) {
        if (!this.db.inlineFollowingAttachmentsIn(rev)) {
            this.error = new CouchbaseLiteException(491);
            this.revisionFailed();
            return;
        }
        this.asyncTaskStarted();
        String path = String.format("/%s?new_edits=false", URIUtils.encode(rev.getDocId()));
        this.sendAsyncRequest("PUT", path, rev.getProperties(), new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(Object result, Throwable e) {
                if (e != null) {
                    Pusher.this.setError(e);
                    Pusher.this.revisionFailed();
                } else {
                    Log.v("Sync", "%s: Sent %s (JSON), response=%s", this, rev, result);
                    Pusher.this.removePending(rev);
                }
                Pusher.this.asyncTaskFinished(1);
            }
        });
    }

    private static int findCommonAncestor(RevisionInternal rev, List<String> possibleRevIDs) {
        String ancestorID;
        if (possibleRevIDs == null || possibleRevIDs.size() == 0) {
            return 0;
        }
        List<String> history = Database.parseCouchDBRevisionHistory(rev.getProperties());
        assert (history != null);
        boolean changed = history.retainAll(possibleRevIDs);
        String string = ancestorID = history.size() == 0 ? null : history.get(0);
        if (ancestorID == null) {
            return 0;
        }
        int generation = Database.parseRevIDNumber(ancestorID);
        return generation;
    }
}

