/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Misc;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.Status;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.BulkDownloader;
import com.couchbase.lite.replicator.ChangeTracker;
import com.couchbase.lite.replicator.ChangeTrackerClient;
import com.couchbase.lite.replicator.PulledRevision;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.support.BatchProcessor;
import com.couchbase.lite.support.Batcher;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.support.SequenceMap;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;

@InterfaceAudience.Private
public final class Puller
extends Replication
implements ChangeTrackerClient {
    private static final int MAX_OPEN_HTTP_CONNECTIONS = 16;
    private static final int MAX_REVS_TO_GET_IN_BULK = 50;
    public static final int MAX_NUMBER_OF_ATTS_SINCE = 50;
    protected Boolean canBulkGet;
    protected Boolean caughtUp;
    protected Batcher<RevisionInternal> downloadsToInsert;
    protected List<RevisionInternal> revsToPull;
    protected List<RevisionInternal> deletedRevsToPull;
    protected List<RevisionInternal> bulkRevsToPull;
    protected ChangeTracker changeTracker;
    protected SequenceMap pendingSequences;
    protected volatile int httpConnectionCount;

    @InterfaceAudience.Private
    public Puller(Database db, URL remote, boolean continuous, ScheduledExecutorService workExecutor) {
        this(db, remote, continuous, null, workExecutor);
    }

    @InterfaceAudience.Private
    public Puller(Database db, URL remote, boolean continuous, HttpClientFactory clientFactory, ScheduledExecutorService workExecutor) {
        super(db, remote, continuous, clientFactory, workExecutor);
    }

    @Override
    @InterfaceAudience.Public
    public boolean isPull() {
        return true;
    }

    @Override
    @InterfaceAudience.Public
    public boolean shouldCreateTarget() {
        return false;
    }

    @Override
    @InterfaceAudience.Public
    public void setCreateTarget(boolean createTarget) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Public
    public void stop() {
        if (!this.running) {
            return;
        }
        if (this.changeTracker != null) {
            Log.d("Sync", "%s: stopping changetracker", this, this.changeTracker);
            this.changeTracker.setClient(null);
            this.changeTracker.stop();
            this.changeTracker = null;
            if (!this.continuous) {
                Log.d("Sync", "%s | %s : puller.stop() calling asyncTaskFinished()", this, Thread.currentThread());
                this.asyncTaskFinished(1);
            }
        }
        Puller puller = this;
        synchronized (puller) {
            this.revsToPull = null;
            this.deletedRevsToPull = null;
            this.bulkRevsToPull = null;
        }
        super.stop();
        if (this.downloadsToInsert != null) {
            this.downloadsToInsert.flush();
        }
    }

    @Override
    @InterfaceAudience.Private
    public void beginReplicating() {
        if (this.downloadsToInsert == null) {
            int capacity = 200;
            int delay = 1000;
            this.downloadsToInsert = new Batcher<RevisionInternal>(this.workExecutor, capacity, delay, new BatchProcessor<RevisionInternal>(){

                @Override
                public void process(List<RevisionInternal> inbox) {
                    Puller.this.insertDownloads(inbox);
                }
            });
        }
        if (this.pendingSequences == null) {
            this.pendingSequences = new SequenceMap();
            if (this.getLastSequence() != null) {
                long seq = this.pendingSequences.addValue(this.getLastSequence());
                this.pendingSequences.removeSequence(seq);
                assert (this.pendingSequences.getCheckpointedValue().equals(this.getLastSequence()));
            }
        }
        Log.w("Sync", "%s: starting ChangeTracker with since=%s", this, this.lastSequence);
        this.changeTracker = new ChangeTracker(this.remote, this.continuous ? ChangeTracker.ChangeTrackerMode.LongPoll : ChangeTracker.ChangeTrackerMode.OneShot, true, this.lastSequence, this);
        this.changeTracker.setAuthenticator(this.getAuthenticator());
        Log.w("Sync", "%s: started ChangeTracker %s", this, this.changeTracker);
        if (this.filterName != null) {
            this.changeTracker.setFilterName(this.filterName);
            if (this.filterParams != null) {
                this.changeTracker.setFilterParams(this.filterParams);
            }
        }
        this.changeTracker.setDocIDs(this.documentIDs);
        this.changeTracker.setRequestHeaders(this.requestHeaders);
        if (!this.continuous) {
            Log.d("Sync", "%s | %s: beginReplicating() calling asyncTaskStarted()", this, Thread.currentThread());
            this.asyncTaskStarted();
        }
        this.changeTracker.setUsePOST(this.serverIsSyncGatewayVersion("0.93"));
        this.changeTracker.start();
    }

    @Override
    @InterfaceAudience.Private
    protected void stopped() {
        this.downloadsToInsert = null;
        super.stopped();
    }

    @Override
    @InterfaceAudience.Private
    public void changeTrackerReceivedChange(Map<String, Object> change) {
        String lastSequence = change.get("seq").toString();
        String docID = (String)change.get("id");
        if (docID == null) {
            return;
        }
        if (!Database.isValidDocumentId(docID)) {
            Log.w("Sync", "%s: Received invalid doc ID from _changes: %s", this, change);
            return;
        }
        boolean deleted = change.containsKey("deleted") && ((Boolean)change.get("deleted")).equals(Boolean.TRUE);
        List changes = (List)change.get("changes");
        for (Map changeDict : changes) {
            String revID = (String)changeDict.get("rev");
            if (revID == null) continue;
            PulledRevision rev = new PulledRevision(docID, revID, deleted, this.db);
            rev.setRemoteSequenceID(lastSequence);
            Log.d("Sync", "%s: adding rev to inbox %s", this, rev);
            Log.v("Sync", "%s: changeTrackerReceivedChange() incrementing changesCount by 1", this);
            this.addToChangesCount(1);
            this.addToInbox(rev);
        }
        while (this.revsToPull != null && this.revsToPull.size() > 1000) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
    }

    @Override
    @InterfaceAudience.Private
    public void changeTrackerStopped(ChangeTracker tracker) {
        Log.w("Sync", "%s: ChangeTracker %s stopped", this, tracker);
        if (this.error == null && tracker.getLastError() != null) {
            this.setError(tracker.getLastError());
        }
        this.changeTracker = null;
        if (this.batcher != null) {
            Log.d("Sync", "%s: calling batcher.flush().  batcher.count() is %d", this, this.batcher.count());
            this.batcher.flush();
        }
        if (!this.isContinuous()) {
            this.workExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    Puller.this.asyncTaskFinished(1);
                }
            });
        }
    }

    @Override
    @InterfaceAudience.Private
    public HttpClient getHttpClient() {
        HttpClient httpClient = this.clientFactory.getHttpClient();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InterfaceAudience.Private
    protected void processInbox(RevisionList inbox) {
        if (this.canBulkGet == null) {
            this.canBulkGet = this.serverIsSyncGatewayVersion("0.81");
        }
        String lastInboxSequence = ((PulledRevision)inbox.get(inbox.size() - 1)).getRemoteSequenceID();
        int numRevisionsRemoved = 0;
        try {
            numRevisionsRemoved = this.db.findMissingRevisions(inbox);
        }
        catch (SQLException e) {
            Log.e("Sync", String.format("%s failed to look up local revs", this), e);
            inbox = null;
        }
        int inboxCount = 0;
        if (inbox != null) {
            inboxCount = inbox.size();
        }
        if (numRevisionsRemoved > 0) {
            Log.v("Sync", "%s: processInbox() setting changesCount to: %s", this, this.getChangesCount() - numRevisionsRemoved);
            this.addToChangesCount(-1 * numRevisionsRemoved);
        }
        if (inboxCount == 0) {
            Log.w("Sync", "%s no new remote revisions to fetch", this);
            long seq = this.pendingSequences.addValue(lastInboxSequence);
            this.pendingSequences.removeSequence(seq);
            this.setLastSequence(this.pendingSequences.getCheckpointedValue());
            return;
        }
        Log.v("Sync", "%s: fetching %s remote revisions...", this, inboxCount);
        Puller puller = this;
        synchronized (puller) {
            int numBulked = 0;
            for (int i = 0; i < inbox.size(); ++i) {
                PulledRevision rev = (PulledRevision)inbox.get(i);
                if (this.canBulkGet.booleanValue() || rev.getGeneration() == 1 && !rev.isDeleted()) {
                    if (this.bulkRevsToPull == null) {
                        this.bulkRevsToPull = new ArrayList<RevisionInternal>(100);
                    }
                    this.bulkRevsToPull.add(rev);
                    ++numBulked;
                } else {
                    this.queueRemoteRevision(rev);
                }
                rev.setSequence(this.pendingSequences.addValue(rev.getRemoteSequenceID()));
            }
        }
        this.pullRemoteRevisions();
    }

    @InterfaceAudience.Private
    protected void queueRemoteRevision(RevisionInternal rev) {
        if (rev.isDeleted()) {
            if (this.deletedRevsToPull == null) {
                this.deletedRevsToPull = new ArrayList<RevisionInternal>(100);
            }
            this.deletedRevsToPull.add(rev);
        } else {
            if (this.revsToPull == null) {
                this.revsToPull = new ArrayList<RevisionInternal>(100);
            }
            this.revsToPull.add(rev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void pullRemoteRevisions() {
        ArrayList<RevisionInternal> workToStartNow = new ArrayList<RevisionInternal>();
        ArrayList<RevisionInternal> bulkWorkToStartNow = new ArrayList<RevisionInternal>();
        Puller puller = this;
        synchronized (puller) {
            while (this.httpConnectionCount + workToStartNow.size() < 16) {
                int nBulk = 0;
                if (this.bulkRevsToPull != null) {
                    int n = nBulk = this.bulkRevsToPull.size() < 50 ? this.bulkRevsToPull.size() : 50;
                }
                if (nBulk == 1) {
                    this.queueRemoteRevision(this.bulkRevsToPull.get(0));
                    this.bulkRevsToPull.remove(0);
                    nBulk = 0;
                }
                if (nBulk > 0) {
                    bulkWorkToStartNow.addAll(this.bulkRevsToPull.subList(0, nBulk));
                    this.bulkRevsToPull.subList(0, nBulk).clear();
                    continue;
                }
                List<RevisionInternal> queue = this.revsToPull;
                if (!(queue != null && queue.size() != 0 || (queue = this.deletedRevsToPull) != null && queue.size() != 0)) break;
                workToStartNow.add(queue.get(0));
                queue.remove(0);
            }
        }
        if (bulkWorkToStartNow.size() > 0) {
            this.pullBulkRevisions(bulkWorkToStartNow);
        }
        for (RevisionInternal work : workToStartNow) {
            this.pullRemoteRevision(work);
        }
    }

    @InterfaceAudience.Private
    public void pullRemoteRevision(final RevisionInternal rev) {
        Log.d("Sync", "%s: pullRemoteRevision with rev: %s", this, rev);
        this.asyncTaskStarted();
        ++this.httpConnectionCount;
        StringBuilder path = new StringBuilder("/" + URLEncoder.encode(rev.getDocId()) + "?rev=" + URLEncoder.encode(rev.getRevId()) + "&revs=true&attachments=true");
        List<String> knownRevs = this.knownCurrentRevIDs(rev);
        if (knownRevs == null) {
            this.asyncTaskFinished(1);
            --this.httpConnectionCount;
            return;
        }
        if (knownRevs.size() > 0) {
            path.append("&atts_since=");
            path.append(this.joinQuotedEscaped(knownRevs));
        }
        String pathInside = path.toString();
        this.sendAsyncMultipartDownloaderRequest("GET", pathInside, null, this.db, new RemoteRequestCompletionBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompletion(Object result, Throwable e) {
                try {
                    if (e != null) {
                        Log.e("Sync", "Error pulling remote revision", e);
                        Puller.this.setError(e);
                        Puller.this.revisionFailed();
                        Log.d("Sync", "%s: pullRemoteRevision() updating completedChangesCount from %d  ->  due to error pulling remote revision", this, Puller.this.getCompletedChangesCount(), Puller.this.getCompletedChangesCount() + 1);
                        Puller.this.addToCompletedChangesCount(1);
                    } else {
                        Map properties = (Map)result;
                        PulledRevision gotRev = new PulledRevision(properties, Puller.this.db);
                        gotRev.setSequence(rev.getSequence());
                        Puller.this.asyncTaskStarted();
                        Log.d("Sync", "%s: pullRemoteRevision add rev: %s to batcher", this, gotRev);
                        Puller.this.downloadsToInsert.queueObject(gotRev);
                    }
                }
                finally {
                    Puller.this.asyncTaskFinished(1);
                }
                --Puller.this.httpConnectionCount;
                Puller.this.pullRemoteRevisions();
            }
        });
    }

    protected void pullBulkRevisions(List<RevisionInternal> bulkRevs) {
        BulkDownloader dl;
        int nRevs = bulkRevs.size();
        if (nRevs == 0) {
            return;
        }
        Log.v("Sync", "%s bulk-fetching %d remote revisions...", this, nRevs);
        Log.v("Sync", "%s bulk-fetching remote revisions: %s", this, bulkRevs);
        if (!this.canBulkGet.booleanValue()) {
            this.pullBulkWithAllDocs(bulkRevs);
            return;
        }
        Log.v("Sync", "%s: POST _bulk_get", this);
        final ArrayList<RevisionInternal> remainingRevs = new ArrayList<RevisionInternal>(bulkRevs);
        this.asyncTaskStarted();
        ++this.httpConnectionCount;
        try {
            dl = new BulkDownloader(this.workExecutor, this.clientFactory, this.remote, bulkRevs, this.db, this.requestHeaders, new BulkDownloader.BulkDownloaderDocumentBlock(){

                @Override
                public void onDocument(Map<String, Object> props) {
                    RevisionInternal rev = props.get("_id") != null ? new RevisionInternal(props, Puller.this.db) : new RevisionInternal((String)props.get("id"), (String)props.get("rev"), false, Puller.this.db);
                    int pos = remainingRevs.indexOf(rev);
                    if (pos > -1) {
                        rev.setSequence(((RevisionInternal)remainingRevs.get(pos)).getSequence());
                        remainingRevs.remove(pos);
                    } else {
                        Log.w("Sync", "%s : Received unexpected rev rev", this);
                    }
                    if (props.get("_id") != null) {
                        Puller.this.queueDownloadedRevision(rev);
                    } else {
                        Status status = Puller.this.statusFromBulkDocsResponseItem(props);
                        Puller.this.error = new CouchbaseLiteException(status);
                        Puller.this.revisionFailed();
                        Puller.this.completedChangesCount.getAndIncrement();
                    }
                }
            }, new RemoteRequestCompletionBlock(){

                @Override
                public void onCompletion(Object result, Throwable e) {
                    if (e != null) {
                        Puller.this.setError(e);
                        Puller.this.revisionFailed();
                        Puller.this.completedChangesCount.addAndGet(remainingRevs.size());
                    }
                    Puller.this.asyncTaskFinished(1);
                    --Puller.this.httpConnectionCount;
                    Puller.this.pullRemoteRevisions();
                }
            });
        }
        catch (Exception e) {
            return;
        }
        dl.setAuthenticator(this.getAuthenticator());
        this.remoteRequestExecutor.execute(dl);
    }

    protected void pullBulkWithAllDocs(final List<RevisionInternal> bulkRevs) {
        this.asyncTaskStarted();
        ++this.httpConnectionCount;
        final ArrayList<RevisionInternal> remainingRevs = new ArrayList<RevisionInternal>(bulkRevs);
        Collection<String> keys = CollectionUtils.transform(bulkRevs, new CollectionUtils.Functor<RevisionInternal, String>(){

            @Override
            public String invoke(RevisionInternal rev) {
                return rev.getDocId();
            }
        });
        HashMap<String, Collection<String>> body = new HashMap<String, Collection<String>>();
        body.put("keys", keys);
        this.sendAsyncRequest("POST", "/_all_docs?include_docs=true", body, new RemoteRequestCompletionBlock(){

            @Override
            public void onCompletion(Object result, Throwable e) {
                Map res = (Map)result;
                if (e != null) {
                    Puller.this.setError(e);
                    Puller.this.revisionFailed();
                    Puller.this.completedChangesCount.addAndGet(bulkRevs.size());
                } else {
                    List rows = (List)res.get("rows");
                    Log.v("Sync", "%s checking %d bulk-fetched remote revisions", this, rows.size());
                    for (Map row : rows) {
                        RevisionInternal rev;
                        int pos;
                        Map doc = (Map)row.get("doc");
                        if (doc == null || doc.get("_attachments") != null || (pos = remainingRevs.indexOf(rev = new RevisionInternal(doc, Puller.this.db))) <= -1) continue;
                        rev.setSequence(((RevisionInternal)remainingRevs.get(pos)).getSequence());
                        remainingRevs.remove(pos);
                        Puller.this.queueDownloadedRevision(rev);
                    }
                }
                if (remainingRevs.size() > 0) {
                    Log.v("Sync", "%s bulk-fetch didn't work for %d of %d revs; getting individually", this, remainingRevs.size(), bulkRevs.size());
                    for (RevisionInternal rev : remainingRevs) {
                        Puller.this.queueRemoteRevision(rev);
                    }
                    Puller.this.pullRemoteRevisions();
                }
                Puller.this.asyncTaskFinished(1);
                --Puller.this.httpConnectionCount;
                Puller.this.pullRemoteRevisions();
            }
        });
    }

    private void queueDownloadedRevision(RevisionInternal rev) {
        if (this.revisionBodyTransformationBlock != null) {
            for (Map.Entry entry : ((Map)rev.getProperties().get("_attachments")).entrySet()) {
                String filePath;
                String name = (String)entry.getKey();
                Map attachment = (Map)entry.getValue();
                attachment.remove("file");
                if (attachment.get("follows") == null || attachment.get("data") != null || (filePath = this.db.fileForAttachmentDict(attachment).getPath()) == null) continue;
                attachment.put("file", filePath);
            }
            RevisionInternal xformed = this.transformRevision(rev);
            if (xformed == null) {
                Log.v("Sync", "%s: Transformer rejected revision %s", this, rev);
                this.pendingSequences.removeSequence(rev.getSequence());
                this.lastSequence = this.pendingSequences.getCheckpointedValue();
                return;
            }
            rev = xformed;
            Map attachments = (Map)rev.getProperties().get("_attachments");
            for (Map.Entry entry : ((Map)rev.getProperties().get("_attachments")).entrySet()) {
                Map attachment = (Map)entry.getValue();
                attachment.remove("file");
            }
        }
        this.asyncTaskStarted();
        this.downloadsToInsert.queueObject(rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void insertDownloads(List<RevisionInternal> downloads) {
        Log.i("Sync", this + " inserting " + downloads.size() + " revisions...");
        long time = System.currentTimeMillis();
        Collections.sort(downloads, this.getRevisionListComparator());
        this.db.beginTransaction();
        boolean success = false;
        try {
            for (RevisionInternal rev : downloads) {
                long fakeSequence = rev.getSequence();
                List<String> history = Database.parseCouchDBRevisionHistory(rev.getProperties());
                if (history.isEmpty() && rev.getGeneration() > 1) {
                    Log.w("Sync", "%s: Missing revision history in response for: %s", this, rev);
                    this.setError(new CouchbaseLiteException(589));
                    this.revisionFailed();
                    continue;
                }
                Log.v("Sync", "%s: inserting %s %s", this, rev.getDocId(), history);
                try {
                    this.db.forceInsert(rev, history, this.remote);
                }
                catch (CouchbaseLiteException e) {
                    if (e.getCBLStatus().getCode() == 403) {
                        Log.i("Sync", "%s: Remote rev failed validation: %s", this, rev);
                    }
                    Log.w("Sync", "%s: failed to write %s: status=%s", this, rev, e.getCBLStatus().getCode());
                    this.revisionFailed();
                    this.setError((Throwable)new HttpResponseException(e.getCBLStatus().getCode(), null));
                    continue;
                }
                this.pendingSequences.removeSequence(fakeSequence);
            }
            Log.v("Sync", "%s: finished inserting %d revisions", this, downloads.size());
            success = true;
        }
        catch (SQLException e) {
            try {
                Log.e("Sync", this + ": Exception inserting revisions", e);
                this.db.endTransaction(success);
            }
            catch (Throwable throwable) {
                this.db.endTransaction(success);
                Log.d("Sync", "%s|%s: insertDownloads() calling asyncTaskFinished() with value: %d", this, Thread.currentThread(), downloads.size());
                this.asyncTaskFinished(downloads.size());
                throw throwable;
            }
            Log.d("Sync", "%s|%s: insertDownloads() calling asyncTaskFinished() with value: %d", this, Thread.currentThread(), downloads.size());
            this.asyncTaskFinished(downloads.size());
        }
        this.db.endTransaction(success);
        Log.d("Sync", "%s|%s: insertDownloads() calling asyncTaskFinished() with value: %d", this, Thread.currentThread(), downloads.size());
        this.asyncTaskFinished(downloads.size());
        this.setLastSequence(this.pendingSequences.getCheckpointedValue());
        long delta = System.currentTimeMillis() - time;
        Log.v("Sync", "%s: inserted %d revs in %d milliseconds", this, downloads.size(), delta);
        int newCompletedChangesCount = this.getCompletedChangesCount() + downloads.size();
        Log.d("Sync", "%s insertDownloads() updating completedChangesCount from %d -> %d ", this, this.getCompletedChangesCount(), newCompletedChangesCount);
        this.addToCompletedChangesCount(downloads.size());
    }

    @InterfaceAudience.Private
    private Comparator<RevisionInternal> getRevisionListComparator() {
        return new Comparator<RevisionInternal>(){

            @Override
            public int compare(RevisionInternal reva, RevisionInternal revb) {
                return Misc.TDSequenceCompare(reva.getSequence(), revb.getSequence());
            }
        };
    }

    @InterfaceAudience.Private
    List<String> knownCurrentRevIDs(RevisionInternal rev) {
        if (this.db != null) {
            return this.db.getAllRevisionsOfDocumentID(rev.getDocId(), true).getAllRevIds();
        }
        return null;
    }

    @InterfaceAudience.Private
    public String joinQuotedEscaped(List<String> strings) {
        if (strings.size() == 0) {
            return "[]";
        }
        byte[] json = null;
        try {
            json = Manager.getObjectMapper().writeValueAsBytes(strings);
        }
        catch (Exception e) {
            Log.w("Sync", "Unable to serialize json", e);
        }
        return URLEncoder.encode(new String(json));
    }

    @Override
    @InterfaceAudience.Public
    public boolean goOffline() {
        Log.d("Sync", "%s: goOffline() called, stopping changeTracker: %s", this, this.changeTracker);
        if (!super.goOffline()) {
            return false;
        }
        if (this.changeTracker != null) {
            this.changeTracker.stop();
        }
        return true;
    }
}

