/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.replicator;

import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.MultipartDocumentReader;
import com.couchbase.lite.support.MultipartReader;
import com.couchbase.lite.support.MultipartReaderDelegate;
import com.couchbase.lite.support.RemoteRequest;
import com.couchbase.lite.support.RemoteRequestCompletionBlock;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class BulkDownloader
extends RemoteRequest
implements MultipartReaderDelegate {
    private Database _db;
    private MultipartReader _topReader;
    private MultipartDocumentReader _docReader;
    private int _docCount;
    private BulkDownloaderDocumentBlock _onDocument;

    public BulkDownloader(ScheduledExecutorService workExecutor, HttpClientFactory clientFactory, URL dbURL, List<RevisionInternal> revs, Database database, Map<String, Object> requestHeaders, BulkDownloaderDocumentBlock onDocument, RemoteRequestCompletionBlock onCompletion) throws Exception {
        super(workExecutor, clientFactory, "POST", new URL(BulkDownloader.buildRelativeURLString(dbURL, "/_bulk_get?revs=true&attachments=true")), BulkDownloader.helperMethod(revs, database), database, requestHeaders, onCompletion);
        this._db = database;
        this._onDocument = onDocument;
    }

    @Override
    public void run() {
        HttpClient httpClient = this.clientFactory.getHttpClient();
        this.preemptivelySetAuthCredentials(httpClient);
        HttpUriRequest request = this.createConcreteRequest();
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "multipart/related");
        this.addRequestHeaders(request);
        this.setBody(request);
        this.executeRequest(httpClient, request);
    }

    private String description() {
        return this.getClass().getName() + "[" + this.url.getPath() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeRequest(HttpClient httpClient, HttpUriRequest request) {
        block24: {
            Object fullBody = null;
            Throwable error = null;
            try {
                HttpResponse response = httpClient.execute(request);
                try {
                    if (httpClient instanceof DefaultHttpClient) {
                        DefaultHttpClient defaultHttpClient = (DefaultHttpClient)httpClient;
                        this.clientFactory.addCookies(defaultHttpClient.getCookieStore().getCookies());
                    }
                }
                catch (Exception e) {
                    Log.e("RemoteRequest", "Unable to add in cookies to global store", e);
                }
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() >= 300) {
                    Log.e("RemoteRequest", "Got error status: %d for %s.  Reason: %s", status.getStatusCode(), request, status.getReasonPhrase());
                    error = new HttpResponseException(status.getStatusCode(), status.getReasonPhrase());
                    break block24;
                }
                HttpEntity entity = response.getEntity();
                Header contentTypeHeader = entity.getContentType();
                InputStream inputStream = null;
                if (contentTypeHeader != null && contentTypeHeader.getValue().contains("multipart/")) {
                    Log.v("Sync", "contentTypeHeader = %s", contentTypeHeader.getValue());
                    try {
                        this._topReader = new MultipartReader(contentTypeHeader.getValue(), this);
                        inputStream = entity.getContent();
                        int bufLen = 1024;
                        byte[] buffer = new byte[bufLen];
                        int numBytesRead = 0;
                        while ((numBytesRead = inputStream.read(buffer)) != -1) {
                            if (numBytesRead != bufLen) {
                                byte[] bufferToAppend = Arrays.copyOfRange(buffer, 0, numBytesRead);
                                this._topReader.appendData(bufferToAppend);
                                continue;
                            }
                            this._topReader.appendData(buffer);
                        }
                        this._topReader.finished();
                        this.respondWithResult(fullBody, error, response);
                        break block24;
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {}
                    }
                }
                Log.v("Sync", "contentTypeHeader is not multipart = %s", contentTypeHeader.getValue());
                if (entity == null) break block24;
                try {
                    inputStream = entity.getContent();
                    fullBody = Manager.getObjectMapper().readValue(inputStream, Object.class);
                    this.respondWithResult(fullBody, error, response);
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
            catch (ClientProtocolException e) {
                Log.e("RemoteRequest", "client protocol exception", e);
                error = e;
            }
            catch (IOException e) {
                Log.e("RemoteRequest", "io exception", e);
                error = e;
            }
        }
    }

    public void startedPart(Map headers) {
        if (this._docReader != null) {
            throw new IllegalStateException("_docReader is already defined");
        }
        Log.v("Sync", "%s: Starting new document; headers =%s", this, headers);
        Log.v("Sync", "%s: Starting new document; ID=%s", this, headers.get("X-Doc-Id"));
        this._docReader = new MultipartDocumentReader(null, this._db);
        this._docReader.setContentType((String)headers.get("Content-Type"));
        this._docReader.startedPart(headers);
    }

    @Override
    public void appendToPart(byte[] data) {
        if (this._docReader == null) {
            throw new IllegalStateException("_docReader is not defined");
        }
        this._docReader.appendData(data);
    }

    @Override
    public void finishedPart() {
        Log.v("Sync", "%s: Finished document", this);
        if (this._docReader == null) {
            throw new IllegalStateException("_docReader is not defined");
        }
        this._docReader.finish();
        ++this._docCount;
        this._onDocument.onDocument(this._docReader.getDocumentProperties());
        this._docReader = null;
    }

    private static Map<String, Object> helperMethod(List<RevisionInternal> revs, final Database database) {
        Collection<Map<String, Object>> keys = CollectionUtils.transform(revs, new CollectionUtils.Functor<RevisionInternal, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(RevisionInternal source) {
                AtomicBoolean hasAttachment = new AtomicBoolean(false);
                List<String> attsSince = database.getPossibleAncestorRevisionIDs(source, 50, hasAttachment);
                if (!hasAttachment.get() || attsSince.size() == 0) {
                    attsSince = null;
                }
                HashMap<String, Object> mapped = new HashMap<String, Object>();
                mapped.put("id", source.getDocId());
                mapped.put("rev", source.getRevId());
                mapped.put("atts_since", attsSince);
                return mapped;
            }
        });
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("docs", keys);
        return retval;
    }

    @InterfaceAudience.Private
    private static String buildRelativeURLString(URL remote, String relativePath) {
        String remoteUrlString = remote.toExternalForm();
        if (remoteUrlString.endsWith("/") && relativePath.startsWith("/")) {
            remoteUrlString = remoteUrlString.substring(0, remoteUrlString.length() - 1);
        }
        return remoteUrlString + relativePath;
    }

    public static interface BulkDownloaderDocumentBlock {
        public void onDocument(Map<String, Object> var1);
    }
}

