/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite.internal;

import com.couchbase.lite.Database;
import com.couchbase.lite.internal.Body;
import com.couchbase.lite.util.CollectionUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class RevisionInternal {
    private String docId;
    private String revId;
    private boolean deleted;
    private boolean missing;
    private Body body;
    private long sequence;
    private Database database;

    public RevisionInternal(String docId, String revId, boolean deleted, Database database) {
        this.docId = docId;
        this.revId = revId;
        this.deleted = deleted;
        this.database = database;
    }

    public RevisionInternal(Body body, Database database) {
        this((String)body.getPropertyForKey("_id"), (String)body.getPropertyForKey("_rev"), (Boolean)body.getPropertyForKey("_deleted") != null && (Boolean)body.getPropertyForKey("_deleted") == true, database);
        this.body = body;
    }

    public RevisionInternal(Map<String, Object> properties, Database database) {
        this(new Body(properties), database);
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> result = null;
        if (this.body != null) {
            Map<String, Object> prop;
            try {
                prop = this.body.getProperties();
            }
            catch (IllegalStateException e) {
                return null;
            }
            if (result == null) {
                result = new HashMap<String, Object>();
            }
            result.putAll(prop);
        }
        return result;
    }

    public Object getPropertyForKey(String key) {
        Map<String, Object> prop = this.getProperties();
        if (prop == null) {
            return null;
        }
        return prop.get(key);
    }

    public void setProperties(Map<String, Object> properties) {
        this.body = new Body(properties);
    }

    public byte[] getJson() {
        byte[] result = null;
        if (this.body != null) {
            result = this.body.getJson();
        }
        return result;
    }

    public void setJson(byte[] json) {
        this.body = new Body(json);
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof RevisionInternal) {
            RevisionInternal other = (RevisionInternal)o;
            if (this.docId.equals(other.docId) && this.revId.equals(other.revId)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return this.docId.hashCode() ^ this.revId.hashCode();
    }

    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public String getRevId() {
        return this.revId;
    }

    public void setRevId(String revId) {
        this.revId = revId;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public RevisionInternal copyWithDocID(String docId, String revId) {
        assert (docId != null);
        assert (this.docId == null || this.docId.equals(docId));
        RevisionInternal result = new RevisionInternal(docId, revId, this.deleted, this.database);
        Map<String, Object> unmodifiableProperties = this.getProperties();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (unmodifiableProperties != null) {
            properties.putAll(unmodifiableProperties);
        }
        properties.put("_id", docId);
        properties.put("_rev", revId);
        result.setProperties(properties);
        return result;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String toString() {
        return "{" + this.docId + " #" + this.revId + (this.deleted ? "DEL" : "") + "}";
    }

    public int getGeneration() {
        return RevisionInternal.generationFromRevID(this.revId);
    }

    public static int generationFromRevID(String revID) {
        int generation = 0;
        int dashPos = revID.indexOf("-");
        if (dashPos > 0) {
            generation = Integer.parseInt(revID.substring(0, dashPos));
        }
        return generation;
    }

    public static int CBLCollateRevIDs(String revId1, String revId2) {
        Integer rev2Generation;
        Integer rev1Generation;
        String rev1GenerationStr = null;
        String rev2GenerationStr = null;
        String rev1Hash = null;
        String rev2Hash = null;
        StringTokenizer st1 = new StringTokenizer(revId1, "-");
        try {
            rev1GenerationStr = st1.nextToken();
            rev1Hash = st1.nextToken();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringTokenizer st2 = new StringTokenizer(revId2, "-");
        try {
            rev2GenerationStr = st2.nextToken();
            rev2Hash = st2.nextToken();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (rev1GenerationStr == null || rev2GenerationStr == null) {
            return revId1.compareToIgnoreCase(revId2);
        }
        try {
            rev1Generation = Integer.parseInt(rev1GenerationStr);
            rev2Generation = Integer.parseInt(rev2GenerationStr);
        }
        catch (NumberFormatException e) {
            return revId1.compareToIgnoreCase(revId2);
        }
        if (rev1Generation.compareTo(rev2Generation) != 0) {
            return rev1Generation.compareTo(rev2Generation);
        }
        if (rev1Hash != null && rev2Hash != null) {
            return rev1Hash.compareTo(rev2Hash);
        }
        return revId1.compareToIgnoreCase(revId2);
    }

    public static int CBLCompareRevIDs(String revId1, String revId2) {
        assert (revId1 != null);
        assert (revId2 != null);
        return RevisionInternal.CBLCollateRevIDs(revId1, revId2);
    }

    public boolean mutateAttachments(CollectionUtils.Functor<Map<String, Object>, Map<String, Object>> functor) {
        Map<String, Object> properties = this.getProperties();
        HashMap<String, Object> editedProperties = null;
        Map attachments = (Map)properties.get("_attachments");
        HashMap<String, Map<String, Object>> editedAttachments = null;
        for (String name : attachments.keySet()) {
            Map attachment = (Map)attachments.get(name);
            Map<String, Object> editedAttachment = functor.invoke(attachment);
            if (editedAttachment == null) {
                return false;
            }
            if (editedAttachment == attachment) continue;
            if (editedProperties == null) {
                editedProperties = new HashMap<String, Object>(properties);
                editedAttachments = new HashMap<String, Map<String, Object>>(attachments);
                editedProperties.put("_attachments", editedAttachments);
            }
            editedAttachments.put(name, editedAttachment);
        }
        if (editedProperties != null) {
            this.setProperties(editedProperties);
            return true;
        }
        return false;
    }
}

