/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.AbstractTouchMapEmitBlock;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.Reducer;
import com.couchbase.lite.Status;
import com.couchbase.lite.ViewCompiler;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.storage.ContentValues;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.support.JsonDocument;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.Utils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class View {
    public static final int REDUCE_BATCH_SIZE = 100;
    private Database database;
    private String name;
    private int viewId;
    private Mapper mapBlock;
    private Reducer reduceBlock;
    private TDViewCollation collation;
    private static ViewCompiler compiler;

    @InterfaceAudience.Public
    public static ViewCompiler getCompiler() {
        return compiler;
    }

    @InterfaceAudience.Public
    public static void setCompiler(ViewCompiler compiler) {
        View.compiler = compiler;
    }

    @InterfaceAudience.Private
    View(Database database, String name) {
        this.database = database;
        this.name = name;
        this.viewId = -1;
        this.collation = TDViewCollation.TDViewCollationUnicode;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Public
    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Public
    public Mapper getMap() {
        return this.mapBlock;
    }

    @InterfaceAudience.Public
    public Reducer getReduce() {
        return this.reduceBlock;
    }

    @InterfaceAudience.Public
    public boolean isStale() {
        return this.getLastSequenceIndexed() < this.database.getLastSequenceNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public long getLastSequenceIndexed() {
        String sql = "SELECT lastSequence FROM views WHERE name=?";
        String[] args = new String[]{this.name};
        Cursor cursor = null;
        long result = -1L;
        try {
            cursor = this.database.getDatabase().rawQuery(sql, args);
            if (cursor.moveToNext()) {
                result = cursor.getLong(0);
            }
        }
        catch (Exception e) {
            Log.e("View", "Error getting last sequence indexed", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Public
    public boolean setMap(Mapper mapBlock, String version) {
        return this.setMapReduce(mapBlock, null, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public boolean setMapReduce(Mapper mapBlock, Reducer reduceBlock, String version) {
        assert (mapBlock != null);
        assert (version != null);
        this.mapBlock = mapBlock;
        this.reduceBlock = reduceBlock;
        if (!this.database.open()) {
            return false;
        }
        SQLiteStorageEngine storageEngine = this.database.getDatabase();
        String sql = "SELECT name, version FROM views WHERE name=?";
        String[] args = new String[]{this.name};
        Cursor cursor = null;
        try {
            cursor = storageEngine.rawQuery(sql, args);
            if (!cursor.moveToNext()) {
                ContentValues insertValues = new ContentValues();
                insertValues.put("name", this.name);
                insertValues.put("version", version);
                storageEngine.insert("views", null, insertValues);
                boolean bl = true;
                return bl;
            }
            ContentValues updateValues = new ContentValues();
            updateValues.put("version", version);
            updateValues.put("lastSequence", 0);
            String[] whereArgs = new String[]{this.name, version};
            int rowsAffected = storageEngine.update("views", updateValues, "name=? AND version!=?", whereArgs);
            boolean bl = rowsAffected > 0;
            return bl;
        }
        catch (SQLException e) {
            Log.e("View", "Error setting map block", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public void deleteIndex() {
        if (this.getViewId() < 0) {
            return;
        }
        boolean success = false;
        try {
            this.database.beginTransaction();
            String[] whereArgs = new String[]{Integer.toString(this.getViewId())};
            this.database.getDatabase().delete("maps", "view_id=?", whereArgs);
            ContentValues updateValues = new ContentValues();
            updateValues.put("lastSequence", 0);
            this.database.getDatabase().update("views", updateValues, "view_id=?", whereArgs);
            success = true;
        }
        catch (SQLException e) {
            Log.e("View", "Error removing index", e);
        }
        finally {
            this.database.endTransaction(success);
        }
    }

    @InterfaceAudience.Public
    public void delete() {
        this.database.deleteViewNamed(this.name);
        this.viewId = 0;
    }

    @InterfaceAudience.Public
    public Query createQuery() {
        return new Query(this.getDatabase(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int getViewId() {
        if (this.viewId < 0) {
            String sql = "SELECT view_id FROM views WHERE name=?";
            String[] args = new String[]{this.name};
            Cursor cursor = null;
            try {
                cursor = this.database.getDatabase().rawQuery(sql, args);
                this.viewId = cursor.moveToNext() ? cursor.getInt(0) : 0;
            }
            catch (SQLException e) {
                Log.e("View", "Error getting view id", e);
                this.viewId = 0;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        return this.viewId;
    }

    @InterfaceAudience.Private
    public void databaseClosing() {
        this.database = null;
        this.viewId = 0;
    }

    @InterfaceAudience.Private
    public String toJSONString(Object object) {
        if (object == null) {
            return null;
        }
        String result = null;
        try {
            result = Manager.getObjectMapper().writeValueAsString(object);
        }
        catch (Exception e) {
            Log.w("View", "Exception serializing object to json: %s", e, object);
        }
        return result;
    }

    @InterfaceAudience.Private
    public TDViewCollation getCollation() {
        return this.collation;
    }

    @InterfaceAudience.Private
    public void setCollation(TDViewCollation collation) {
        this.collation = collation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public void updateIndex() throws CouchbaseLiteException {
        Status result;
        block31: {
            long dbMaxSequence;
            long lastSequence;
            Cursor cursor;
            block28: {
                block29: {
                    Log.v("View", "Re-indexing view: %s", this.name);
                    assert (this.mapBlock != null);
                    if (this.getViewId() <= 0) {
                        String msg = String.format("getViewId() < 0", new Object[0]);
                        throw new CouchbaseLiteException(msg, new Status(404));
                    }
                    this.database.beginTransaction();
                    result = new Status(500);
                    cursor = null;
                    lastSequence = this.getLastSequenceIndexed();
                    dbMaxSequence = this.database.getLastSequenceNumber();
                    if (lastSequence != dbMaxSequence) break block28;
                    Log.v("View", "lastSequence (%s) == dbMaxSequence (%s), nothing to do", lastSequence, dbMaxSequence);
                    result.setCode(304);
                    if (cursor == null) break block29;
                    cursor.close();
                }
                if (!result.isSuccessful()) {
                    Log.w("View", "Failed to rebuild view %s.  Result code: %d", this.name, result.getCode());
                }
                if (this.database != null) {
                    this.database.endTransaction(result.isSuccessful());
                }
                return;
            }
            try {
                long sequence = lastSequence;
                if (lastSequence < 0L) {
                    String msg = String.format("lastSequence < 0 (%s)", lastSequence);
                    throw new CouchbaseLiteException(msg, new Status(500));
                }
                if (lastSequence == 0L) {
                    String[] whereArgs = new String[]{Integer.toString(this.getViewId())};
                    this.database.getDatabase().delete("maps", "view_id=?", whereArgs);
                } else {
                    Object[] args = new String[]{Integer.toString(this.getViewId()), Long.toString(lastSequence), Long.toString(lastSequence)};
                    this.database.getDatabase().execSQL("DELETE FROM maps WHERE view_id=? AND sequence IN (SELECT parent FROM revs WHERE sequence>? AND parent>0 AND parent<=?)", args);
                }
                int deleted = 0;
                cursor = this.database.getDatabase().rawQuery("SELECT changes()", null);
                cursor.moveToNext();
                deleted = cursor.getInt(0);
                cursor.close();
                AbstractTouchMapEmitBlock emitBlock = new AbstractTouchMapEmitBlock(){

                    @Override
                    public void emit(Object key, Object value) {
                        try {
                            String keyJson = Manager.getObjectMapper().writeValueAsString(key);
                            String valueJson = value == null ? null : Manager.getObjectMapper().writeValueAsString(value);
                            ContentValues insertValues = new ContentValues();
                            insertValues.put("view_id", View.this.getViewId());
                            insertValues.put("sequence", this.sequence);
                            insertValues.put("key", keyJson);
                            insertValues.put("value", valueJson);
                            View.this.database.getDatabase().insert("maps", null, insertValues);
                        }
                        catch (Exception e) {
                            Log.e("View", "Error emitting", e);
                        }
                    }
                };
                String[] selectArgs = new String[]{Long.toString(lastSequence)};
                cursor = this.database.getDatabase().rawQuery("SELECT revs.doc_id, sequence, docid, revid, json, no_attachments FROM revs, docs WHERE sequence>? AND current!=0 AND deleted=0 AND revs.doc_id = docs.doc_id ORDER BY revs.doc_id, revid DESC", selectArgs);
                long lastDocID = 0L;
                boolean keepGoing = cursor.moveToNext();
                while (keepGoing) {
                    Map<String, Object> properties;
                    boolean noAttachments;
                    long docID = cursor.getLong(0);
                    if (docID == lastDocID) continue;
                    lastDocID = docID;
                    sequence = cursor.getLong(1);
                    String docId = cursor.getString(2);
                    if (docId.startsWith("_design/")) {
                        keepGoing = cursor.moveToNext();
                        continue;
                    }
                    String revId = cursor.getString(3);
                    byte[] json = cursor.getBlob(4);
                    boolean bl = noAttachments = cursor.getInt(5) > 0;
                    while ((keepGoing = cursor.moveToNext()) && cursor.getLong(0) == docID) {
                    }
                    if (lastSequence > 0L) {
                        String[] selectArgs2 = new String[]{Long.toString(docID), Long.toString(lastSequence)};
                        Cursor cursor2 = null;
                        try {
                            cursor2 = this.database.getDatabase().rawQuery("SELECT revid, sequence FROM revs WHERE doc_id=? AND sequence<=? AND current!=0 AND deleted=0 ORDER BY revID DESC LIMIT 1", selectArgs2);
                            if (cursor2.moveToNext()) {
                                String oldRevId = cursor2.getString(0);
                                long oldSequence = cursor2.getLong(1);
                                Object[] args = new String[]{Integer.toString(this.getViewId()), Long.toString(oldSequence)};
                                this.database.getDatabase().execSQL("DELETE FROM maps WHERE view_id=? AND sequence=?", args);
                                if (RevisionInternal.CBLCompareRevIDs(oldRevId, revId) > 0) {
                                    revId = oldRevId;
                                    sequence = oldSequence;
                                    String[] selectArgs3 = new String[]{Long.toString(sequence)};
                                    json = Utils.byteArrayResultForQuery(this.database.getDatabase(), "SELECT json FROM revs WHERE sequence=?", selectArgs3);
                                }
                            }
                        }
                        finally {
                            if (cursor2 != null) {
                                cursor2.close();
                            }
                        }
                    }
                    EnumSet<Database.TDContentOptions> contentOptions = EnumSet.noneOf(Database.TDContentOptions.class);
                    if (noAttachments) {
                        contentOptions.add(Database.TDContentOptions.TDNoAttachments);
                    }
                    if ((properties = this.database.documentPropertiesFromJSON(json, docId, revId, false, sequence, contentOptions)) == null) continue;
                    emitBlock.setSequence(sequence);
                    this.mapBlock.map(properties, emitBlock);
                }
                ContentValues updateValues = new ContentValues();
                updateValues.put("lastSequence", dbMaxSequence);
                String[] whereArgs = new String[]{Integer.toString(this.getViewId())};
                this.database.getDatabase().update("views", updateValues, "view_id=?", whereArgs);
                Log.v("View", "Finished re-indexing view: %s  up to sequence %s (deleted %s added ?)", this.name, dbMaxSequence, deleted);
                result.setCode(200);
                if (cursor == null) break block31;
            }
            catch (SQLException e) {
                try {
                    throw new CouchbaseLiteException((Throwable)e, new Status(590));
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (!result.isSuccessful()) {
                        Log.w("View", "Failed to rebuild view %s.  Result code: %d", this.name, result.getCode());
                    }
                    if (this.database != null) {
                        this.database.endTransaction(result.isSuccessful());
                    }
                    throw throwable;
                }
            }
            cursor.close();
        }
        if (!result.isSuccessful()) {
            Log.w("View", "Failed to rebuild view %s.  Result code: %d", this.name, result.getCode());
        }
        if (this.database != null) {
            this.database.endTransaction(result.isSuccessful());
        }
    }

    @InterfaceAudience.Private
    public Cursor resultSetWithOptions(QueryOptions options) {
        if (options == null) {
            options = new QueryOptions();
        }
        String collationStr = "";
        if (this.collation == TDViewCollation.TDViewCollationASCII) {
            collationStr = collationStr + " COLLATE JSON_ASCII";
        } else if (this.collation == TDViewCollation.TDViewCollationRaw) {
            collationStr = collationStr + " COLLATE JSON_RAW";
        }
        String sql = "SELECT key, value, docid, revs.sequence";
        if (options.isIncludeDocs()) {
            sql = sql + ", revid, json";
        }
        sql = sql + " FROM maps, revs, docs WHERE maps.view_id=?";
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(Integer.toString(this.getViewId()));
        if (options.getKeys() != null) {
            sql = sql + " AND key in (";
            String item = "?";
            for (Object key : options.getKeys()) {
                sql = sql + item;
                item = ", ?";
                argsList.add(this.toJSONString(key));
            }
            sql = sql + ")";
        }
        String startKey = this.toJSONString(options.getStartKey());
        String endKey = this.toJSONString(options.getEndKey());
        String minKey = startKey;
        String maxKey = endKey;
        String minKeyDocId = options.getStartKeyDocId();
        String maxKeyDocId = options.getEndKeyDocId();
        boolean inclusiveMin = true;
        boolean inclusiveMax = options.isInclusiveEnd();
        if (options.isDescending()) {
            String min = minKey;
            minKey = maxKey;
            maxKey = min;
            inclusiveMin = inclusiveMax;
            inclusiveMax = true;
            minKeyDocId = options.getEndKeyDocId();
            maxKeyDocId = options.getStartKeyDocId();
        }
        if (minKey != null) {
            sql = inclusiveMin ? sql + " AND key >= ?" : sql + " AND key > ?";
            sql = sql + collationStr;
            argsList.add(minKey);
            if (minKeyDocId != null && inclusiveMin) {
                sql = sql + String.format(" AND (key > ? %s OR docid >= ?)", collationStr);
                argsList.add(minKey);
                argsList.add(minKeyDocId);
            }
        }
        if (maxKey != null) {
            sql = inclusiveMax ? sql + " AND key <= ?" : sql + " AND key < ?";
            sql = sql + collationStr;
            argsList.add(maxKey);
            if (maxKeyDocId != null && inclusiveMax) {
                sql = sql + String.format(" AND (key < ? %s OR docid <= ?)", collationStr);
                argsList.add(maxKey);
                argsList.add(maxKeyDocId);
            }
        }
        sql = sql + " AND revs.sequence = maps.sequence AND docs.doc_id = revs.doc_id ORDER BY key";
        sql = sql + collationStr;
        if (options.isDescending()) {
            sql = sql + " DESC";
        }
        sql = sql + " LIMIT ? OFFSET ?";
        argsList.add(Integer.toString(options.getLimit()));
        argsList.add(Integer.toString(options.getSkip()));
        Log.v("View", "Query %s: %s | args: %s", this.name, sql, argsList);
        Cursor cursor = this.database.getDatabase().rawQuery(sql, argsList.toArray(new String[argsList.size()]));
        return cursor;
    }

    @InterfaceAudience.Private
    public static boolean groupTogether(Object key1, Object key2, int groupLevel) {
        if (groupLevel == 0 || !(key1 instanceof List) || !(key2 instanceof List)) {
            return key1.equals(key2);
        }
        List key1List = (List)key1;
        List key2List = (List)key2;
        int end = Math.min(groupLevel, Math.min(key1List.size(), key2List.size()));
        for (int i = 0; i < end; ++i) {
            if (key1List.get(i).equals(key2List.get(i))) continue;
            return false;
        }
        return true;
    }

    @InterfaceAudience.Private
    public static Object groupKey(Object key, int groupLevel) {
        if (groupLevel > 0 && key instanceof List && ((List)key).size() > groupLevel) {
            return ((List)key).subList(0, groupLevel);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public List<Map<String, Object>> dump() {
        if (this.getViewId() < 0) {
            return null;
        }
        String[] selectArgs = new String[]{Integer.toString(this.getViewId())};
        Cursor cursor = null;
        ArrayList<Map<String, Object>> result = null;
        try {
            cursor = this.database.getDatabase().rawQuery("SELECT sequence, key, value FROM maps WHERE view_id=? ORDER BY key", selectArgs);
            cursor.moveToNext();
            result = new ArrayList<Map<String, Object>>();
            while (!cursor.isAfterLast()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("seq", cursor.getInt(0));
                row.put("key", cursor.getString(1));
                row.put("value", cursor.getString(2));
                result.add(row);
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e("View", "Error dumping view", e);
            List<Map<String, Object>> list = null;
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    List<QueryRow> reducedQuery(Cursor cursor, boolean group, int groupLevel) throws CouchbaseLiteException {
        ArrayList<Object> keysToReduce = null;
        ArrayList<Object> valuesToReduce = null;
        Object lastKey = null;
        if (this.getReduce() != null) {
            keysToReduce = new ArrayList<Object>(100);
            valuesToReduce = new ArrayList<Object>(100);
        }
        ArrayList<QueryRow> rows = new ArrayList<QueryRow>();
        cursor.moveToNext();
        while (!cursor.isAfterLast()) {
            JsonDocument keyDoc = new JsonDocument(cursor.getBlob(0));
            JsonDocument valueDoc = new JsonDocument(cursor.getBlob(1));
            assert (keyDoc != null);
            Object keyObject = keyDoc.jsonObject();
            if (group && !View.groupTogether(keyObject, lastKey, groupLevel)) {
                if (lastKey != null) {
                    Object reduced = this.reduceBlock != null ? this.reduceBlock.reduce(keysToReduce, valuesToReduce, false) : null;
                    Object key = View.groupKey(lastKey, groupLevel);
                    QueryRow row = new QueryRow(null, 0L, key, reduced, null);
                    row.setDatabase(this.database);
                    rows.add(row);
                    keysToReduce.clear();
                    valuesToReduce.clear();
                }
                lastKey = keyObject;
            }
            keysToReduce.add(keyObject);
            valuesToReduce.add(valueDoc.jsonObject());
            cursor.moveToNext();
        }
        if (keysToReduce.size() > 0) {
            Object key = group ? View.groupKey(lastKey, groupLevel) : null;
            Object reduced = this.reduceBlock != null ? this.reduceBlock.reduce(keysToReduce, valuesToReduce, false) : null;
            QueryRow row = new QueryRow(null, 0L, key, reduced, null);
            row.setDatabase(this.database);
            rows.add(row);
        }
        return rows;
    }

    @InterfaceAudience.Private
    public List<QueryRow> queryWithOptions(QueryOptions options) throws CouchbaseLiteException {
        if (options == null) {
            options = new QueryOptions();
        }
        Cursor cursor = null;
        ArrayList<QueryRow> rows = new ArrayList();
        try {
            boolean reduce;
            cursor = this.resultSetWithOptions(options);
            int groupLevel = options.getGroupLevel();
            boolean group = options.isGroup() || groupLevel > 0;
            boolean bl = reduce = options.isReduce() || group;
            if (reduce && this.reduceBlock == null && !group) {
                Log.w("View", "Cannot use reduce option in view %s which has no reduce block defined", this.name);
                throw new CouchbaseLiteException(new Status(400));
            }
            if (reduce || group) {
                rows = this.reducedQuery(cursor, group, groupLevel);
            } else {
                cursor.moveToNext();
                while (!cursor.isAfterLast()) {
                    JsonDocument keyDoc = new JsonDocument(cursor.getBlob(0));
                    JsonDocument valueDoc = new JsonDocument(cursor.getBlob(1));
                    String docId = cursor.getString(2);
                    int sequence = Integer.valueOf(cursor.getString(3));
                    Map<String, Object> docContents = null;
                    if (options.isIncludeDocs()) {
                        Object valueObject = valueDoc.jsonObject();
                        if (valueObject instanceof Map && ((Map)valueObject).containsKey("_id")) {
                            String linkedDocId = (String)((Map)valueObject).get("_id");
                            RevisionInternal linkedDoc = this.database.getDocumentWithIDAndRev(linkedDocId, null, EnumSet.noneOf(Database.TDContentOptions.class));
                            docContents = linkedDoc.getProperties();
                        } else {
                            docContents = this.database.documentPropertiesFromJSON(cursor.getBlob(5), docId, cursor.getString(4), false, cursor.getLong(3), options.getContentOptions());
                        }
                    }
                    QueryRow row = new QueryRow(docId, sequence, keyDoc.jsonObject(), valueDoc.jsonObject(), docContents);
                    row.setDatabase(this.database);
                    rows.add(row);
                    cursor.moveToNext();
                }
            }
        }
        catch (SQLException e) {
            String errMsg = String.format("Error querying view: %s", this);
            Log.e("View", errMsg, e);
            throw new CouchbaseLiteException(errMsg, e, new Status(590));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return rows;
    }

    @InterfaceAudience.Private
    public static double totalValues(List<Object> values) {
        double total = 0.0;
        for (Object object : values) {
            if (object instanceof Number) {
                Number number = (Number)object;
                total += number.doubleValue();
                continue;
            }
            Log.w("View", "Warning non-numeric value found in totalValues: %s", object);
        }
        return total;
    }

    public static enum TDViewCollation {
        TDViewCollationUnicode,
        TDViewCollationRaw,
        TDViewCollationASCII;

    }
}

