/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.Revision;
import com.couchbase.lite.UnsavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public final class SavedRevision
extends Revision {
    private RevisionInternal revisionInternal;
    private boolean checkedProperties;

    @InterfaceAudience.Private
    SavedRevision(Document document, RevisionInternal revision) {
        super(document);
        this.revisionInternal = revision;
    }

    @InterfaceAudience.Private
    SavedRevision(Database database, RevisionInternal revision) {
        this(database.getDocument(revision.getDocId()), revision);
    }

    @Override
    @InterfaceAudience.Public
    public Document getDocument() {
        return this.document;
    }

    @InterfaceAudience.Public
    public boolean arePropertiesAvailable() {
        return this.revisionInternal.getProperties() != null;
    }

    @Override
    @InterfaceAudience.Public
    public List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException {
        ArrayList<SavedRevision> revisions = new ArrayList<SavedRevision>();
        List<RevisionInternal> internalRevisions = this.getDatabase().getRevisionHistory(this.revisionInternal);
        for (RevisionInternal internalRevision : internalRevisions) {
            if (internalRevision.getRevId().equals(this.getId())) {
                revisions.add(this);
                continue;
            }
            SavedRevision revision = this.document.getRevisionFromRev(internalRevision);
            revisions.add(revision);
        }
        Collections.reverse(revisions);
        return Collections.unmodifiableList(revisions);
    }

    @InterfaceAudience.Public
    public UnsavedRevision createRevision() throws CouchbaseLiteException {
        UnsavedRevision newRevision = new UnsavedRevision(this.document, this);
        return newRevision;
    }

    @InterfaceAudience.Public
    public SavedRevision createRevision(Map<String, Object> properties) throws CouchbaseLiteException {
        boolean allowConflict = false;
        return this.document.putProperties(properties, this.revisionInternal.getRevId(), allowConflict);
    }

    @Override
    @InterfaceAudience.Public
    public String getId() {
        return this.revisionInternal.getRevId();
    }

    @Override
    @InterfaceAudience.Public
    public boolean isDeletion() {
        return this.revisionInternal.isDeleted();
    }

    @Override
    @InterfaceAudience.Public
    public Map<String, Object> getProperties() {
        Map<String, Object> properties = this.revisionInternal.getProperties();
        if (properties == null && !this.checkedProperties) {
            if (this.loadProperties()) {
                properties = this.revisionInternal.getProperties();
            }
            this.checkedProperties = true;
        }
        return Collections.unmodifiableMap(properties);
    }

    @InterfaceAudience.Public
    public SavedRevision deleteDocument() throws CouchbaseLiteException {
        return this.createRevision(null);
    }

    @Override
    @InterfaceAudience.Public
    public SavedRevision getParent() {
        return this.getDocument().getRevisionFromRev(this.getDatabase().getParentRevision(this.revisionInternal));
    }

    @Override
    @InterfaceAudience.Public
    public String getParentId() {
        RevisionInternal parRev = this.getDocument().getDatabase().getParentRevision(this.revisionInternal);
        if (parRev == null) {
            return null;
        }
        return parRev.getRevId();
    }

    @Override
    @InterfaceAudience.Public
    public long getSequence() {
        long sequence = this.revisionInternal.getSequence();
        if (sequence == 0L && this.loadProperties()) {
            sequence = this.revisionInternal.getSequence();
        }
        return sequence;
    }

    @InterfaceAudience.Private
    boolean loadProperties() {
        try {
            RevisionInternal loadRevision = this.getDatabase().loadRevisionBody(this.revisionInternal, EnumSet.noneOf(Database.TDContentOptions.class));
            if (loadRevision == null) {
                Log.w("CBLite", "%s: Couldn't load body/sequence", this);
                return false;
            }
            this.revisionInternal = loadRevision;
            return true;
        }
        catch (CouchbaseLiteException e) {
            throw new RuntimeException(e);
        }
    }
}

