/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Misc;
import com.couchbase.lite.internal.RevisionInternal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RevisionList
extends ArrayList<RevisionInternal> {
    public RevisionList() {
    }

    public RevisionList(List<RevisionInternal> list) {
        super(list);
    }

    public RevisionInternal revWithDocIdAndRevId(String docId, String revId) {
        for (RevisionInternal rev : this) {
            if (!docId.equals(rev.getDocId()) || !revId.equals(rev.getRevId())) continue;
            return rev;
        }
        return null;
    }

    public List<String> getAllDocIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (RevisionInternal rev : this) {
            result.add(rev.getDocId());
        }
        return result;
    }

    public List<String> getAllRevIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (RevisionInternal rev : this) {
            result.add(rev.getRevId());
        }
        return result;
    }

    public void sortBySequence() {
        Collections.sort(this, new Comparator<RevisionInternal>(){

            @Override
            public int compare(RevisionInternal rev1, RevisionInternal rev2) {
                return Misc.TDSequenceCompare(rev1.getSequence(), rev2.getSequence());
            }
        });
    }

    public void limit(int limit) {
        if (this.size() > limit) {
            this.removeRange(limit, this.size());
        }
    }
}

