/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Attachment;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Revision {
    protected long sequence;
    protected Document document;
    protected String parentRevID;
    protected SavedRevision parentRevision;

    @InterfaceAudience.Private
    Revision() {
    }

    @InterfaceAudience.Private
    protected Revision(Document document) {
        this.document = document;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.document.getDatabase();
    }

    @InterfaceAudience.Public
    public Document getDocument() {
        return this.document;
    }

    @InterfaceAudience.Public
    public abstract String getId();

    @InterfaceAudience.Public
    public boolean isDeletion() {
        Object deleted = this.getProperty("_deleted");
        if (deleted == null) {
            return false;
        }
        Boolean deletedBool = (Boolean)deleted;
        return deletedBool;
    }

    @InterfaceAudience.Public
    public abstract Map<String, Object> getProperties();

    @InterfaceAudience.Public
    public Map<String, Object> getUserProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> sourceMap = this.getProperties();
        for (String key : sourceMap.keySet()) {
            if (key.startsWith("_")) continue;
            result.put(key, sourceMap.get(key));
        }
        return result;
    }

    @InterfaceAudience.Public
    public List<String> getAttachmentNames() {
        Map<String, Object> attachmentMetadata = this.getAttachmentMetadata();
        ArrayList<String> result = new ArrayList<String>();
        if (attachmentMetadata != null) {
            result.addAll(attachmentMetadata.keySet());
        }
        return result;
    }

    @InterfaceAudience.Public
    public List<Attachment> getAttachments() {
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        List<String> attachmentNames = this.getAttachmentNames();
        for (String attachmentName : attachmentNames) {
            result.add(this.getAttachment(attachmentName));
        }
        return result;
    }

    @InterfaceAudience.Public
    public Object getProperty(String key) {
        return this.getProperties().get(key);
    }

    @InterfaceAudience.Public
    public Attachment getAttachment(String name) {
        Map<String, Object> attachmentsMetadata = this.getAttachmentMetadata();
        if (attachmentsMetadata == null) {
            return null;
        }
        Map attachmentMetadata = (Map)attachmentsMetadata.get(name);
        return new Attachment(this, name, attachmentMetadata);
    }

    @InterfaceAudience.Public
    public abstract SavedRevision getParent();

    @InterfaceAudience.Public
    public abstract String getParentId();

    @InterfaceAudience.Public
    public abstract List<SavedRevision> getRevisionHistory() throws CouchbaseLiteException;

    @InterfaceAudience.Public
    public boolean isGone() {
        boolean wasRemovedFromChannel = false;
        Object removed = this.getProperty("_removed");
        if (removed != null) {
            Boolean removedBoolean = (Boolean)removed;
            wasRemovedFromChannel = removedBoolean;
        }
        return this.isDeletion() || wasRemovedFromChannel;
    }

    @InterfaceAudience.Public
    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof SavedRevision) {
            SavedRevision other = (SavedRevision)o;
            if (this.document.getId().equals(other.getDocument().getId()) && this.getId().equals(other.getId())) {
                result = true;
            }
        }
        return result;
    }

    @InterfaceAudience.Public
    public int hashCode() {
        return this.document.getId().hashCode() ^ this.getId().hashCode();
    }

    @InterfaceAudience.Public
    public String toString() {
        return "{" + this.document.getId() + " #" + this.getId() + (this.isDeletion() ? "DEL" : "") + "}";
    }

    @InterfaceAudience.Private
    Map<String, Object> getAttachmentMetadata() {
        return (Map)this.getProperty("_attachments");
    }

    @InterfaceAudience.Private
    void setParentRevisionID(String parentRevID) {
        this.parentRevID = parentRevID;
    }

    @InterfaceAudience.Private
    void setSequence(long sequence) {
        this.sequence = sequence;
    }

    @InterfaceAudience.Private
    long getSequence() {
        return this.sequence;
    }

    @InterfaceAudience.Private
    int getGeneration() {
        return Revision.generationFromRevID(this.getId());
    }

    @InterfaceAudience.Private
    static int generationFromRevID(String revID) {
        int generation = 0;
        int dashPos = revID.indexOf("-");
        if (dashPos > 0) {
            generation = Integer.parseInt(revID.substring(0, dashPos));
        }
        return generation;
    }
}

