/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.Database;
import com.couchbase.lite.Document;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryRow {
    private Object key;
    private Object value;
    private long sequence;
    private String sourceDocumentId;
    private Map<String, Object> documentProperties;
    private Database database;

    @InterfaceAudience.Private
    QueryRow(String documentId, long sequence, Object key, Object value, Map<String, Object> documentProperties) {
        this.sourceDocumentId = documentId;
        this.sequence = sequence;
        this.key = key;
        this.value = value;
        this.documentProperties = documentProperties;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Public
    public Document getDocument() {
        if (this.getDocumentId() == null) {
            return null;
        }
        Document document = this.database.getDocument(this.getDocumentId());
        document.loadCurrentRevisionFrom(this);
        return document;
    }

    @InterfaceAudience.Public
    public Object getKey() {
        return this.key;
    }

    @InterfaceAudience.Public
    public Object getValue() {
        return this.value;
    }

    @InterfaceAudience.Public
    public String getDocumentId() {
        if (this.documentProperties != null && this.documentProperties.get("_id") != null && this.documentProperties.get("_id") instanceof String) {
            return (String)this.documentProperties.get("_id");
        }
        return this.sourceDocumentId;
    }

    @InterfaceAudience.Public
    public String getSourceDocumentId() {
        return this.sourceDocumentId;
    }

    @InterfaceAudience.Public
    public String getDocumentRevisionId() {
        Map mapValue;
        String rev = null;
        if (this.documentProperties != null && this.documentProperties.containsKey("_rev")) {
            rev = (String)this.documentProperties.get("_rev");
        }
        if (rev == null && this.value instanceof Map && (rev = (String)(mapValue = (Map)this.value).get("_rev")) == null) {
            rev = (String)mapValue.get("rev");
        }
        return rev;
    }

    @InterfaceAudience.Public
    public Map<String, Object> getDocumentProperties() {
        return this.documentProperties != null ? Collections.unmodifiableMap(this.documentProperties) : null;
    }

    @InterfaceAudience.Public
    public long getSequenceNumber() {
        return this.sequence;
    }

    @InterfaceAudience.Public
    public List<SavedRevision> getConflictingRevisions() {
        Document doc = this.database.getDocument(this.sourceDocumentId);
        Map valueTmp = (Map)this.value;
        ArrayList conflicts = (ArrayList)valueTmp.get("_conflicts");
        if (conflicts == null) {
            conflicts = new ArrayList();
        }
        ArrayList<SavedRevision> conflictingRevisions = new ArrayList<SavedRevision>();
        for (String conflictRevisionId : conflicts) {
            SavedRevision revision = doc.getRevision(conflictRevisionId);
            conflictingRevisions.add(revision);
        }
        return conflictingRevisions;
    }

    @InterfaceAudience.Public
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QueryRow)) {
            return false;
        }
        QueryRow other = (QueryRow)object;
        boolean documentPropertiesEqual = Utils.isEqual(this.documentProperties, other.getDocumentProperties());
        if (this.database == other.database && Utils.isEqual(this.key, other.getKey()) && Utils.isEqual(this.sourceDocumentId, other.getSourceDocumentId()) && documentPropertiesEqual) {
            if (this.value != null || other.getValue() != null) {
                return this.value.equals(other.getValue());
            }
            return this.sequence == other.sequence;
        }
        return false;
    }

    @InterfaceAudience.Public
    public String toString() {
        return this.asJSONDictionary().toString();
    }

    @InterfaceAudience.Private
    void setDatabase(Database database) {
        this.database = database;
    }

    @InterfaceAudience.Private
    public Map<String, Object> asJSONDictionary() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.value != null || this.sourceDocumentId != null) {
            result.put("key", this.key);
            if (this.value != null) {
                result.put("value", this.value);
            }
            result.put("id", this.sourceDocumentId);
            if (this.documentProperties != null) {
                result.put("doc", this.documentProperties);
            }
        } else {
            result.put("key", this.key);
            result.put("error", "not_found");
        }
        return result;
    }
}

