/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.LiveQuery;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.QueryEnumerator;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.View;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class Query {
    private Database database;
    private View view;
    private boolean temporaryView;
    private int skip;
    private int limit = Integer.MAX_VALUE;
    private Object startKey;
    private Object endKey;
    private String startKeyDocId;
    private String endKeyDocId;
    private IndexUpdateMode indexUpdateMode;
    private AllDocsMode allDocsMode;
    private boolean descending;
    private boolean prefetch;
    private boolean mapOnly;
    private boolean includeDeleted;
    private List<Object> keys;
    private int groupLevel;
    private long lastSequence;

    @InterfaceAudience.Private
    Query(Database database, View view) {
        this.database = database;
        this.view = view;
        this.limit = Integer.MAX_VALUE;
        this.mapOnly = view != null && view.getReduce() == null;
        this.indexUpdateMode = IndexUpdateMode.BEFORE;
        this.allDocsMode = AllDocsMode.ALL_DOCS;
    }

    @InterfaceAudience.Private
    Query(Database database, Mapper mapFunction) {
        this(database, database.makeAnonymousView());
        this.temporaryView = true;
        this.view.setMap(mapFunction, "");
    }

    @InterfaceAudience.Private
    Query(Database database, Query query) {
        this(database, query.getView());
        this.limit = query.limit;
        this.skip = query.skip;
        this.startKey = query.startKey;
        this.endKey = query.endKey;
        this.descending = query.descending;
        this.prefetch = query.prefetch;
        this.keys = query.keys;
        this.groupLevel = query.groupLevel;
        this.mapOnly = query.mapOnly;
        this.startKeyDocId = query.startKeyDocId;
        this.endKeyDocId = query.endKeyDocId;
        this.indexUpdateMode = query.indexUpdateMode;
        this.allDocsMode = query.allDocsMode;
    }

    @InterfaceAudience.Public
    public Database getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Public
    public int getLimit() {
        return this.limit;
    }

    @InterfaceAudience.Public
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @InterfaceAudience.Public
    public int getSkip() {
        return this.skip;
    }

    @InterfaceAudience.Public
    public void setSkip(int skip) {
        this.skip = skip;
    }

    @InterfaceAudience.Public
    public boolean isDescending() {
        return this.descending;
    }

    @InterfaceAudience.Public
    public void setDescending(boolean descending) {
        this.descending = descending;
    }

    @InterfaceAudience.Public
    public Object getStartKey() {
        return this.startKey;
    }

    @InterfaceAudience.Public
    public void setStartKey(Object startKey) {
        this.startKey = startKey;
    }

    @InterfaceAudience.Public
    public Object getEndKey() {
        return this.endKey;
    }

    @InterfaceAudience.Public
    public void setEndKey(Object endKey) {
        this.endKey = endKey;
    }

    @InterfaceAudience.Public
    public String getStartKeyDocId() {
        return this.startKeyDocId;
    }

    @InterfaceAudience.Public
    public void setStartKeyDocId(String startKeyDocId) {
        this.startKeyDocId = startKeyDocId;
    }

    @InterfaceAudience.Public
    public String getEndKeyDocId() {
        return this.endKeyDocId;
    }

    @InterfaceAudience.Public
    public void setEndKeyDocId(String endKeyDocId) {
        this.endKeyDocId = endKeyDocId;
    }

    @InterfaceAudience.Public
    public IndexUpdateMode getIndexUpdateMode() {
        return this.indexUpdateMode;
    }

    @InterfaceAudience.Public
    public void setIndexUpdateMode(IndexUpdateMode indexUpdateMode) {
        this.indexUpdateMode = indexUpdateMode;
    }

    @InterfaceAudience.Public
    public AllDocsMode getAllDocsMode() {
        return this.allDocsMode;
    }

    @InterfaceAudience.Public
    public void setAllDocsMode(AllDocsMode allDocsMode) {
        this.allDocsMode = allDocsMode;
    }

    @InterfaceAudience.Public
    public List<Object> getKeys() {
        return this.keys;
    }

    @InterfaceAudience.Public
    public void setKeys(List<Object> keys) {
        this.keys = keys;
    }

    @InterfaceAudience.Public
    public boolean isMapOnly() {
        return this.mapOnly;
    }

    @InterfaceAudience.Public
    public void setMapOnly(boolean mapOnly) {
        this.mapOnly = mapOnly;
    }

    @InterfaceAudience.Public
    public int getGroupLevel() {
        return this.groupLevel;
    }

    @InterfaceAudience.Public
    public void setGroupLevel(int groupLevel) {
        this.groupLevel = groupLevel;
    }

    @InterfaceAudience.Public
    public boolean shouldPrefetch() {
        return this.prefetch;
    }

    @InterfaceAudience.Public
    public void setPrefetch(boolean prefetch) {
        this.prefetch = prefetch;
    }

    @InterfaceAudience.Public
    public boolean shouldIncludeDeleted() {
        return this.allDocsMode == AllDocsMode.INCLUDE_DELETED;
    }

    @InterfaceAudience.Public
    public void setIncludeDeleted(boolean includeDeletedParam) {
        this.allDocsMode = includeDeletedParam ? AllDocsMode.INCLUDE_DELETED : AllDocsMode.ALL_DOCS;
    }

    @InterfaceAudience.Public
    public QueryEnumerator run() throws CouchbaseLiteException {
        ArrayList<Long> outSequence = new ArrayList<Long>();
        String viewName = this.view != null ? this.view.getName() : null;
        List<QueryRow> rows = this.database.queryViewNamed(viewName, this.getQueryOptions(), outSequence);
        this.lastSequence = (Long)outSequence.get(0);
        return new QueryEnumerator(this.database, rows, this.lastSequence);
    }

    @InterfaceAudience.Public
    public LiveQuery toLiveQuery() {
        if (this.view == null) {
            throw new IllegalStateException("Cannot convert a Query to LiveQuery if the view is null");
        }
        return new LiveQuery(this);
    }

    @InterfaceAudience.Public
    public Future runAsync(QueryCompleteListener onComplete) {
        return this.runAsyncInternal(onComplete);
    }

    @InterfaceAudience.Private
    Future runAsyncInternal(final QueryCompleteListener onComplete) {
        return this.database.getManager().runAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Query.this.getDatabase().isOpen()) {
                        throw new IllegalStateException("The database has been closed.");
                    }
                    String viewName = Query.this.view.getName();
                    QueryOptions options = Query.this.getQueryOptions();
                    ArrayList<Long> outSequence = new ArrayList<Long>();
                    List<QueryRow> rows = Query.this.database.queryViewNamed(viewName, options, outSequence);
                    long sequenceNumber = (Long)outSequence.get(0);
                    QueryEnumerator enumerator = new QueryEnumerator(Query.this.database, rows, sequenceNumber);
                    onComplete.completed(enumerator, null);
                }
                catch (Throwable t) {
                    Log.e("Query", "Exception caught in runAsyncInternal", t);
                    onComplete.completed(null, t);
                }
            }
        });
    }

    @InterfaceAudience.Private
    public View getView() {
        return this.view;
    }

    @InterfaceAudience.Private
    private QueryOptions getQueryOptions() {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setStartKey(this.getStartKey());
        queryOptions.setEndKey(this.getEndKey());
        queryOptions.setStartKey(this.getStartKey());
        queryOptions.setKeys(this.getKeys());
        queryOptions.setSkip(this.getSkip());
        queryOptions.setLimit(this.getLimit());
        queryOptions.setReduce(!this.isMapOnly());
        queryOptions.setReduceSpecified(true);
        queryOptions.setGroupLevel(this.getGroupLevel());
        queryOptions.setDescending(this.isDescending());
        queryOptions.setIncludeDocs(this.shouldPrefetch());
        queryOptions.setUpdateSeq(true);
        queryOptions.setInclusiveEnd(true);
        queryOptions.setStale(this.getIndexUpdateMode());
        queryOptions.setAllDocsMode(this.getAllDocsMode());
        queryOptions.setStartKeyDocId(this.getStartKeyDocId());
        queryOptions.setEndKeyDocId(this.getEndKeyDocId());
        return queryOptions;
    }

    @InterfaceAudience.Private
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.temporaryView) {
            this.view.delete();
        }
    }

    @InterfaceAudience.Public
    public static interface QueryCompleteListener {
        public void completed(QueryEnumerator var1, Throwable var2);
    }

    public static enum AllDocsMode {
        ALL_DOCS,
        INCLUDE_DELETED,
        SHOW_CONFLICTS,
        ONLY_CONFLICTS;

    }

    public static enum IndexUpdateMode {
        BEFORE,
        NEVER,
        AFTER;

    }
}

