/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.NetworkReachabilityListener;
import java.util.ArrayList;
import java.util.List;

public abstract class NetworkReachabilityManager {
    protected List<NetworkReachabilityListener> networkReachabilityListeners;

    public synchronized void addNetworkReachabilityListener(NetworkReachabilityListener listener) {
        if (this.networkReachabilityListeners == null) {
            this.networkReachabilityListeners = new ArrayList<NetworkReachabilityListener>();
        }
        int numListenersBeforeAdd = this.networkReachabilityListeners.size();
        this.networkReachabilityListeners.add(listener);
        if (numListenersBeforeAdd == 0) {
            this.startListening();
        }
    }

    public synchronized void removeNetworkReachabilityListener(NetworkReachabilityListener listener) {
        if (this.networkReachabilityListeners == null) {
            this.networkReachabilityListeners = new ArrayList<NetworkReachabilityListener>();
        }
        this.networkReachabilityListeners.remove(listener);
        if (this.networkReachabilityListeners.size() == 0) {
            this.stopListening();
        }
    }

    public synchronized void notifyListenersNetworkReachable() {
        for (NetworkReachabilityListener networkReachabilityListener : this.networkReachabilityListeners) {
            networkReachabilityListener.networkReachable();
        }
    }

    public synchronized void notifyListenersNetworkUneachable() {
        for (NetworkReachabilityListener networkReachabilityListener : this.networkReachabilityListeners) {
            networkReachabilityListener.networkUnreachable();
        }
    }

    public abstract void startListening();

    public abstract void stopListening();
}

