/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.Context;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.ManagerOptions;
import com.couchbase.lite.Status;
import com.couchbase.lite.auth.Authorizer;
import com.couchbase.lite.auth.FacebookAuthorizer;
import com.couchbase.lite.auth.PersonaAuthorizer;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.replicator.Puller;
import com.couchbase.lite.replicator.Pusher;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.support.FileDirUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.Version;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.StreamUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.map.ObjectMapper;

public final class Manager {
    public static final String HTTP_ERROR_DOMAIN = "CBLHTTP";
    public static final String DATABASE_SUFFIX_OLD = ".touchdb";
    public static final String DATABASE_SUFFIX = ".cblite";
    public static final ManagerOptions DEFAULT_OPTIONS = new ManagerOptions();
    public static final String LEGAL_CHARACTERS = "[^a-z]{1,}[^a-z0-9_$()/+-]*$";
    public static final String VERSION = Version.VERSION;
    private static final ObjectMapper mapper = new ObjectMapper();
    private ManagerOptions options;
    private File directoryFile;
    private Map<String, Database> databases;
    private List<Replication> replications;
    private ScheduledExecutorService workExecutor;
    private HttpClientFactory defaultHttpClientFactory;
    private Context context;

    @InterfaceAudience.Private
    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    @InterfaceAudience.Public
    public Manager() {
        String detailMessage = "Parameterless constructor is not a valid API call on Android.  Pure java version coming soon.";
        throw new UnsupportedOperationException("Parameterless constructor is not a valid API call on Android.  Pure java version coming soon.");
    }

    public static void enableLogging(String tag, int logLevel) {
        Log.enableLogging(tag, logLevel);
    }

    @InterfaceAudience.Public
    public Manager(Context context, ManagerOptions options) throws IOException {
        Log.i("CBLite", "Starting Manager version: %s", VERSION);
        this.context = context;
        this.directoryFile = context.getFilesDir();
        this.options = options != null ? options : DEFAULT_OPTIONS;
        this.databases = new HashMap<String, Database>();
        this.replications = new ArrayList<Replication>();
        this.directoryFile.mkdirs();
        if (!this.directoryFile.isDirectory()) {
            throw new IOException(String.format("Unable to create directory for: %s", this.directoryFile));
        }
        this.upgradeOldDatabaseFiles(this.directoryFile);
        this.workExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    @InterfaceAudience.Public
    public static Manager getSharedInstance() {
        String detailMessage = "getSharedInstance() is not a valid API call on Android.  Pure java version coming soon";
        throw new UnsupportedOperationException("getSharedInstance() is not a valid API call on Android.  Pure java version coming soon");
    }

    @InterfaceAudience.Public
    public static boolean isValidDatabaseName(String databaseName) {
        if (databaseName.length() > 0 && databaseName.length() < 240 && Manager.containsOnlyLegalCharacters(databaseName) && Character.isLowerCase(databaseName.charAt(0))) {
            return true;
        }
        return databaseName.equals("_replicator");
    }

    @InterfaceAudience.Public
    public File getDirectory() {
        return this.directoryFile;
    }

    @InterfaceAudience.Public
    public List<String> getAllDatabaseNames() {
        String[] databaseFiles = this.directoryFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(Manager.DATABASE_SUFFIX);
            }
        });
        ArrayList<String> result = new ArrayList<String>();
        for (String databaseFile : databaseFiles) {
            String trimmed = databaseFile.substring(0, databaseFile.length() - DATABASE_SUFFIX.length());
            String replaced = trimmed.replace(':', '/');
            result.add(replaced);
        }
        Collections.sort(result);
        return Collections.unmodifiableList(result);
    }

    @InterfaceAudience.Public
    public void close() {
        Log.i("CBLite", "Closing " + this);
        for (Database database : this.databases.values()) {
            List<Replication> replicators = database.getAllReplications();
            if (replicators != null) {
                for (Replication replicator : replicators) {
                    replicator.stop();
                }
            }
            database.close();
        }
        this.databases.clear();
        this.context.getNetworkReachabilityManager().stopListening();
        Log.i("CBLite", "Closed " + this);
    }

    @InterfaceAudience.Public
    public Database getDatabase(String name) throws CouchbaseLiteException {
        boolean opened;
        boolean mustExist = false;
        Database db = this.getDatabaseWithoutOpening(name, mustExist);
        if (db != null && !(opened = db.open())) {
            return null;
        }
        return db;
    }

    @InterfaceAudience.Public
    public Database getExistingDatabase(String name) throws CouchbaseLiteException {
        boolean mustExist = true;
        Database db = this.getDatabaseWithoutOpening(name, mustExist);
        if (db != null) {
            db.open();
        }
        return db;
    }

    @InterfaceAudience.Public
    public void replaceDatabase(String databaseName, InputStream databaseStream, Map<String, InputStream> attachmentStreams) throws CouchbaseLiteException {
        this.replaceDatabase(databaseName, databaseStream, attachmentStreams == null ? null : attachmentStreams.entrySet().iterator());
    }

    private void replaceDatabase(String databaseName, InputStream databaseStream, Iterator<Map.Entry<String, InputStream>> attachmentStreams) throws CouchbaseLiteException {
        try {
            Database database = this.getDatabase(databaseName);
            String dstAttachmentsPath = database.getAttachmentStorePath();
            FileOutputStream destStream = new FileOutputStream(new File(database.getPath()));
            StreamUtils.copyStream(databaseStream, destStream);
            File attachmentsFile = new File(dstAttachmentsPath);
            FileDirUtils.deleteRecursive(attachmentsFile);
            attachmentsFile.mkdirs();
            if (attachmentStreams != null) {
                StreamUtils.copyStreamsToFolder(attachmentStreams, attachmentsFile);
            }
            database.open();
            database.replaceUUIDs();
        }
        catch (FileNotFoundException e) {
            Log.e("CBLite", "", e);
            throw new CouchbaseLiteException(500);
        }
        catch (IOException e) {
            Log.e("CBLite", "", e);
            throw new CouchbaseLiteException(500);
        }
    }

    @InterfaceAudience.Private
    public HttpClientFactory getDefaultHttpClientFactory() {
        return this.defaultHttpClientFactory;
    }

    @InterfaceAudience.Private
    public void setDefaultHttpClientFactory(HttpClientFactory defaultHttpClientFactory) {
        this.defaultHttpClientFactory = defaultHttpClientFactory;
    }

    @InterfaceAudience.Private
    private static boolean containsOnlyLegalCharacters(String databaseName) {
        Pattern p = Pattern.compile("^[abcdefghijklmnopqrstuvwxyz0123456789_$()+-/]+$");
        Matcher matcher = p.matcher(databaseName);
        return matcher.matches();
    }

    @InterfaceAudience.Private
    private void upgradeOldDatabaseFiles(File directory) {
        File[] files;
        for (File file : files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith(Manager.DATABASE_SUFFIX_OLD);
            }
        })) {
            String oldFilename = file.getName();
            String newFilename = this.filenameWithNewExtension(oldFilename, DATABASE_SUFFIX_OLD, DATABASE_SUFFIX);
            File newFile = new File(directory, newFilename);
            if (newFile.exists()) {
                Log.w("CBLite", "Cannot rename %s to %s, %s already exists", oldFilename, newFilename, newFilename);
                continue;
            }
            boolean ok = file.renameTo(newFile);
            if (ok) continue;
            String msg = String.format("Unable to rename %s to %s", oldFilename, newFilename);
            throw new IllegalStateException(msg);
        }
    }

    @InterfaceAudience.Private
    private String filenameWithNewExtension(String oldFilename, String oldExtension, String newExtension) {
        String oldExtensionRegex = String.format("%s$", oldExtension);
        return oldFilename.replaceAll(oldExtensionRegex, newExtension);
    }

    @InterfaceAudience.Private
    public Collection<Database> allOpenDatabases() {
        return this.databases.values();
    }

    @InterfaceAudience.Private
    public Future runAsync(String databaseName, final AsyncTask function) throws CouchbaseLiteException {
        final Database database = this.getDatabase(databaseName);
        return this.runAsync(new Runnable(){

            @Override
            public void run() {
                function.run(database);
            }
        });
    }

    @InterfaceAudience.Private
    Future runAsync(Runnable runnable) {
        return this.workExecutor.submit(runnable);
    }

    @InterfaceAudience.Private
    private String pathForName(String name) {
        if (name == null || name.length() == 0 || Pattern.matches(LEGAL_CHARACTERS, name)) {
            return null;
        }
        name = name.replace('/', ':');
        String result = this.directoryFile.getPath() + File.separator + name + DATABASE_SUFFIX;
        return result;
    }

    @InterfaceAudience.Private
    private Map<String, Object> parseSourceOrTarget(Map<String, Object> properties, String key) {
        Map<String, Object> result = new HashMap<String, Object>();
        Object value = properties.get(key);
        if (value instanceof String) {
            result.put("url", (String)value);
        } else if (value instanceof Map) {
            result = (Map)value;
        }
        return result;
    }

    @InterfaceAudience.Private
    Replication replicationWithDatabase(Database db, URL remote, boolean push, boolean create, boolean start) {
        for (Replication replicator : this.replications) {
            if (replicator.getLocalDatabase() != db || !replicator.getRemoteUrl().equals(remote) || replicator.isPull() != !push) continue;
            return replicator;
        }
        if (!create) {
            return null;
        }
        Replication replicator = null;
        boolean continuous = false;
        replicator = push ? new Pusher(db, remote, false, this.getWorkExecutor()) : new Puller(db, remote, false, this.getWorkExecutor());
        this.replications.add(replicator);
        if (start) {
            replicator.start();
        }
        return replicator;
    }

    @InterfaceAudience.Private
    public synchronized Database getDatabaseWithoutOpening(String name, boolean mustExist) {
        Database db = this.databases.get(name);
        if (db == null) {
            String path;
            if (!Manager.isValidDatabaseName(name)) {
                throw new IllegalArgumentException("Invalid database name: " + name);
            }
            if (this.options.isReadOnly()) {
                mustExist = true;
            }
            if ((path = this.pathForName(name)) == null) {
                return null;
            }
            db = new Database(path, this);
            if (mustExist && !db.exists()) {
                Log.w("CBLite", "mustExist is true and db (%s) does not exist", name);
                return null;
            }
            db.setName(name);
            this.databases.put(name, db);
        }
        return db;
    }

    @InterfaceAudience.Private
    void forgetDatabase(Database db) {
        this.databases.remove(db.getName());
        Iterator<Replication> replicationIterator = this.replications.iterator();
        while (replicationIterator.hasNext()) {
            Replication replication = replicationIterator.next();
            if (!replication.getLocalDatabase().getName().equals(db.getName())) continue;
            replicationIterator.remove();
        }
    }

    @InterfaceAudience.Private
    public Replication getReplicator(Map<String, Object> properties) throws CouchbaseLiteException {
        Map<String, Object> remoteMap;
        boolean cancel;
        Authorizer authorizer = null;
        Replication repl = null;
        URL remote = null;
        Map<String, Object> sourceMap = this.parseSourceOrTarget(properties, "source");
        Map<String, Object> targetMap = this.parseSourceOrTarget(properties, "target");
        String source = (String)sourceMap.get("url");
        String target = (String)targetMap.get("url");
        Boolean createTargetBoolean = (Boolean)properties.get("create_target");
        boolean createTarget = createTargetBoolean != null && createTargetBoolean != false;
        Boolean continuousBoolean = (Boolean)properties.get("continuous");
        boolean continuous = continuousBoolean != null && continuousBoolean != false;
        Boolean cancelBoolean = (Boolean)properties.get("cancel");
        boolean bl = cancel = cancelBoolean != null && cancelBoolean != false;
        if (source == null || target == null) {
            throw new CouchbaseLiteException("source and target are both null", new Status(400));
        }
        boolean push = false;
        Database db = null;
        String remoteStr = null;
        if (Manager.isValidDatabaseName(source)) {
            db = this.getExistingDatabase(source);
            remoteStr = target;
            push = true;
            remoteMap = targetMap;
        } else {
            remoteStr = source;
            if (createTarget && !cancel) {
                boolean mustExist = false;
                db = this.getDatabaseWithoutOpening(target, mustExist);
                if (!db.open()) {
                    throw new CouchbaseLiteException("cannot open database: " + db, new Status(500));
                }
            } else {
                db = this.getExistingDatabase(target);
            }
            if (db == null) {
                throw new CouchbaseLiteException("database is null", new Status(404));
            }
            remoteMap = sourceMap;
        }
        Map authMap = (Map)remoteMap.get("auth");
        if (authMap != null) {
            Map facebook;
            Map persona = (Map)authMap.get("persona");
            if (persona != null) {
                String email = (String)persona.get("email");
                authorizer = new PersonaAuthorizer(email);
            }
            if ((facebook = (Map)authMap.get("facebook")) != null) {
                String email = (String)facebook.get("email");
                authorizer = new FacebookAuthorizer(email);
            }
        }
        try {
            remote = new URL(remoteStr);
        }
        catch (MalformedURLException e) {
            throw new CouchbaseLiteException("malformed remote url: " + remoteStr, new Status(400));
        }
        if (remote == null) {
            throw new CouchbaseLiteException("remote URL is null: " + remoteStr, new Status(400));
        }
        if (!cancel) {
            String filterName;
            Map headers;
            repl = db.getReplicator(remote, this.getDefaultHttpClientFactory(), push, continuous, this.getWorkExecutor());
            if (repl == null) {
                throw new CouchbaseLiteException("unable to create replicator with remote: " + remote, new Status(500));
            }
            if (authorizer != null) {
                repl.setAuthenticator(authorizer);
            }
            if ((headers = (Map)properties.get("headers")) != null && !headers.isEmpty()) {
                repl.setHeaders(headers);
            }
            if ((filterName = (String)properties.get("filter")) != null) {
                repl.setFilter(filterName);
                Map filterParams = (Map)properties.get("query_params");
                if (filterParams != null) {
                    repl.setFilterParams(filterParams);
                }
            }
            if (push) {
                ((Pusher)repl).setCreateTarget(createTarget);
            }
        } else {
            repl = db.getActiveReplicator(remote, push);
            if (repl == null) {
                throw new CouchbaseLiteException("unable to lookup replicator with remote: " + remote, new Status(404));
            }
        }
        return repl;
    }

    @InterfaceAudience.Private
    public ScheduledExecutorService getWorkExecutor() {
        return this.workExecutor;
    }

    @InterfaceAudience.Private
    public Context getContext() {
        return this.context;
    }
}

