/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Database;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryEnumerator;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public final class LiveQuery
extends Query
implements Database.ChangeListener {
    private boolean observing;
    private QueryEnumerator rows;
    private List<ChangeListener> observers = new ArrayList<ChangeListener>();
    private Throwable lastError;
    private AtomicBoolean runningState = new AtomicBoolean(false);
    protected Future queryFuture;
    protected Future rerunUpdateFuture;

    @InterfaceAudience.Private
    LiveQuery(Query query) {
        super(query.getDatabase(), query.getView());
        this.setLimit(query.getLimit());
        this.setSkip(query.getSkip());
        this.setStartKey(query.getStartKey());
        this.setEndKey(query.getEndKey());
        this.setDescending(query.isDescending());
        this.setPrefetch(query.shouldPrefetch());
        this.setKeys(query.getKeys());
        this.setGroupLevel(query.getGroupLevel());
        this.setMapOnly(query.isMapOnly());
        this.setStartKeyDocId(query.getStartKeyDocId());
        this.setEndKeyDocId(query.getEndKeyDocId());
        this.setIndexUpdateMode(query.getIndexUpdateMode());
    }

    @Override
    @InterfaceAudience.Public
    public QueryEnumerator run() throws CouchbaseLiteException {
        while (true) {
            try {
                this.waitForRows();
            }
            catch (Exception e) {
                if (e instanceof CancellationException) continue;
                this.lastError = e;
                throw new CouchbaseLiteException((Throwable)e, 500);
            }
            break;
        }
        if (this.rows == null) {
            return null;
        }
        return new QueryEnumerator(this.rows);
    }

    @InterfaceAudience.Public
    public Throwable getLastError() {
        return this.lastError;
    }

    @InterfaceAudience.Public
    public void start() {
        if (this.runningState.get()) {
            Log.v("Query", "%s: start() called, but runningState is already true.  Ignoring.", this);
            return;
        }
        Log.d("Query", "%s: start() called", this);
        this.runningState.set(true);
        if (!this.observing) {
            this.observing = true;
            this.getDatabase().addChangeListener(this);
            Log.v("Query", "%s: start() is calling update()", this);
            this.update();
        }
    }

    @InterfaceAudience.Public
    public void stop() {
        boolean cancelled;
        if (!this.runningState.get()) {
            Log.d("Query", "%s: stop() called, but runningState is already false.  Ignoring.", this);
            return;
        }
        Log.d("Query", "%s: stop() called", this);
        this.runningState.set(false);
        if (this.observing) {
            this.observing = false;
            this.getDatabase().removeChangeListener(this);
        }
        if (this.queryFuture != null) {
            cancelled = this.queryFuture.cancel(true);
            Log.v("Query", "%s: cancelled queryFuture %s, returned: %s", this, this.queryFuture, cancelled);
        }
        if (this.rerunUpdateFuture != null) {
            cancelled = this.rerunUpdateFuture.cancel(true);
            Log.d("Query", "%s: cancelled rerunUpdateFuture %s, returned: %s", this, this.rerunUpdateFuture, cancelled);
        }
    }

    @InterfaceAudience.Public
    public void waitForRows() throws CouchbaseLiteException {
        this.start();
        while (true) {
            try {
                this.queryFuture.get();
            }
            catch (Exception e) {
                if (e instanceof CancellationException) continue;
                this.lastError = e;
                throw new CouchbaseLiteException((Throwable)e, 500);
            }
            break;
        }
    }

    @InterfaceAudience.Public
    public QueryEnumerator getRows() {
        this.start();
        if (this.rows == null) {
            return null;
        }
        return new QueryEnumerator(this.rows);
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener changeListener) {
        this.observers.add(changeListener);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener changeListener) {
        this.observers.remove(changeListener);
    }

    @InterfaceAudience.Private
    void update() {
        Log.v("Query", "%s: update() called.", this);
        if (this.getView() == null) {
            throw new IllegalStateException("Cannot start LiveQuery when view is null");
        }
        if (!this.runningState.get()) {
            Log.d("Query", "%s: update() called, but running state == false.  Ignoring.", this);
            return;
        }
        if (this.queryFuture != null && !this.queryFuture.isCancelled() && !this.queryFuture.isDone()) {
            Log.d("Query", "%s: already a query in flight, scheduling call to update() once it's done", this);
            if (this.rerunUpdateFuture != null && !this.rerunUpdateFuture.isCancelled() && !this.rerunUpdateFuture.isDone()) {
                boolean cancelResult = this.rerunUpdateFuture.cancel(true);
                Log.d("Query", "%s: cancelled %s result: %s", this, this.rerunUpdateFuture, cancelResult);
            }
            this.rerunUpdateFuture = this.rerunUpdateAfterQueryFinishes();
            Log.d("Query", "%s: created new rerunUpdateFuture: %s", this, this.rerunUpdateFuture);
            return;
        }
        this.queryFuture = this.runAsyncInternal(new Query.QueryCompleteListener(){

            @Override
            public void completed(QueryEnumerator rowsParam, Throwable error) {
                if (error != null) {
                    for (ChangeListener observer : LiveQuery.this.observers) {
                        observer.changed(new ChangeEvent(error));
                    }
                    LiveQuery.this.lastError = error;
                } else {
                    if (rowsParam != null && !rowsParam.equals(LiveQuery.this.rows)) {
                        LiveQuery.this.setRows(rowsParam);
                        for (ChangeListener observer : LiveQuery.this.observers) {
                            Log.d("Query", "%s: update() calling back observer with rows", LiveQuery.this);
                            observer.changed(new ChangeEvent(LiveQuery.this, LiveQuery.this.rows));
                        }
                    }
                    LiveQuery.this.lastError = null;
                }
            }
        });
        Log.d("Query", "%s: update() created queryFuture: %s", this, this.queryFuture);
    }

    private Future rerunUpdateAfterQueryFinishes() {
        return this.getDatabase().getManager().runAsync(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (!LiveQuery.this.runningState.get()) {
                        Log.v("Query", "%s: rerunUpdateAfterQueryFinishes.run() fired, but running state == false.  Ignoring.", this);
                        return;
                    }
                    if (LiveQuery.this.queryFuture != null) {
                        try {
                            LiveQuery.this.queryFuture.get();
                            LiveQuery.this.update();
                        }
                        catch (Exception e) {
                            if (e instanceof CancellationException) break block4;
                            Log.e("Query", "Got exception waiting for queryFuture to finish", e);
                        }
                    }
                }
            }
        });
    }

    @Override
    @InterfaceAudience.Private
    public void changed(Database.ChangeEvent event) {
        this.update();
    }

    @InterfaceAudience.Private
    private synchronized void setRows(QueryEnumerator queryEnumerator) {
        this.rows = queryEnumerator;
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private LiveQuery source;
        private Throwable error;
        private QueryEnumerator queryEnumerator;

        ChangeEvent() {
        }

        ChangeEvent(LiveQuery source, QueryEnumerator queryEnumerator) {
            this.source = source;
            this.queryEnumerator = queryEnumerator;
        }

        ChangeEvent(Throwable error) {
            this.error = error;
        }

        public LiveQuery getSource() {
            return this.source;
        }

        public Throwable getError() {
            return this.error;
        }

        public QueryEnumerator getRows() {
            return this.queryEnumerator;
        }
    }
}

