/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.util.Log;
import java.net.URL;

public class DocumentChange {
    private RevisionInternal addedRevision;
    private RevisionInternal winningRevision;
    private boolean isConflict;
    private URL sourceUrl;

    @InterfaceAudience.Private
    DocumentChange(RevisionInternal addedRevision, RevisionInternal winningRevision, boolean isConflict, URL sourceUrl) {
        this.addedRevision = addedRevision;
        this.winningRevision = winningRevision;
        this.isConflict = isConflict;
        this.sourceUrl = sourceUrl;
    }

    @InterfaceAudience.Public
    public String getDocumentId() {
        return this.addedRevision.getDocId();
    }

    @InterfaceAudience.Public
    public String getRevisionId() {
        return this.addedRevision.getRevId();
    }

    @InterfaceAudience.Public
    public boolean isCurrentRevision() {
        return this.winningRevision != null && this.addedRevision.getRevId().equals(this.winningRevision.getRevId());
    }

    @InterfaceAudience.Public
    public boolean isConflict() {
        return this.isConflict;
    }

    @InterfaceAudience.Public
    public URL getSourceUrl() {
        return this.sourceUrl;
    }

    @InterfaceAudience.Private
    public RevisionInternal getAddedRevision() {
        return this.addedRevision;
    }

    @InterfaceAudience.Private
    RevisionInternal getWinningRevision() {
        return this.winningRevision;
    }

    @InterfaceAudience.Public
    public String toString() {
        try {
            return String.format("docId: %s rev: %s isConflict: %s sourceUrl: %s", this.getDocumentId(), this.getRevisionId(), this.isConflict(), this.getSourceUrl());
        }
        catch (Exception e) {
            Log.e("CBLite", "Error in DocumentChange.toString()", e);
            return super.toString();
        }
    }
}

