/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.AsyncTask;
import com.couchbase.lite.Attachment;
import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import com.couchbase.lite.BlobStoreWriter;
import com.couchbase.lite.Cache;
import com.couchbase.lite.ChangesOptions;
import com.couchbase.lite.CouchbaseLiteException;
import com.couchbase.lite.Document;
import com.couchbase.lite.DocumentChange;
import com.couchbase.lite.Manager;
import com.couchbase.lite.Mapper;
import com.couchbase.lite.Misc;
import com.couchbase.lite.Query;
import com.couchbase.lite.QueryOptions;
import com.couchbase.lite.QueryRow;
import com.couchbase.lite.ReplicationFilter;
import com.couchbase.lite.ReplicationFilterCompiler;
import com.couchbase.lite.Revision;
import com.couchbase.lite.RevisionList;
import com.couchbase.lite.SavedRevision;
import com.couchbase.lite.Status;
import com.couchbase.lite.TransactionalTask;
import com.couchbase.lite.ValidationContextImpl;
import com.couchbase.lite.Validator;
import com.couchbase.lite.View;
import com.couchbase.lite.internal.AttachmentInternal;
import com.couchbase.lite.internal.Body;
import com.couchbase.lite.internal.InterfaceAudience;
import com.couchbase.lite.internal.RevisionInternal;
import com.couchbase.lite.replicator.Puller;
import com.couchbase.lite.replicator.Pusher;
import com.couchbase.lite.replicator.Replication;
import com.couchbase.lite.storage.ContentValues;
import com.couchbase.lite.storage.Cursor;
import com.couchbase.lite.storage.SQLException;
import com.couchbase.lite.storage.SQLiteStorageEngine;
import com.couchbase.lite.storage.SQLiteStorageEngineFactory;
import com.couchbase.lite.support.Base64;
import com.couchbase.lite.support.FileDirUtils;
import com.couchbase.lite.support.HttpClientFactory;
import com.couchbase.lite.support.PersistentCookieStore;
import com.couchbase.lite.util.CollectionUtils;
import com.couchbase.lite.util.Log;
import com.couchbase.lite.util.StreamUtils;
import com.couchbase.lite.util.TextUtils;
import com.couchbase.lite.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Database {
    private static final int DEFAULT_MAX_REVS = Integer.MAX_VALUE;
    private static ReplicationFilterCompiler filterCompiler;
    private String path;
    private String name;
    private SQLiteStorageEngine database;
    private boolean open = false;
    private int transactionLevel = 0;
    public static final String TAG = "CBLite";
    private Map<String, View> views;
    private Map<String, ReplicationFilter> filters;
    private Map<String, Validator> validations;
    private Map<String, BlobStoreWriter> pendingAttachmentsByDigest;
    private Set<Replication> activeReplicators;
    private Set<Replication> allReplicators;
    private BlobStore attachments;
    private Manager manager;
    private final List<ChangeListener> changeListeners;
    private Cache<String, Document> docCache;
    private List<DocumentChange> changesToNotify;
    private boolean postingChangeNotifications;
    private PersistentCookieStore persistentCookieStore;
    private int maxRevTreeDepth = Integer.MAX_VALUE;
    private long startTime;
    public static int kBigAttachmentLength;
    private static final Set<String> KNOWN_SPECIAL_KEYS;
    public static final String SCHEMA = "CREATE TABLE docs (         doc_id INTEGER PRIMARY KEY,         docid TEXT UNIQUE NOT NULL);     CREATE INDEX docs_docid ON docs(docid);     CREATE TABLE revs (         sequence INTEGER PRIMARY KEY AUTOINCREMENT,         doc_id INTEGER NOT NULL REFERENCES docs(doc_id) ON DELETE CASCADE,         revid TEXT NOT NULL COLLATE REVID,         parent INTEGER REFERENCES revs(sequence) ON DELETE SET NULL,         current BOOLEAN,         deleted BOOLEAN DEFAULT 0,         json BLOB);     CREATE INDEX revs_by_id ON revs(revid, doc_id);     CREATE INDEX revs_current ON revs(doc_id, current);     CREATE INDEX revs_parent ON revs(parent);     CREATE TABLE localdocs (         docid TEXT UNIQUE NOT NULL,         revid TEXT NOT NULL COLLATE REVID,         json BLOB);     CREATE INDEX localdocs_by_docid ON localdocs(docid);     CREATE TABLE views (         view_id INTEGER PRIMARY KEY,         name TEXT UNIQUE NOT NULL,        version TEXT,         lastsequence INTEGER DEFAULT 0);     CREATE INDEX views_by_name ON views(name);     CREATE TABLE maps (         view_id INTEGER NOT NULL REFERENCES views(view_id) ON DELETE CASCADE,         sequence INTEGER NOT NULL REFERENCES revs(sequence) ON DELETE CASCADE,         key TEXT NOT NULL COLLATE JSON,         value TEXT);     CREATE INDEX maps_keys on maps(view_id, key COLLATE JSON);     CREATE TABLE attachments (         sequence INTEGER NOT NULL REFERENCES revs(sequence) ON DELETE CASCADE,         filename TEXT NOT NULL,         key BLOB NOT NULL,         type TEXT,         length INTEGER NOT NULL,         revpos INTEGER DEFAULT 0);     CREATE INDEX attachments_by_sequence on attachments(sequence, filename);     CREATE TABLE replicators (         remote TEXT NOT NULL,         push BOOLEAN,         last_sequence TEXT,         UNIQUE (remote, push));     PRAGMA user_version = 3";

    @InterfaceAudience.Public
    public static ReplicationFilterCompiler getFilterCompiler() {
        return filterCompiler;
    }

    @InterfaceAudience.Public
    public static void setFilterCompiler(ReplicationFilterCompiler filterCompiler) {
        Database.filterCompiler = filterCompiler;
    }

    @InterfaceAudience.Private
    public Database(String path, Manager manager) {
        assert (new File(path).isAbsolute());
        this.path = path;
        this.name = FileDirUtils.getDatabaseNameFromPath(path);
        this.manager = manager;
        this.changeListeners = new CopyOnWriteArrayList<ChangeListener>();
        this.docCache = new Cache();
        this.startTime = System.currentTimeMillis();
        this.changesToNotify = new ArrayList<DocumentChange>();
        this.activeReplicators = Collections.newSetFromMap(new ConcurrentHashMap());
        this.allReplicators = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @InterfaceAudience.Public
    public String getName() {
        return this.name;
    }

    @InterfaceAudience.Public
    public Manager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public int getDocumentCount() {
        String sql = "SELECT COUNT(DISTINCT doc_id) FROM revs WHERE current=1 AND deleted=0";
        Cursor cursor = null;
        int result = 0;
        try {
            cursor = this.database.rawQuery(sql, null);
            if (cursor.moveToNext()) {
                result = cursor.getInt(0);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting document count", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Public
    public long getLastSequenceNumber() {
        String sql = "SELECT MAX(sequence) FROM revs";
        Cursor cursor = null;
        long result = 0L;
        try {
            cursor = this.database.rawQuery(sql, null);
            if (cursor.moveToNext()) {
                result = cursor.getLong(0);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting last sequence", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Public
    public List<Replication> getAllReplications() {
        ArrayList<Replication> allReplicatorsList = new ArrayList<Replication>();
        if (this.allReplicators != null) {
            allReplicatorsList.addAll(this.allReplicators);
        }
        return allReplicatorsList;
    }

    @InterfaceAudience.Public
    public void compact() throws CouchbaseLiteException {
        try {
            Log.v(TAG, "Pruning old revisions...");
            this.pruneRevsToMaxDepth(0);
            Log.v(TAG, "Deleting JSON of old revisions...");
            ContentValues args = new ContentValues();
            args.put("json", (String)null);
            this.database.update("revs", args, "current=0", null);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error compacting", e);
            throw new CouchbaseLiteException(500);
        }
        Log.v(TAG, "Deleting old attachments...");
        Status result = this.garbageCollectAttachments();
        if (!result.isSuccessful()) {
            throw new CouchbaseLiteException(result);
        }
        Log.v(TAG, "Vacuuming SQLite sqliteDb...");
        try {
            this.database.execSQL("VACUUM");
        }
        catch (SQLException e) {
            Log.e(TAG, "Error vacuuming sqliteDb", e);
            throw new CouchbaseLiteException(500);
        }
    }

    @InterfaceAudience.Public
    public void delete() throws CouchbaseLiteException {
        if (this.open && !this.close()) {
            throw new CouchbaseLiteException("The database was open, and could not be closed", 500);
        }
        this.manager.forgetDatabase(this);
        if (!this.exists()) {
            return;
        }
        File file = new File(this.path);
        File fileJournal = new File(this.path + "-journal");
        boolean deleteStatus = file.delete();
        if (fileJournal.exists()) {
            deleteStatus &= fileJournal.delete();
        }
        File attachmentsFile = new File(this.getAttachmentStorePath());
        boolean deleteAttachmentStatus = FileDirUtils.deleteRecursive(attachmentsFile);
        int lastDotPosition = this.path.lastIndexOf(46);
        if (lastDotPosition > 0) {
            File attachmentsFileUpFolder = new File(this.path.substring(0, lastDotPosition));
            FileDirUtils.deleteRecursive(attachmentsFileUpFolder);
        }
        if (!deleteStatus) {
            throw new CouchbaseLiteException("Was not able to delete the database file", 500);
        }
        if (!deleteAttachmentStatus) {
            throw new CouchbaseLiteException("Was not able to delete the attachments files", 500);
        }
    }

    @InterfaceAudience.Public
    public Document getDocument(String documentId) {
        if (documentId == null || documentId.length() == 0) {
            return null;
        }
        Document doc = this.docCache.get(documentId);
        if (doc == null) {
            doc = new Document(this, documentId);
            if (doc == null) {
                return null;
            }
            this.docCache.put(documentId, doc);
        }
        return doc;
    }

    @InterfaceAudience.Public
    public Document getExistingDocument(String documentId) {
        if (documentId == null || documentId.length() == 0) {
            return null;
        }
        RevisionInternal revisionInternal = this.getDocumentWithIDAndRev(documentId, null, EnumSet.noneOf(TDContentOptions.class));
        if (revisionInternal == null) {
            return null;
        }
        return this.getDocument(documentId);
    }

    @InterfaceAudience.Public
    public Document createDocument() {
        return this.getDocument(Misc.TDCreateUUID());
    }

    @InterfaceAudience.Public
    public Map<String, Object> getExistingLocalDocument(String documentId) {
        RevisionInternal revInt = this.getLocalDocument(Database.makeLocalDocumentId(documentId), null);
        if (revInt == null) {
            return null;
        }
        return revInt.getProperties();
    }

    @InterfaceAudience.Public
    public boolean putLocalDocument(String id, Map<String, Object> properties) throws CouchbaseLiteException {
        RevisionInternal prevRev = this.getLocalDocument(id = Database.makeLocalDocumentId(id), null);
        if (prevRev == null && properties == null) {
            return false;
        }
        boolean deleted = false;
        if (properties == null) {
            deleted = true;
        }
        RevisionInternal rev = new RevisionInternal(id, null, deleted, this);
        if (properties != null) {
            rev.setProperties(properties);
        }
        if (prevRev == null) {
            return this.putLocalRevision(rev, null) != null;
        }
        return this.putLocalRevision(rev, prevRev.getRevId()) != null;
    }

    @InterfaceAudience.Public
    public boolean deleteLocalDocument(String id) throws CouchbaseLiteException {
        RevisionInternal prevRev = this.getLocalDocument(id = Database.makeLocalDocumentId(id), null);
        if (prevRev == null) {
            return false;
        }
        this.deleteLocalDocument(id, prevRev.getRevId());
        return true;
    }

    @InterfaceAudience.Public
    public Query createAllDocumentsQuery() {
        return new Query(this, (View)null);
    }

    @InterfaceAudience.Public
    public View getView(String name) {
        View view = null;
        if (this.views != null) {
            view = this.views.get(name);
        }
        if (view != null) {
            return view;
        }
        return this.registerView(new View(this, name));
    }

    @InterfaceAudience.Public
    public View getExistingView(String name) {
        View view = null;
        if (this.views != null) {
            view = this.views.get(name);
        }
        if (view != null) {
            return view;
        }
        view = new View(this, name);
        if (view.getViewId() == 0) {
            return null;
        }
        return this.registerView(view);
    }

    @InterfaceAudience.Public
    public Validator getValidation(String name) {
        Validator result = null;
        if (this.validations != null) {
            result = this.validations.get(name);
        }
        return result;
    }

    @InterfaceAudience.Public
    public void setValidation(String name, Validator validator) {
        if (this.validations == null) {
            this.validations = new HashMap<String, Validator>();
        }
        if (validator != null) {
            this.validations.put(name, validator);
        } else {
            this.validations.remove(name);
        }
    }

    @InterfaceAudience.Public
    public ReplicationFilter getFilter(String filterName) {
        ReplicationFilter result = null;
        if (this.filters != null) {
            result = this.filters.get(filterName);
        }
        if (result == null) {
            ReplicationFilterCompiler filterCompiler = Database.getFilterCompiler();
            if (filterCompiler == null) {
                return null;
            }
            ArrayList<String> outLanguageList = new ArrayList<String>();
            String sourceCode = this.getDesignDocFunction(filterName, "filters", outLanguageList);
            if (sourceCode == null) {
                return null;
            }
            String language = (String)outLanguageList.get(0);
            ReplicationFilter filter = filterCompiler.compileFilterFunction(sourceCode, language);
            if (filter == null) {
                Log.w(TAG, "Filter %s failed to compile", filterName);
                return null;
            }
            this.setFilter(filterName, filter);
            return filter;
        }
        return result;
    }

    @InterfaceAudience.Public
    public void setFilter(String filterName, ReplicationFilter filter) {
        if (this.filters == null) {
            this.filters = new HashMap<String, ReplicationFilter>();
        }
        if (filter != null) {
            this.filters.put(filterName, filter);
        } else {
            this.filters.remove(filterName);
        }
    }

    @InterfaceAudience.Public
    public boolean runInTransaction(TransactionalTask transactionalTask) {
        boolean shouldCommit = true;
        this.beginTransaction();
        try {
            shouldCommit = transactionalTask.run();
        }
        catch (Exception e) {
            shouldCommit = false;
            Log.e(TAG, e.toString(), e);
            throw new RuntimeException(e);
        }
        finally {
            this.endTransaction(shouldCommit);
        }
        return shouldCommit;
    }

    @InterfaceAudience.Public
    public Future runAsync(final AsyncTask asyncTask) {
        return this.getManager().runAsync(new Runnable(){

            @Override
            public void run() {
                asyncTask.run(Database.this);
            }
        });
    }

    @InterfaceAudience.Public
    public Replication createPushReplication(URL remote) {
        boolean continuous = false;
        return new Pusher(this, remote, false, this.manager.getWorkExecutor());
    }

    @InterfaceAudience.Public
    public Replication createPullReplication(URL remote) {
        boolean continuous = false;
        return new Puller(this, remote, false, this.manager.getWorkExecutor());
    }

    @InterfaceAudience.Public
    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @InterfaceAudience.Public
    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    @InterfaceAudience.Public
    public String toString() {
        return this.getClass().getName() + "[" + this.path + "]";
    }

    @InterfaceAudience.Public
    public int getMaxRevTreeDepth() {
        return this.maxRevTreeDepth;
    }

    @InterfaceAudience.Public
    public void setMaxRevTreeDepth(int maxRevTreeDepth) {
        this.maxRevTreeDepth = maxRevTreeDepth;
    }

    @InterfaceAudience.Private
    protected Document getCachedDocument(String documentID) {
        return this.docCache.get(documentID);
    }

    @InterfaceAudience.Private
    protected void clearDocumentCache() {
        this.docCache.clear();
    }

    @InterfaceAudience.Private
    public List<Replication> getActiveReplications() {
        ArrayList<Replication> activeReplicatorsList = new ArrayList<Replication>();
        if (this.activeReplicators != null) {
            activeReplicatorsList.addAll(this.activeReplicators);
        }
        return activeReplicatorsList;
    }

    @InterfaceAudience.Private
    protected void removeDocumentFromCache(Document document) {
        this.docCache.remove(document.getId());
    }

    @InterfaceAudience.Private
    public boolean exists() {
        return new File(this.path).exists();
    }

    @InterfaceAudience.Private
    public String getAttachmentStorePath() {
        String attachmentStorePath = this.path;
        int lastDotPosition = attachmentStorePath.lastIndexOf(46);
        if (lastDotPosition > 0) {
            attachmentStorePath = attachmentStorePath.substring(0, lastDotPosition);
        }
        attachmentStorePath = attachmentStorePath + File.separator + "attachments";
        return attachmentStorePath;
    }

    @InterfaceAudience.Private
    public static Database createEmptyDBAtPath(String path, Manager manager) {
        if (!FileDirUtils.removeItemIfExists(path)) {
            return null;
        }
        Database result = new Database(path, manager);
        File af = new File(result.getAttachmentStorePath());
        if (!FileDirUtils.deleteRecursive(af)) {
            return null;
        }
        if (!result.open()) {
            return null;
        }
        return result;
    }

    @InterfaceAudience.Private
    public boolean initialize(String statements) {
        try {
            for (String statement : statements.split(";")) {
                this.database.execSQL(statement);
            }
        }
        catch (SQLException e) {
            this.close();
            return false;
        }
        return true;
    }

    @InterfaceAudience.Private
    public synchronized boolean open() {
        String upgradeSql;
        if (this.open) {
            return true;
        }
        this.database = SQLiteStorageEngineFactory.createStorageEngine();
        if (this.database == null || !this.database.open(this.path)) {
            String msg = "Unable to create a storage engine, fatal error";
            Log.e(TAG, msg);
            throw new IllegalStateException(msg);
        }
        if (!this.initialize("PRAGMA foreign_keys = ON;")) {
            Log.e(TAG, "Error turning on foreign keys");
            return false;
        }
        int dbVersion = this.database.getVersion();
        if (dbVersion >= 100) {
            Log.e(TAG, "Database: Database version (%d) is newer than I know how to work with", dbVersion);
            this.database.close();
            return false;
        }
        if (dbVersion < 1) {
            if (!this.initialize(SCHEMA)) {
                this.database.close();
                return false;
            }
            dbVersion = 3;
        }
        if (dbVersion < 2) {
            upgradeSql = "ALTER TABLE attachments ADD COLUMN revpos INTEGER DEFAULT 0; PRAGMA user_version = 2";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 2;
        }
        if (dbVersion < 3) {
            upgradeSql = "CREATE TABLE localdocs ( docid TEXT UNIQUE NOT NULL, revid TEXT NOT NULL, json BLOB); CREATE INDEX localdocs_by_docid ON localdocs(docid); PRAGMA user_version = 3";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 3;
        }
        if (dbVersion < 4) {
            upgradeSql = "CREATE TABLE info ( key TEXT PRIMARY KEY, value TEXT); INSERT INTO INFO (key, value) VALUES ('privateUUID', '" + Misc.TDCreateUUID() + "'); " + "INSERT INTO INFO (key, value) VALUES ('publicUUID',  '" + Misc.TDCreateUUID() + "'); " + "PRAGMA user_version = 4";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 4;
        }
        if (dbVersion < 5) {
            upgradeSql = "ALTER TABLE attachments ADD COLUMN encoding INTEGER DEFAULT 0; ALTER TABLE attachments ADD COLUMN encoded_length INTEGER; PRAGMA user_version = 5";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 5;
        }
        if (dbVersion < 6) {
            upgradeSql = "PRAGMA user_version = 6";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 6;
        }
        if (dbVersion < 7) {
            upgradeSql = "PRAGMA user_version = 7";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 7;
        }
        if (dbVersion < 9) {
            upgradeSql = "PRAGMA user_version = 9";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 9;
        }
        if (dbVersion < 10) {
            upgradeSql = "ALTER TABLE revs ADD COLUMN no_attachments BOOLEAN; PRAGMA user_version = 10";
            if (!this.initialize(upgradeSql)) {
                this.database.close();
                return false;
            }
            dbVersion = 10;
        }
        if (dbVersion < 11 && !this.initialize(upgradeSql = "CREATE INDEX revs_cur_deleted ON revs(current,deleted); PRAGMA user_version = 11")) {
            this.database.close();
            return false;
        }
        try {
            this.attachments = new BlobStore(this.getAttachmentStorePath());
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Could not initialize attachment store", e);
            this.database.close();
            return false;
        }
        this.open = true;
        return true;
    }

    @InterfaceAudience.Private
    public boolean close() {
        if (!this.open) {
            return false;
        }
        if (this.views != null) {
            for (View view : this.views.values()) {
                view.databaseClosing();
            }
        }
        this.views = null;
        if (this.activeReplicators != null) {
            for (Replication replicator : this.activeReplicators) {
                replicator.databaseClosing();
            }
            this.activeReplicators = null;
        }
        this.allReplicators = null;
        if (this.database != null && this.database.isOpen()) {
            this.database.close();
        }
        this.open = false;
        this.transactionLevel = 0;
        return true;
    }

    @InterfaceAudience.Private
    public String getPath() {
        return this.path;
    }

    @InterfaceAudience.Private
    SQLiteStorageEngine getDatabase() {
        return this.database;
    }

    @InterfaceAudience.Private
    public BlobStore getAttachments() {
        return this.attachments;
    }

    @InterfaceAudience.Private
    public BlobStoreWriter getAttachmentWriter() {
        return new BlobStoreWriter(this.getAttachments());
    }

    @InterfaceAudience.Private
    public long totalDataSize() {
        File f = new File(this.path);
        long size = f.length() + this.attachments.totalDataSize();
        return size;
    }

    @InterfaceAudience.Private
    public boolean beginTransaction() {
        try {
            this.database.beginTransaction();
            ++this.transactionLevel;
            Log.i(TAG, "%s Begin transaction (level %d)", Thread.currentThread().getName(), this.transactionLevel);
        }
        catch (SQLException e) {
            Log.e(TAG, Thread.currentThread().getName() + " Error calling beginTransaction()", e);
            return false;
        }
        return true;
    }

    @InterfaceAudience.Private
    public boolean endTransaction(boolean commit) {
        assert (this.transactionLevel > 0);
        if (commit) {
            Log.i(TAG, "%s Committing transaction (level %d)", Thread.currentThread().getName(), this.transactionLevel);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
        } else {
            Log.i(TAG, "%s CANCEL transaction (level %d)", Thread.currentThread().getName(), this.transactionLevel);
            try {
                this.database.endTransaction();
            }
            catch (SQLException e) {
                Log.e(TAG, Thread.currentThread().getName() + " Error calling endTransaction()", e);
                return false;
            }
        }
        --this.transactionLevel;
        this.postChangeNotifications();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public String privateUUID() {
        String result = null;
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery("SELECT value FROM info WHERE key='privateUUID'", null);
            if (cursor.moveToNext()) {
                result = cursor.getString(0);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error querying privateUUID", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public String publicUUID() {
        String result = null;
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery("SELECT value FROM info WHERE key='publicUUID'", null);
            if (cursor.moveToNext()) {
                result = cursor.getString(0);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error querying privateUUID", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public byte[] appendDictToJSON(byte[] json, Map<String, Object> dict) {
        if (dict.size() == 0) {
            return json;
        }
        byte[] extraJSON = null;
        try {
            extraJSON = Manager.getObjectMapper().writeValueAsBytes(dict);
        }
        catch (Exception e) {
            Log.e(TAG, "Error convert extra JSON to bytes", e);
            return null;
        }
        int jsonLength = json.length;
        int extraLength = extraJSON.length;
        if (jsonLength == 2) {
            return extraJSON;
        }
        byte[] newJson = new byte[jsonLength + extraLength - 1];
        System.arraycopy(json, 0, newJson, 0, jsonLength - 1);
        newJson[jsonLength - 1] = 44;
        System.arraycopy(extraJSON, 1, newJson, jsonLength, extraLength - 1);
        return newJson;
    }

    @InterfaceAudience.Private
    public Map<String, Object> extraPropertiesForRevision(RevisionInternal rev, EnumSet<TDContentOptions> contentOptions) {
        RevisionList revs;
        String docId = rev.getDocId();
        String revId = rev.getRevId();
        long sequenceNumber = rev.getSequence();
        assert (revId != null);
        assert (sequenceNumber > 0L);
        Map<String, Object> attachmentsDict = null;
        if (!contentOptions.contains((Object)TDContentOptions.TDNoAttachments)) {
            attachmentsDict = this.getAttachmentsDictForSequenceWithContent(sequenceNumber, contentOptions);
        }
        Long localSeq = null;
        if (contentOptions.contains((Object)TDContentOptions.TDIncludeLocalSeq)) {
            localSeq = sequenceNumber;
        }
        Map<String, Object> revHistory = null;
        if (contentOptions.contains((Object)TDContentOptions.TDIncludeRevs)) {
            revHistory = this.getRevisionHistoryDict(rev);
        }
        ArrayList revsInfo = null;
        if (contentOptions.contains((Object)TDContentOptions.TDIncludeRevsInfo)) {
            revsInfo = new ArrayList();
            List<RevisionInternal> revHistoryFull = this.getRevisionHistory(rev);
            for (RevisionInternal historicalRev : revHistoryFull) {
                HashMap<String, String> revHistoryItem = new HashMap<String, String>();
                String status = "available";
                if (historicalRev.isDeleted()) {
                    status = "deleted";
                }
                if (historicalRev.isMissing()) {
                    status = "missing";
                }
                revHistoryItem.put("rev", historicalRev.getRevId());
                revHistoryItem.put("status", status);
                revsInfo.add(revHistoryItem);
            }
        }
        ArrayList<String> conflicts = null;
        if (contentOptions.contains((Object)TDContentOptions.TDIncludeConflicts) && (revs = this.getAllRevisionsOfDocumentID(docId, true)).size() > 1) {
            conflicts = new ArrayList<String>();
            for (RevisionInternal aRev : revs) {
                if (aRev.equals(rev) || aRev.isDeleted()) continue;
                conflicts.add(aRev.getRevId());
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("_id", docId);
        result.put("_rev", revId);
        if (rev.isDeleted()) {
            result.put("_deleted", true);
        }
        if (attachmentsDict != null) {
            result.put("_attachments", attachmentsDict);
        }
        if (localSeq != null) {
            result.put("_local_seq", localSeq);
        }
        if (revHistory != null) {
            result.put("_revisions", revHistory);
        }
        if (revsInfo != null) {
            result.put("_revs_info", revsInfo);
        }
        if (conflicts != null) {
            result.put("_conflicts", conflicts);
        }
        return result;
    }

    @InterfaceAudience.Private
    public void expandStoredJSONIntoRevisionWithAttachments(byte[] json, RevisionInternal rev, EnumSet<TDContentOptions> contentOptions) {
        Map<String, Object> extra = this.extraPropertiesForRevision(rev, contentOptions);
        if (json != null && json.length > 0) {
            rev.setJson(this.appendDictToJSON(json, extra));
        } else {
            rev.setProperties(extra);
            if (json == null) {
                rev.setMissing(true);
            }
        }
    }

    @InterfaceAudience.Private
    public Map<String, Object> documentPropertiesFromJSON(byte[] json, String docId, String revId, boolean deleted, long sequence, EnumSet<TDContentOptions> contentOptions) {
        RevisionInternal rev = new RevisionInternal(docId, revId, deleted, this);
        rev.setSequence(sequence);
        Map<String, Object> extra = this.extraPropertiesForRevision(rev, contentOptions);
        if (json == null) {
            return extra;
        }
        Map docProperties = null;
        try {
            docProperties = (Map)Manager.getObjectMapper().readValue(json, Map.class);
            docProperties.putAll(extra);
            return docProperties;
        }
        catch (Exception e) {
            Log.e(TAG, "Error serializing properties to JSON", e);
            return docProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public RevisionInternal getDocumentWithIDAndRev(String id, String rev, EnumSet<TDContentOptions> contentOptions) {
        RevisionInternal result = null;
        Cursor cursor = null;
        try {
            String[] args;
            cursor = null;
            String cols = "revid, deleted, sequence, no_attachments";
            if (!contentOptions.contains((Object)TDContentOptions.TDNoBody)) {
                cols = cols + ", json";
            }
            if (rev != null) {
                String sql = "SELECT " + cols + " FROM revs, docs WHERE docs.docid=? AND revs.doc_id=docs.doc_id AND revid=? LIMIT 1";
                args = new String[]{id, rev};
                cursor = this.database.rawQuery(sql, args);
            } else {
                String sql = "SELECT " + cols + " FROM revs, docs WHERE docs.docid=? AND revs.doc_id=docs.doc_id and current=1 and deleted=0 ORDER BY revid DESC LIMIT 1";
                args = new String[]{id};
                cursor = this.database.rawQuery(sql, args);
            }
            if (cursor.moveToNext()) {
                if (rev == null) {
                    rev = cursor.getString(0);
                }
                boolean deleted = cursor.getInt(1) > 0;
                result = new RevisionInternal(id, rev, deleted, this);
                result.setSequence(cursor.getLong(2));
                if (!contentOptions.equals(EnumSet.of(TDContentOptions.TDNoBody))) {
                    byte[] json = null;
                    if (!contentOptions.contains((Object)TDContentOptions.TDNoBody)) {
                        json = cursor.getBlob(4);
                    }
                    if (cursor.getInt(3) > 0) {
                        contentOptions.add(TDContentOptions.TDNoAttachments);
                    }
                    this.expandStoredJSONIntoRevisionWithAttachments(json, result, contentOptions);
                }
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting document with id and rev", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public boolean existsDocumentWithIDAndRev(String docId, String revId) {
        return this.getDocumentWithIDAndRev(docId, revId, EnumSet.of(TDContentOptions.TDNoBody)) != null;
    }

    @InterfaceAudience.Private
    public RevisionInternal loadRevisionBody(RevisionInternal rev, EnumSet<TDContentOptions> contentOptions) throws CouchbaseLiteException {
        if (rev.getBody() != null && contentOptions == EnumSet.noneOf(TDContentOptions.class) && rev.getSequence() != 0L) {
            return rev;
        }
        if (rev.getDocId() == null || rev.getRevId() == null) {
            Log.e(TAG, "Error loading revision body");
            throw new CouchbaseLiteException(412);
        }
        Cursor cursor = null;
        Status result = new Status(404);
        try {
            String sql = "SELECT sequence, json FROM revs, docs WHERE revid=? AND docs.docid=? AND revs.doc_id=docs.doc_id LIMIT 1";
            String[] args = new String[]{rev.getRevId(), rev.getDocId()};
            cursor = this.database.rawQuery(sql, args);
            if (cursor.moveToNext()) {
                result.setCode(200);
                rev.setSequence(cursor.getLong(0));
                this.expandStoredJSONIntoRevisionWithAttachments(cursor.getBlob(1), rev, contentOptions);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error loading revision body", e);
            throw new CouchbaseLiteException(500);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (result.getCode() == 404) {
            throw new CouchbaseLiteException(result);
        }
        return rev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public long getDocNumericID(String docId) {
        Cursor cursor = null;
        String[] args = new String[]{docId};
        long result = -1L;
        try {
            cursor = this.database.rawQuery("SELECT doc_id FROM docs WHERE docid=?", args);
            result = cursor.moveToNext() ? cursor.getLong(0) : 0L;
        }
        catch (Exception e) {
            Log.e(TAG, "Error getting doc numeric id", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public RevisionList getAllRevisionsOfDocumentID(String docId, long docNumericID, boolean onlyCurrent) {
        RevisionList result;
        String sql = null;
        sql = onlyCurrent ? "SELECT sequence, revid, deleted FROM revs WHERE doc_id=? AND current ORDER BY sequence DESC" : "SELECT sequence, revid, deleted FROM revs WHERE doc_id=? ORDER BY sequence DESC";
        String[] args = new String[]{Long.toString(docNumericID)};
        Cursor cursor = null;
        cursor = this.database.rawQuery(sql, args);
        try {
            cursor.moveToNext();
            result = new RevisionList();
            while (!cursor.isAfterLast()) {
                RevisionInternal rev = new RevisionInternal(docId, cursor.getString(1), cursor.getInt(2) > 0, this);
                rev.setSequence(cursor.getLong(0));
                result.add(rev);
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting all revisions of document", e);
            RevisionList revisionList = null;
            return revisionList;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public RevisionList getAllRevisionsOfDocumentID(String docId, boolean onlyCurrent) {
        long docNumericId = this.getDocNumericID(docId);
        if (docNumericId < 0L) {
            return null;
        }
        if (docNumericId == 0L) {
            return new RevisionList();
        }
        return this.getAllRevisionsOfDocumentID(docId, docNumericId, onlyCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public List<String> getConflictingRevisionIDsOfDocID(String docID) {
        long docIdNumeric = this.getDocNumericID(docID);
        if (docIdNumeric < 0L) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Cursor cursor = null;
        try {
            String[] args = new String[]{Long.toString(docIdNumeric)};
            cursor = this.database.rawQuery("SELECT revid FROM revs WHERE doc_id=? AND current ORDER BY revid DESC OFFSET 1", args);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                result.add(cursor.getString(0));
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting all revisions of document", e);
            List<String> list = null;
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public List<String> getPossibleAncestorRevisionIDs(RevisionInternal rev, int limit, AtomicBoolean hasAttachment) {
        ArrayList<String> matchingRevs = new ArrayList<String>();
        int generation = rev.getGeneration();
        if (generation <= 1) {
            return null;
        }
        long docNumericID = this.getDocNumericID(rev.getDocId());
        if (docNumericID <= 0L) {
            return null;
        }
        int sqlLimit = limit > 0 ? limit : -1;
        String sql = "SELECT revid, sequence FROM revs WHERE doc_id=? and revid < ? and deleted=0 and json not null ORDER BY sequence DESC LIMIT ?";
        String[] args = new String[]{Long.toString(docNumericID), generation + "-", Integer.toString(sqlLimit)};
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery(sql, args);
            cursor.moveToNext();
            if (!cursor.isAfterLast()) {
                if (matchingRevs.size() == 0) {
                    hasAttachment.set(this.sequenceHasAttachments(cursor.getLong(1)));
                }
                matchingRevs.add(cursor.getString(0));
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting all revisions of document", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return matchingRevs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public String findCommonAncestorOf(RevisionInternal rev, List<String> revIDs) {
        String result = null;
        if (revIDs.size() == 0) {
            return null;
        }
        String docId = rev.getDocId();
        long docNumericID = this.getDocNumericID(docId);
        if (docNumericID <= 0L) {
            return null;
        }
        String quotedRevIds = Database.joinQuoted(revIDs);
        String sql = "SELECT revid FROM revs WHERE doc_id=? and revid in (" + quotedRevIds + ") and revid <= ? " + "ORDER BY revid DESC LIMIT 1";
        String[] args = new String[]{Long.toString(docNumericID)};
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery(sql, args);
            cursor.moveToNext();
            if (!cursor.isAfterLast()) {
                result = cursor.getString(0);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting all revisions of document", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public List<RevisionInternal> getRevisionHistory(RevisionInternal rev) {
        ArrayList<RevisionInternal> result;
        String docId = rev.getDocId();
        String revId = rev.getRevId();
        assert (docId != null && revId != null);
        long docNumericId = this.getDocNumericID(docId);
        if (docNumericId < 0L) {
            return null;
        }
        if (docNumericId == 0L) {
            return new ArrayList<RevisionInternal>();
        }
        String sql = "SELECT sequence, parent, revid, deleted, json isnull FROM revs WHERE doc_id=? ORDER BY sequence DESC";
        String[] args = new String[]{Long.toString(docNumericId)};
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery(sql, args);
            cursor.moveToNext();
            long lastSequence = 0L;
            result = new ArrayList<RevisionInternal>();
            while (!cursor.isAfterLast()) {
                long sequence = cursor.getLong(0);
                boolean matches = false;
                if (lastSequence == 0L) {
                    matches = revId.equals(cursor.getString(2));
                } else {
                    boolean bl = matches = sequence == lastSequence;
                }
                if (matches) {
                    revId = cursor.getString(2);
                    boolean deleted = cursor.getInt(3) > 0;
                    boolean missing = cursor.getInt(4) > 0;
                    RevisionInternal aRev = new RevisionInternal(docId, revId, deleted, this);
                    aRev.setMissing(missing);
                    aRev.setSequence(cursor.getLong(0));
                    result.add(aRev);
                    lastSequence = cursor.getLong(1);
                    if (lastSequence == 0L) {
                        break;
                    }
                }
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting revision history", e);
            List<RevisionInternal> list = null;
            return list;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public static int parseRevIDNumber(String rev) {
        int result = -1;
        int dashPos = rev.indexOf("-");
        if (dashPos >= 0) {
            try {
                result = Integer.parseInt(rev.substring(0, dashPos));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public static String parseRevIDSuffix(String rev) {
        String result = null;
        int dashPos = rev.indexOf("-");
        if (dashPos >= 0) {
            result = rev.substring(dashPos + 1);
        }
        return result;
    }

    @InterfaceAudience.Private
    public static Map<String, Object> makeRevisionHistoryDict(List<RevisionInternal> history) {
        if (history == null) {
            return null;
        }
        ArrayList<String> suffixes = new ArrayList<String>();
        int start = -1;
        int lastRevNo = -1;
        for (RevisionInternal rev : history) {
            int revNo = Database.parseRevIDNumber(rev.getRevId());
            String suffix = Database.parseRevIDSuffix(rev.getRevId());
            if (revNo > 0 && suffix.length() > 0) {
                if (start < 0) {
                    start = revNo;
                } else if (revNo != lastRevNo - 1) {
                    start = -1;
                    break;
                }
                lastRevNo = revNo;
                suffixes.add(suffix);
                continue;
            }
            start = -1;
            break;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (start == -1) {
            suffixes = new ArrayList();
            for (RevisionInternal rev : history) {
                suffixes.add(rev.getRevId());
            }
        } else {
            result.put("start", start);
        }
        result.put("ids", suffixes);
        return result;
    }

    @InterfaceAudience.Private
    public Map<String, Object> getRevisionHistoryDict(RevisionInternal rev) {
        return Database.makeRevisionHistoryDict(this.getRevisionHistory(rev));
    }

    @InterfaceAudience.Private
    public Map<String, Object> getRevisionHistoryDictStartingFromAnyAncestor(RevisionInternal rev, List<String> ancestorRevIDs) {
        List<RevisionInternal> history = this.getRevisionHistory(rev);
        if (ancestorRevIDs != null && ancestorRevIDs.size() > 0) {
            int n = history.size();
            for (int i = 0; i < n; ++i) {
                if (!ancestorRevIDs.contains(history.get(i).getRevId())) continue;
                history = history.subList(0, i + 1);
                break;
            }
        }
        return Database.makeRevisionHistoryDict(history);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public RevisionList changesSince(long lastSeq, ChangesOptions options, ReplicationFilter filter) {
        if (options == null) {
            options = new ChangesOptions();
        }
        boolean includeDocs = options.isIncludeDocs() || filter != null;
        String additionalSelectColumns = "";
        if (includeDocs) {
            additionalSelectColumns = ", json";
        }
        String sql = "SELECT sequence, revs.doc_id, docid, revid, deleted" + additionalSelectColumns + " FROM revs, docs " + "WHERE sequence > ? AND current=1 " + "AND revs.doc_id = docs.doc_id " + "ORDER BY revs.doc_id, revid DESC";
        String[] args = new String[]{Long.toString(lastSeq)};
        Cursor cursor = null;
        RevisionList changes = null;
        try {
            cursor = this.database.rawQuery(sql, args);
            cursor.moveToNext();
            changes = new RevisionList();
            long lastDocId = 0L;
            while (!cursor.isAfterLast()) {
                Map<String, Object> paramsFixMe;
                if (!options.isIncludeConflicts()) {
                    long docNumericId = cursor.getLong(1);
                    if (docNumericId == lastDocId) {
                        cursor.moveToNext();
                        continue;
                    }
                    lastDocId = docNumericId;
                }
                RevisionInternal rev = new RevisionInternal(cursor.getString(2), cursor.getString(3), cursor.getInt(4) > 0, this);
                rev.setSequence(cursor.getLong(0));
                if (includeDocs) {
                    this.expandStoredJSONIntoRevisionWithAttachments(cursor.getBlob(5), rev, options.getContentOptions());
                }
                if (this.runFilter(filter, paramsFixMe = null, rev)) {
                    changes.add(rev);
                }
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error looking for changes", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (options.isSortBySequence()) {
            changes.sortBySequence();
        }
        changes.limit(options.getLimit());
        return changes;
    }

    @InterfaceAudience.Private
    public boolean runFilter(ReplicationFilter filter, Map<String, Object> paramsIgnored, RevisionInternal rev) {
        if (filter == null) {
            return true;
        }
        SavedRevision publicRev = new SavedRevision(this, rev);
        return filter.filter(publicRev, null);
    }

    @InterfaceAudience.Private
    public String getDesignDocFunction(String fnName, String key, List<String> outLanguageList) {
        String[] path = fnName.split("/");
        if (path.length != 2) {
            return null;
        }
        String docId = String.format("_design/%s", path[0]);
        RevisionInternal rev = this.getDocumentWithIDAndRev(docId, null, EnumSet.noneOf(TDContentOptions.class));
        if (rev == null) {
            return null;
        }
        String outLanguage = (String)rev.getPropertyForKey("language");
        if (outLanguage != null) {
            outLanguageList.add(outLanguage);
        } else {
            outLanguageList.add("javascript");
        }
        Map container = (Map)rev.getPropertyForKey(key);
        return (String)container.get(path[1]);
    }

    @InterfaceAudience.Private
    public View registerView(View view) {
        if (view == null) {
            return null;
        }
        if (this.views == null) {
            this.views = new HashMap<String, View>();
        }
        this.views.put(view.getName(), view);
        return view;
    }

    @InterfaceAudience.Private
    public List<QueryRow> queryViewNamed(String viewName, QueryOptions options, List<Long> outLastSequence) throws CouchbaseLiteException {
        long before = System.currentTimeMillis();
        long lastSequence = 0L;
        List<QueryRow> rows = null;
        if (viewName != null && viewName.length() > 0) {
            final View view = this.getView(viewName);
            if (view == null) {
                throw new CouchbaseLiteException(new Status(404));
            }
            lastSequence = view.getLastSequenceIndexed();
            if (options.getStale() == Query.IndexUpdateMode.BEFORE || lastSequence <= 0L) {
                view.updateIndex();
                lastSequence = view.getLastSequenceIndexed();
            } else if (options.getStale() == Query.IndexUpdateMode.AFTER && lastSequence < this.getLastSequenceNumber()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            view.updateIndex();
                        }
                        catch (CouchbaseLiteException e) {
                            Log.e(Database.TAG, "Error updating view index on background thread", e);
                        }
                    }
                }).start();
            }
            rows = view.queryWithOptions(options);
        } else {
            Map<String, Object> allDocsResult = this.getAllDocs(options);
            rows = (List<QueryRow>)allDocsResult.get("rows");
            lastSequence = this.getLastSequenceNumber();
        }
        outLastSequence.add(lastSequence);
        long delta = System.currentTimeMillis() - before;
        Log.d(TAG, "Query view %s completed in %d milliseconds", viewName, delta);
        return rows;
    }

    @InterfaceAudience.Private
    View makeAnonymousView() {
        int i = 0;
        String name;
        View existing;
        while ((existing = this.getExistingView(name = String.format("anon%d", i))) != null) {
            ++i;
        }
        return this.getView(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public List<View> getAllViews() {
        Cursor cursor = null;
        ArrayList<View> result = null;
        try {
            cursor = this.database.rawQuery("SELECT name FROM views", null);
            cursor.moveToNext();
            result = new ArrayList<View>();
            while (!cursor.isAfterLast()) {
                result.add(this.getView(cursor.getString(0)));
                cursor.moveToNext();
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Error getting all views", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public Status deleteViewNamed(String name) {
        Status result = new Status(500);
        try {
            String[] whereArgs = new String[]{name};
            int rowsAffected = this.database.delete("views", "name=?", whereArgs);
            if (rowsAffected > 0) {
                result.setCode(200);
            } else {
                result.setCode(404);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error deleting view", e);
        }
        return result;
    }

    @InterfaceAudience.Private
    public int getDeletedColumnIndex(QueryOptions options) {
        if (options.isIncludeDocs()) {
            return 5;
        }
        return 4;
    }

    @InterfaceAudience.Private
    public Map<String, Object> getAllDocs(QueryOptions options) throws CouchbaseLiteException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<QueryRow> rows = new ArrayList<QueryRow>();
        if (options == null) {
            options = new QueryOptions();
        }
        boolean includeDeletedDocs = options.getAllDocsMode() == Query.AllDocsMode.INCLUDE_DELETED;
        long updateSeq = 0L;
        if (options.isUpdateSeq()) {
            updateSeq = this.getLastSequenceNumber();
        }
        StringBuffer sql = new StringBuffer("SELECT revs.doc_id, docid, revid, sequence");
        if (options.isIncludeDocs()) {
            sql.append(", json");
        }
        if (includeDeletedDocs) {
            sql.append(", deleted");
        }
        sql.append(" FROM revs, docs WHERE");
        if (options.getKeys() != null) {
            if (options.getKeys().size() == 0) {
                return result;
            }
            String commaSeperatedIds = Database.joinQuotedObjects(options.getKeys());
            sql.append(String.format(" revs.doc_id IN (SELECT doc_id FROM docs WHERE docid IN (%s)) AND", commaSeperatedIds));
        }
        sql.append(" docs.doc_id = revs.doc_id AND current=1");
        if (!includeDeletedDocs) {
            sql.append(" AND deleted=0");
        }
        ArrayList<String> args = new ArrayList<String>();
        Object minKey = options.getStartKey();
        Object maxKey = options.getEndKey();
        boolean inclusiveMin = true;
        boolean inclusiveMax = options.isInclusiveEnd();
        if (options.isDescending()) {
            minKey = maxKey;
            maxKey = options.getStartKey();
            inclusiveMin = inclusiveMax;
            inclusiveMax = true;
        }
        if (minKey != null) {
            assert (minKey instanceof String);
            sql.append(inclusiveMin ? " AND docid >= ?" : " AND docid > ?");
            args.add((String)minKey);
        }
        if (maxKey != null) {
            assert (maxKey instanceof String);
            sql.append(inclusiveMax ? " AND docid <= ?" : " AND docid < ?");
            args.add((String)maxKey);
        }
        sql.append(String.format(" ORDER BY docid %s, %s revid DESC LIMIT ? OFFSET ?", options.isDescending() ? "DESC" : "ASC", includeDeletedDocs ? "deleted ASC," : ""));
        args.add(Integer.toString(options.getLimit()));
        args.add(Integer.toString(options.getSkip()));
        Cursor cursor = null;
        HashMap<String, QueryRow> docs = new HashMap<String, QueryRow>();
        try {
            String docId;
            cursor = this.database.rawQuery(sql.toString(), args.toArray(new String[args.size()]));
            boolean keepGoing = cursor.moveToNext();
            while (keepGoing) {
                long docNumericID = cursor.getLong(0);
                docId = cursor.getString(1);
                String revId = cursor.getString(2);
                long sequenceNumber = cursor.getLong(3);
                boolean deleted = includeDeletedDocs && cursor.getInt(this.getDeletedColumnIndex(options)) > 0;
                Map<String, Object> docContents = null;
                if (options.isIncludeDocs()) {
                    byte[] json = cursor.getBlob(4);
                    docContents = this.documentPropertiesFromJSON(json, docId, revId, deleted, sequenceNumber, options.getContentOptions());
                }
                ArrayList<String> conflicts = new ArrayList<String>();
                while ((keepGoing = cursor.moveToNext()) && cursor.getLong(0) == docNumericID) {
                    if (options.getAllDocsMode() != Query.AllDocsMode.SHOW_CONFLICTS && options.getAllDocsMode() != Query.AllDocsMode.ONLY_CONFLICTS) continue;
                    if (conflicts.isEmpty()) {
                        conflicts.add(revId);
                    }
                    conflicts.add(cursor.getString(2));
                }
                if (options.getAllDocsMode() == Query.AllDocsMode.ONLY_CONFLICTS && conflicts.isEmpty()) continue;
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("rev", revId);
                value.put("_conflicts", conflicts);
                if (includeDeletedDocs) {
                    value.put("deleted", deleted ? Boolean.valueOf(true) : null);
                }
                QueryRow change = new QueryRow(docId, sequenceNumber, docId, value, docContents);
                change.setDatabase(this);
                if (options.getKeys() != null) {
                    docs.put(docId, change);
                    continue;
                }
                rows.add(change);
            }
            if (options.getKeys() != null) {
                for (Object docIdObject : options.getKeys()) {
                    if (!(docIdObject instanceof String)) continue;
                    docId = (String)docIdObject;
                    QueryRow change = (QueryRow)docs.get(docId);
                    if (change == null) {
                        HashMap<String, Object> value = new HashMap<String, Object>();
                        long docNumericID = this.getDocNumericID(docId);
                        if (docNumericID > 0L) {
                            ArrayList<Boolean> outIsDeleted = new ArrayList<Boolean>();
                            ArrayList<Boolean> outIsConflict = new ArrayList<Boolean>();
                            String revId = this.winningRevIDOfDoc(docNumericID, outIsDeleted, outIsConflict);
                            if (outIsDeleted.size() > 0) {
                                boolean bl = true;
                            }
                            if (revId != null) {
                                value.put("rev", revId);
                                value.put("deleted", true);
                            }
                        }
                        change = new QueryRow(value != null ? docId : null, 0L, docId, value, null);
                        change.setDatabase(this);
                    }
                    rows.add(change);
                }
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting all docs", e);
            throw new CouchbaseLiteException("Error getting all docs", e, new Status(500));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        result.put("rows", rows);
        result.put("total_rows", rows.size());
        result.put("offset", options.getSkip());
        if (updateSeq != 0L) {
            result.put("update_seq", updateSeq);
        }
        return result;
    }

    @InterfaceAudience.Private
    String winningRevIDOfDoc(long docNumericId, List<Boolean> outIsDeleted, List<Boolean> outIsConflict) throws CouchbaseLiteException {
        Cursor cursor = null;
        String sql = "SELECT revid, deleted FROM revs WHERE doc_id=? and current=1 ORDER BY deleted asc, revid desc LIMIT 2";
        String[] args = new String[]{Long.toString(docNumericId)};
        String revId = null;
        try {
            cursor = this.database.rawQuery(sql, args);
            cursor.moveToNext();
            if (!cursor.isAfterLast()) {
                boolean hasNextResult;
                boolean deleted;
                revId = cursor.getString(0);
                boolean bl = deleted = cursor.getInt(1) > 0;
                if (deleted) {
                    outIsDeleted.add(true);
                }
                if (hasNextResult = cursor.moveToNext()) {
                    boolean isInConflict;
                    boolean isNextDeleted = cursor.getInt(1) > 0;
                    boolean bl2 = isInConflict = !deleted && hasNextResult && !isNextDeleted;
                    if (isInConflict) {
                        outIsConflict.add(true);
                    }
                }
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error", e);
            throw new CouchbaseLiteException("Error", e, new Status(500));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return revId;
    }

    @InterfaceAudience.Private
    void insertAttachmentForSequence(AttachmentInternal attachment, long sequence) throws CouchbaseLiteException {
        this.insertAttachmentForSequenceWithNameAndType(sequence, attachment.getName(), attachment.getContentType(), attachment.getRevpos(), attachment.getBlobKey());
    }

    @InterfaceAudience.Private
    public void insertAttachmentForSequenceWithNameAndType(InputStream contentStream, long sequence, String name, String contentType, int revpos) throws CouchbaseLiteException {
        assert (sequence > 0L);
        assert (name != null);
        BlobKey key = new BlobKey();
        if (!this.attachments.storeBlobStream(contentStream, key)) {
            throw new CouchbaseLiteException(500);
        }
        this.insertAttachmentForSequenceWithNameAndType(sequence, name, contentType, revpos, key);
    }

    @InterfaceAudience.Private
    public void insertAttachmentForSequenceWithNameAndType(long sequence, String name, String contentType, int revpos, BlobKey key) throws CouchbaseLiteException {
        try {
            ContentValues args = new ContentValues();
            args.put("sequence", sequence);
            args.put("filename", name);
            if (key != null) {
                args.put("key", key.getBytes());
                args.put("length", this.attachments.getSizeOfBlob(key));
            }
            args.put("type", contentType);
            args.put("revpos", revpos);
            long result = this.database.insert("attachments", null, args);
            if (result == -1L) {
                String msg = "Insert attachment failed (returned -1)";
                Log.e(TAG, msg);
                throw new CouchbaseLiteException(msg, 500);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error inserting attachment", e);
            throw new CouchbaseLiteException((Throwable)e, 500);
        }
    }

    @InterfaceAudience.Private
    void installAttachment(AttachmentInternal attachment, Map<String, Object> attachInfo) throws CouchbaseLiteException {
        String digest = (String)attachInfo.get("digest");
        if (digest == null) {
            throw new CouchbaseLiteException(491);
        }
        if (this.pendingAttachmentsByDigest != null && this.pendingAttachmentsByDigest.containsKey(digest)) {
            BlobStoreWriter writer = this.pendingAttachmentsByDigest.get(digest);
            try {
                BlobStoreWriter blobStoreWriter = writer;
                blobStoreWriter.install();
                attachment.setBlobKey(blobStoreWriter.getBlobKey());
                attachment.setLength(blobStoreWriter.getLength());
            }
            catch (Exception e) {
                throw new CouchbaseLiteException((Throwable)e, 592);
            }
        }
    }

    @InterfaceAudience.Private
    private Map<String, BlobStoreWriter> getPendingAttachmentsByDigest() {
        if (this.pendingAttachmentsByDigest == null) {
            this.pendingAttachmentsByDigest = new HashMap<String, BlobStoreWriter>();
        }
        return this.pendingAttachmentsByDigest;
    }

    @InterfaceAudience.Private
    public void copyAttachmentNamedFromSequenceToSequence(String name, long fromSeq, long toSeq) throws CouchbaseLiteException {
        assert (name != null);
        assert (toSeq > 0L);
        if (fromSeq < 0L) {
            throw new CouchbaseLiteException(404);
        }
        Cursor cursor = null;
        Object[] args = new String[]{Long.toString(toSeq), name, Long.toString(fromSeq), name};
        try {
            this.database.execSQL("INSERT INTO attachments (sequence, filename, key, type, length, revpos) SELECT ?, ?, key, type, length, revpos FROM attachments WHERE sequence=? AND filename=?", args);
            cursor = this.database.rawQuery("SELECT changes()", null);
            cursor.moveToNext();
            int rowsUpdated = cursor.getInt(0);
            if (rowsUpdated == 0) {
                Log.w(TAG, "Can't find inherited attachment %s from seq# %s to copy to %s", name, fromSeq, toSeq);
                throw new CouchbaseLiteException(404);
            }
            return;
        }
        catch (SQLException e) {
            Log.e(TAG, "Error copying attachment", e);
            throw new CouchbaseLiteException(500);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @InterfaceAudience.Private
    public Attachment getAttachmentForSequence(long sequence, String filename) throws CouchbaseLiteException {
        assert (sequence > 0L);
        assert (filename != null);
        Cursor cursor = null;
        String[] args = new String[]{Long.toString(sequence), filename};
        try {
            cursor = this.database.rawQuery("SELECT key, type FROM attachments WHERE sequence=? AND filename=?", args);
            if (!cursor.moveToNext()) {
                throw new CouchbaseLiteException(404);
            }
            byte[] keyData = cursor.getBlob(0);
            BlobKey key = new BlobKey(keyData);
            InputStream contentStream = this.attachments.blobStreamForKey(key);
            if (contentStream == null) {
                Log.e(TAG, "Failed to load attachment");
                throw new CouchbaseLiteException(500);
            }
            Attachment result = new Attachment(contentStream, cursor.getString(1));
            result.setGZipped(this.attachments.isGZipped(key));
            Attachment attachment = result;
            return attachment;
        }
        catch (SQLException e) {
            throw new CouchbaseLiteException(500);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @InterfaceAudience.Private
    String getAttachmentPathForSequence(long sequence, String filename) throws CouchbaseLiteException {
        assert (sequence > 0L);
        assert (filename != null);
        Cursor cursor = null;
        String filePath = null;
        String[] args = new String[]{Long.toString(sequence), filename};
        try {
            cursor = this.database.rawQuery("SELECT key, type, encoding FROM attachments WHERE sequence=? AND filename=?", args);
            if (!cursor.moveToNext()) {
                throw new CouchbaseLiteException(404);
            }
            byte[] keyData = cursor.getBlob(0);
            BlobKey key = new BlobKey(keyData);
            String string = filePath = this.getAttachments().pathForKey(key);
            return string;
        }
        catch (SQLException e) {
            throw new CouchbaseLiteException(500);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sequenceHasAttachments(long sequence) {
        Cursor cursor = null;
        String[] args = new String[]{Long.toString(sequence)};
        try {
            cursor = this.database.rawQuery("SELECT 1 FROM attachments WHERE sequence=? LIMIT 1", args);
            if (cursor.moveToNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting attachments for sequence", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public Map<String, Object> getAttachmentsDictForSequenceWithContent(long sequence, EnumSet<TDContentOptions> contentOptions) {
        assert (sequence > 0L);
        Cursor cursor = null;
        String[] args = new String[]{Long.toString(sequence)};
        try {
            cursor = this.database.rawQuery("SELECT filename, key, type, length, revpos FROM attachments WHERE sequence=?", args);
            if (!cursor.moveToNext()) {
                Map<String, Object> map = null;
                return map;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            while (!cursor.isAfterLast()) {
                boolean dataSuppressed = false;
                int length = cursor.getInt(3);
                byte[] keyData = cursor.getBlob(1);
                BlobKey key = new BlobKey(keyData);
                String digestString = "sha1-" + Base64.encodeBytes(keyData);
                String dataBase64 = null;
                if (contentOptions.contains((Object)TDContentOptions.TDIncludeAttachments)) {
                    if (contentOptions.contains((Object)TDContentOptions.TDBigAttachmentsFollow) && length >= kBigAttachmentLength) {
                        dataSuppressed = true;
                    } else {
                        byte[] data = this.attachments.blobForKey(key);
                        if (data != null) {
                            dataBase64 = Base64.encodeBytes(data);
                        } else {
                            Log.w(TAG, "Error loading attachment.  Sequence: %s", sequence);
                        }
                    }
                }
                HashMap<String, Object> attachment = new HashMap<String, Object>();
                if (dataBase64 == null && !dataSuppressed) {
                    attachment.put("stub", true);
                }
                if (dataBase64 != null) {
                    attachment.put("data", dataBase64);
                }
                if (dataSuppressed) {
                    attachment.put("follows", true);
                }
                attachment.put("digest", digestString);
                String contentType = cursor.getString(2);
                attachment.put("content_type", contentType);
                attachment.put("length", length);
                attachment.put("revpos", cursor.getInt(4));
                String filename = cursor.getString(0);
                result.put(filename, attachment);
                cursor.moveToNext();
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting attachments for sequence", e);
            Map<String, Object> map = null;
            return map;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @InterfaceAudience.Private
    public URL fileForAttachmentDict(Map<String, Object> attachmentDict) {
        BlobKey key;
        String digest = (String)attachmentDict.get("digest");
        if (digest == null) {
            return null;
        }
        String path = null;
        BlobStoreWriter pending = this.pendingAttachmentsByDigest.get(digest);
        if (pending != null) {
            if (pending instanceof BlobStoreWriter) {
                path = pending.getFilePath();
            } else {
                key = new BlobKey((byte[])pending);
                path = this.attachments.pathForKey(key);
            }
        } else {
            key = new BlobKey(digest);
            path = this.attachments.pathForKey(key);
        }
        URL retval = null;
        try {
            retval = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return retval;
    }

    @InterfaceAudience.Private
    public void stubOutAttachmentsIn(RevisionInternal rev, int minRevPos) {
        if (minRevPos <= 1) {
            return;
        }
        Map<String, Object> properties = rev.getProperties();
        Map attachments = null;
        if (properties != null) {
            attachments = (Map)properties.get("_attachments");
        }
        HashMap<String, Object> editedProperties = null;
        HashMap<String, HashMap<String, Boolean>> editedAttachments = null;
        for (String name : attachments.keySet()) {
            Map attachment = (Map)attachments.get(name);
            int revPos = (Integer)attachment.get("revpos");
            Object stub = attachment.get("stub");
            if (revPos <= 0 || revPos >= minRevPos || stub != null) continue;
            if (editedProperties == null) {
                editedProperties = new HashMap<String, Object>(properties);
                editedAttachments = new HashMap<String, HashMap<String, Boolean>>(attachments);
                editedProperties.put("_attachments", editedAttachments);
            }
            HashMap<String, Boolean> editedAttachment = new HashMap<String, Boolean>(attachment);
            editedAttachment.remove("data");
            editedAttachment.remove("follows");
            editedAttachment.put("stub", true);
            editedAttachments.put(name, editedAttachment);
            Log.v(TAG, "Stubbed out attachment.  minRevPos: %s rev: %s name: %s revpos: %s", minRevPos, rev, name, revPos);
        }
        if (editedProperties != null) {
            rev.setProperties(editedProperties);
        }
    }

    @InterfaceAudience.Private
    void stubOutAttachmentsInRevision(Map<String, AttachmentInternal> attachments, RevisionInternal rev) {
        Map<String, Object> properties = rev.getProperties();
        Map attachmentsFromProps = (Map)properties.get("_attachments");
        if (attachmentsFromProps != null) {
            for (String attachmentKey : attachmentsFromProps.keySet()) {
                AttachmentInternal attachmentObject;
                Map attachmentFromProps = (Map)attachmentsFromProps.get(attachmentKey);
                if (attachmentFromProps.get("follows") == null && attachmentFromProps.get("data") == null) continue;
                attachmentFromProps.remove("follows");
                attachmentFromProps.remove("data");
                attachmentFromProps.put("stub", true);
                if (attachmentFromProps.get("revpos") == null) {
                    attachmentFromProps.put("revpos", rev.getGeneration());
                }
                if ((attachmentObject = attachments.get(attachmentKey)) != null) {
                    attachmentFromProps.put("length", attachmentObject.getLength());
                    if (attachmentObject.getBlobKey() != null) {
                        attachmentFromProps.put("digest", attachmentObject.getBlobKey().base64Digest());
                    }
                }
                attachmentsFromProps.put(attachmentKey, attachmentFromProps);
            }
        }
    }

    public static void stubOutAttachmentsInRevBeforeRevPos(final RevisionInternal rev, final int minRevPos, final boolean attachmentsFollow) {
        if (minRevPos <= 1 && !attachmentsFollow) {
            return;
        }
        rev.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(Map<String, Object> attachment) {
                boolean addFollows;
                int revPos = 0;
                if (attachment.get("revpos") != null) {
                    revPos = (Integer)attachment.get("revpos");
                }
                boolean includeAttachment = revPos == 0 || revPos >= minRevPos;
                boolean stubItOut = !includeAttachment && (attachment.get("stub") == null || (Boolean)attachment.get("stub") == false);
                boolean bl = addFollows = includeAttachment && attachmentsFollow && (attachment.get("follows") == null || (Boolean)attachment.get("follows") == false);
                if (!stubItOut && !addFollows) {
                    return attachment;
                }
                HashMap<String, Object> editedAttachment = new HashMap<String, Object>(attachment);
                editedAttachment.remove("data");
                if (stubItOut) {
                    editedAttachment.remove("follows");
                    editedAttachment.put("stub", true);
                    Log.v("Sync", "Stubbed out attachment %s: revpos %d < %d", rev, revPos, minRevPos);
                } else if (addFollows) {
                    editedAttachment.remove("stub");
                    editedAttachment.put("follows", true);
                    Log.v("Sync", "Added 'follows' for attachment %s: revpos %d >= %d", rev, revPos, minRevPos);
                }
                return editedAttachment;
            }
        });
    }

    public boolean inlineFollowingAttachmentsIn(RevisionInternal rev) {
        return rev.mutateAttachments(new CollectionUtils.Functor<Map<String, Object>, Map<String, Object>>(){

            @Override
            public Map<String, Object> invoke(Map<String, Object> attachment) {
                if (!attachment.containsKey("follows")) {
                    return attachment;
                }
                URL fileURL = Database.this.fileForAttachmentDict(attachment);
                byte[] fileData = null;
                try {
                    InputStream is = fileURL.openStream();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    StreamUtils.copyStream(is, os);
                    fileData = os.toByteArray();
                }
                catch (IOException e) {
                    Log.e("Sync", "could not retrieve attachment data: %S", e);
                    return null;
                }
                HashMap<String, Object> editedAttachment = new HashMap<String, Object>(attachment);
                editedAttachment.remove("follows");
                editedAttachment.put("data", Base64.encodeBytes(fileData));
                return editedAttachment;
            }
        });
    }

    @InterfaceAudience.Private
    void processAttachmentsForRevision(Map<String, AttachmentInternal> attachments, RevisionInternal rev, long parentSequence) throws CouchbaseLiteException {
        assert (rev != null);
        long newSequence = rev.getSequence();
        assert (newSequence > parentSequence);
        int generation = rev.getGeneration();
        assert (generation > 0);
        Map revAttachments = null;
        Map<String, Object> properties = rev.getProperties();
        if (properties != null) {
            revAttachments = (Map)properties.get("_attachments");
        }
        if (revAttachments == null || revAttachments.size() == 0 || rev.isDeleted()) {
            return;
        }
        for (String name : revAttachments.keySet()) {
            AttachmentInternal attachment = attachments.get(name);
            if (attachment != null) {
                if (attachment.getRevpos() == 0) {
                    attachment.setRevpos(generation);
                } else if (attachment.getRevpos() > generation) {
                    Log.w(TAG, "Attachment %s %s has unexpected revpos %s, setting to %s", rev, name, attachment.getRevpos(), generation);
                    attachment.setRevpos(generation);
                }
                this.insertAttachmentForSequence(attachment, newSequence);
                continue;
            }
            this.copyAttachmentNamedFromSequenceToSequence(name, parentSequence, newSequence);
        }
    }

    /*
     * Unable to fully structure code
     */
    @InterfaceAudience.Private
    public RevisionInternal updateAttachment(String filename, BlobStoreWriter body, String contentType, AttachmentInternal.AttachmentEncoding encoding, String docID, String oldRevID) throws CouchbaseLiteException {
        isSuccessful = false;
        if (filename == null || filename.length() == 0 || body != null && contentType == null || oldRevID != null && docID == null || body != null && docID == null) {
            throw new CouchbaseLiteException(400);
        }
        this.beginTransaction();
        try {
            oldRev = new RevisionInternal(docID, oldRevID, false, this);
            if (oldRevID != null) {
                try {
                    this.loadRevisionBody(oldRev, EnumSet.noneOf(TDContentOptions.class));
                }
                catch (CouchbaseLiteException e) {
                    if (e.getCBLStatus().getCode() != 404 || !this.existsDocumentWithIDAndRev(docID, null)) ** GOTO lbl17
                    throw new CouchbaseLiteException(409);
                }
            } else {
                oldRev.setBody(new Body(new HashMap<String, Object>()));
            }
lbl17:
            // 3 sources

            oldRevProps = oldRev.getProperties();
            attachments = null;
            if (oldRevProps != null) {
                attachments = (HashMap<String, HashMap<K, V>>)oldRevProps.get("_attachments");
            }
            if (attachments == null) {
                attachments = new HashMap<String, HashMap<K, V>>();
            }
            if (body != null) {
                key = body.getBlobKey();
                digest = key.base64Digest();
                blobsByDigest = new HashMap<String, BlobStoreWriter>();
                blobsByDigest.put(digest, body);
                this.rememberAttachmentWritersForDigests(blobsByDigest);
                encodingName = encoding == AttachmentInternal.AttachmentEncoding.AttachmentEncodingGZIP ? "gzip" : null;
                dict = new HashMap<String, Object>();
                dict.put("digest", digest);
                dict.put("length", body.getLength());
                dict.put("follows", true);
                dict.put("content_type", contentType);
                dict.put("encoding", encodingName);
                attachments.put(filename, dict);
            } else {
                if (oldRevID != null && !attachments.containsKey(filename)) {
                    throw new CouchbaseLiteException(404);
                }
                attachments.remove(filename);
            }
            properties = oldRev.getProperties();
            properties.put("_attachments", attachments);
            oldRev.setProperties(properties);
            putStatus = new Status();
            newRev = this.putRevision(oldRev, oldRevID, false, putStatus);
            isSuccessful = true;
            var14_16 = newRev;
            return var14_16;
        }
        catch (SQLException e) {
            Log.e("CBLite", "Error updating attachment", e);
            throw new CouchbaseLiteException(new Status(500));
        }
        finally {
            this.endTransaction(isSuccessful);
        }
    }

    @InterfaceAudience.Private
    public void rememberAttachmentWritersForDigests(Map<String, BlobStoreWriter> blobsByDigest) {
        this.getPendingAttachmentsByDigest().putAll(blobsByDigest);
    }

    @InterfaceAudience.Private
    void rememberAttachmentWriter(BlobStoreWriter writer) {
        this.getPendingAttachmentsByDigest().put(writer.mD5DigestString(), writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public Status garbageCollectAttachments() {
        try {
            this.database.execSQL("DELETE FROM attachments WHERE sequence IN (SELECT sequence from revs WHERE json IS null)");
        }
        catch (SQLException e) {
            Log.e(TAG, "Error deleting attachments", e);
        }
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery("SELECT DISTINCT key FROM attachments", null);
            cursor.moveToNext();
            ArrayList<BlobKey> allKeys = new ArrayList<BlobKey>();
            while (!cursor.isAfterLast()) {
                BlobKey key = new BlobKey(cursor.getBlob(0));
                allKeys.add(key);
                cursor.moveToNext();
            }
            int numDeleted = this.attachments.deleteBlobsExceptWithKeys(allKeys);
            if (numDeleted < 0) {
                Status status = new Status(500);
                return status;
            }
            Log.v(TAG, "Deleted %d attachments", numDeleted);
            Status status = new Status(200);
            return status;
        }
        catch (SQLException e) {
            Log.e(TAG, "Error finding attachment keys in use", e);
            Status status = new Status(500);
            return status;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @InterfaceAudience.Private
    public static boolean isValidDocumentId(String id) {
        if (id == null || id.length() == 0) {
            return false;
        }
        if (id.charAt(0) == '_') {
            return id.startsWith("_design/");
        }
        return true;
    }

    @InterfaceAudience.Private
    public static String generateDocumentId() {
        return Misc.TDCreateUUID();
    }

    @InterfaceAudience.Private
    public String generateIDForRevision(RevisionInternal rev, byte[] json, Map<String, AttachmentInternal> attachments, String previousRevisionId) {
        MessageDigest md5Digest;
        int generation = 0;
        if (previousRevisionId != null && (generation = RevisionInternal.generationFromRevID(previousRevisionId)) == 0) {
            return null;
        }
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        int length = 0;
        if (previousRevisionId != null) {
            byte[] prevIDUTF8 = previousRevisionId.getBytes(Charset.forName("UTF-8"));
            length = prevIDUTF8.length;
        }
        if (length > 255) {
            return null;
        }
        byte lengthByte = (byte)(length & 0xFF);
        byte[] lengthBytes = new byte[]{lengthByte};
        md5Digest.update(lengthBytes);
        boolean isDeleted = rev.isDeleted();
        byte[] deletedByte = new byte[]{(byte)(isDeleted ? 1 : 0)};
        md5Digest.update(deletedByte);
        ArrayList<String> attachmentKeys = new ArrayList<String>(attachments.keySet());
        Collections.sort(attachmentKeys);
        for (String key : attachmentKeys) {
            AttachmentInternal attachment = attachments.get(key);
            md5Digest.update(attachment.getBlobKey().getBytes());
        }
        if (json != null) {
            md5Digest.update(json);
        }
        byte[] md5DigestResult = md5Digest.digest();
        String digestAsHex = Utils.bytesToHex(md5DigestResult);
        int generationIncremented = generation + 1;
        return String.format("%d-%s", generationIncremented, digestAsHex);
    }

    @InterfaceAudience.Private
    public long insertDocumentID(String docId) {
        long rowId = -1L;
        try {
            ContentValues args = new ContentValues();
            args.put("docid", docId);
            rowId = this.database.insert("docs", null, args);
        }
        catch (Exception e) {
            Log.e(TAG, "Error inserting document id", e);
        }
        return rowId;
    }

    @InterfaceAudience.Private
    public long getOrInsertDocNumericID(String docId) {
        long docNumericId = this.getDocNumericID(docId);
        if (docNumericId == 0L) {
            docNumericId = this.insertDocumentID(docId);
        }
        return docNumericId;
    }

    @InterfaceAudience.Private
    public static List<String> parseCouchDBRevisionHistory(Map<String, Object> docProperties) {
        Map revisions = (Map)docProperties.get("_revisions");
        if (revisions == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> revIDs = new ArrayList<String>((List)revisions.get("ids"));
        if (revIDs == null || revIDs.isEmpty()) {
            return new ArrayList<String>();
        }
        Integer start = (Integer)revisions.get("start");
        if (start != null) {
            for (int i = 0; i < revIDs.size(); ++i) {
                String revID = (String)revIDs.get(i);
                Integer n = start;
                Integer n2 = start = Integer.valueOf(start - 1);
                revIDs.set(i, Integer.toString(n) + "-" + revID);
            }
        }
        return revIDs;
    }

    @InterfaceAudience.Private
    public byte[] encodeDocumentJSON(RevisionInternal rev) {
        Map<String, Object> origProps = rev.getProperties();
        if (origProps == null) {
            return null;
        }
        List<String> specialKeysToLeave = Arrays.asList("_removed", "_replication_id", "_replication_state", "_replication_state_time");
        HashMap<String, Object> properties = new HashMap<String, Object>(origProps.size());
        for (String key : origProps.keySet()) {
            boolean shouldAdd = false;
            if (key.startsWith("_")) {
                if (!KNOWN_SPECIAL_KEYS.contains(key)) {
                    Log.e(TAG, "Database: Invalid top-level key '%s' in document to be inserted", key);
                    return null;
                }
                if (specialKeysToLeave.contains(key)) {
                    shouldAdd = true;
                }
            } else {
                shouldAdd = true;
            }
            if (!shouldAdd) continue;
            properties.put(key, origProps.get(key));
        }
        byte[] json = null;
        try {
            json = Manager.getObjectMapper().writeValueAsBytes(properties);
        }
        catch (Exception e) {
            Log.e(TAG, "Error serializing " + rev + " to JSON", e);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    private void postChangeNotifications() {
        while (this.transactionLevel == 0 && this.isOpen() && !this.postingChangeNotifications && this.changesToNotify.size() > 0) {
            try {
                this.postingChangeNotifications = true;
                ArrayList<DocumentChange> outgoingChanges = new ArrayList<DocumentChange>();
                outgoingChanges.addAll(this.changesToNotify);
                this.changesToNotify.clear();
                boolean isExternal = false;
                for (DocumentChange change : outgoingChanges) {
                    Document document = this.getDocument(change.getDocumentId());
                    document.revisionAdded(change);
                    if (change.getSourceUrl() == null) continue;
                    isExternal = true;
                }
                ChangeEvent changeEvent = new ChangeEvent(this, isExternal, outgoingChanges);
                for (ChangeListener changeListener : this.changeListeners) {
                    changeListener.changed(changeEvent);
                }
            }
            catch (Exception e) {
                Log.e(TAG, this + " got exception posting change notifications", e);
            }
            finally {
                this.postingChangeNotifications = false;
            }
        }
    }

    private void notifyChange(DocumentChange documentChange) {
        if (this.changesToNotify == null) {
            this.changesToNotify = new ArrayList<DocumentChange>();
        }
        this.changesToNotify.add(documentChange);
        this.postChangeNotifications();
    }

    private void notifyChanges(List<DocumentChange> documentChanges) {
        if (this.changesToNotify == null) {
            this.changesToNotify = new ArrayList<DocumentChange>();
        }
        this.changesToNotify.addAll(documentChanges);
        this.postChangeNotifications();
    }

    @InterfaceAudience.Private
    public void notifyChange(RevisionInternal rev, RevisionInternal winningRev, URL source, boolean inConflict) {
        DocumentChange change = new DocumentChange(rev, winningRev, inConflict, source);
        this.notifyChange(change);
    }

    @InterfaceAudience.Private
    public long insertRevision(RevisionInternal rev, long docNumericID, long parentSequence, boolean current, boolean hasAttachments, byte[] data) {
        long rowId = 0L;
        try {
            ContentValues args = new ContentValues();
            args.put("doc_id", docNumericID);
            args.put("revid", rev.getRevId());
            if (parentSequence != 0L) {
                args.put("parent", parentSequence);
            }
            args.put("current", current);
            args.put("deleted", rev.isDeleted());
            args.put("no_attachments", !hasAttachments);
            args.put("json", data);
            rowId = this.database.insert("revs", null, args);
            rev.setSequence(rowId);
        }
        catch (Exception e) {
            Log.e(TAG, "Error inserting revision", e);
        }
        return rowId;
    }

    @InterfaceAudience.Private
    public RevisionInternal putRevision(RevisionInternal rev, String prevRevId, Status resultStatus) throws CouchbaseLiteException {
        return this.putRevision(rev, prevRevId, false, resultStatus);
    }

    @InterfaceAudience.Private
    public RevisionInternal putRevision(RevisionInternal rev, String prevRevId, boolean allowConflict) throws CouchbaseLiteException {
        Status ignoredStatus = new Status();
        return this.putRevision(rev, prevRevId, allowConflict, ignoredStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public RevisionInternal putRevision(RevisionInternal oldRev, String prevRevId, boolean allowConflict, Status resultStatus) throws CouchbaseLiteException {
        String docId = oldRev.getDocId();
        boolean deleted = oldRev.isDeleted();
        if (oldRev == null || prevRevId != null && docId == null || deleted && docId == null || docId != null && !Database.isValidDocumentId(docId)) {
            throw new CouchbaseLiteException(400);
        }
        this.beginTransaction();
        Cursor cursor = null;
        boolean inConflict = false;
        RevisionInternal winningRev = null;
        RevisionInternal newRev = null;
        long docNumericID = docId != null ? this.getDocNumericID(docId) : 0L;
        long parentSequence = 0L;
        String oldWinningRevID = null;
        try {
            RevisionInternal fakeNewRev;
            boolean oldWinnerWasDeletion = false;
            boolean wasConflicted = false;
            if (docNumericID > 0L) {
                ArrayList<Boolean> outIsDeleted = new ArrayList<Boolean>();
                ArrayList<Boolean> outIsConflict = new ArrayList<Boolean>();
                try {
                    oldWinningRevID = this.winningRevIDOfDoc(docNumericID, outIsDeleted, outIsConflict);
                    if (outIsDeleted.size() > 0) {
                        oldWinnerWasDeletion = true;
                    }
                    if (outIsConflict.size() > 0) {
                        wasConflicted = true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (prevRevId != null) {
                String msg;
                if (docNumericID <= 0L) {
                    msg = String.format("No existing revision found with doc id: %s", docId);
                    throw new CouchbaseLiteException(msg, 404);
                }
                parentSequence = this.getSequenceOfDocument(docNumericID, prevRevId, !allowConflict);
                if (parentSequence == 0L) {
                    if (!allowConflict && this.existsDocumentWithIDAndRev(docId, null)) {
                        msg = String.format("Conflicts not allowed and there is already an existing doc with id: %s", docId);
                        throw new CouchbaseLiteException(msg, 409);
                    }
                    msg = String.format("No existing revision found with doc id: %s", docId);
                    throw new CouchbaseLiteException(msg, 404);
                }
                if (this.validations != null && this.validations.size() > 0) {
                    fakeNewRev = oldRev.copyWithDocID(oldRev.getDocId(), null);
                    RevisionInternal prevRev = new RevisionInternal(docId, prevRevId, false, this);
                    this.validateRevision(fakeNewRev, prevRev, prevRevId);
                }
            } else {
                if (deleted && docId != null) {
                    if (this.existsDocumentWithIDAndRev(docId, null)) {
                        throw new CouchbaseLiteException(409);
                    }
                    throw new CouchbaseLiteException(404);
                }
                this.validateRevision(oldRev, null, null);
                if (docId != null) {
                    if (docNumericID <= 0L) {
                        docNumericID = this.insertDocumentID(docId);
                        if (docNumericID <= 0L) {
                            fakeNewRev = null;
                            return fakeNewRev;
                        }
                    } else if (oldWinnerWasDeletion) {
                        prevRevId = oldWinningRevID;
                        parentSequence = this.getSequenceOfDocument(docNumericID, prevRevId, false);
                    } else if (oldWinningRevID != null) {
                        throw new CouchbaseLiteException(409);
                    }
                } else {
                    docId = Database.generateDocumentId();
                    docNumericID = this.insertDocumentID(docId);
                    if (docNumericID <= 0L) {
                        fakeNewRev = null;
                        return fakeNewRev;
                    }
                }
            }
            inConflict = wasConflicted || !deleted && prevRevId != null && oldWinningRevID != null && !prevRevId.equals(oldWinningRevID);
            Map<String, AttachmentInternal> attachments = this.getAttachmentsFromRevision(oldRev);
            byte[] json = null;
            if (!oldRev.isDeleted()) {
                json = this.encodeDocumentJSON(oldRev);
                if (json == null) {
                    throw new CouchbaseLiteException(400);
                }
                if (json.length == 2 && json[0] == 123 && json[1] == 125) {
                    json = null;
                }
            }
            String newRevId = this.generateIDForRevision(oldRev, json, attachments, prevRevId);
            newRev = oldRev.copyWithDocID(docId, newRevId);
            this.stubOutAttachmentsInRevision(attachments, newRev);
            if (json == null) {
                json = new byte[]{};
            }
            int attachmentSize = attachments.size();
            boolean hasAttachments = attachments.size() > 0;
            long newSequence = this.insertRevision(newRev, docNumericID, parentSequence, true, attachments.size() > 0, json);
            if (newSequence == 0L) {
                RevisionInternal revisionInternal = null;
                return revisionInternal;
            }
            try {
                ContentValues args = new ContentValues();
                args.put("current", 0);
                this.database.update("revs", args, "sequence=?", new String[]{String.valueOf(parentSequence)});
            }
            catch (SQLException e) {
                Log.e(TAG, "Error setting parent rev non-current", e);
                throw new CouchbaseLiteException(500);
            }
            if (attachments != null) {
                this.processAttachmentsForRevision(attachments, newRev, parentSequence);
            }
            winningRev = this.winner(docNumericID, oldWinningRevID, oldWinnerWasDeletion, newRev);
            if (deleted) {
                resultStatus.setCode(200);
            } else {
                resultStatus.setCode(201);
            }
        }
        catch (SQLException e1) {
            Log.e(TAG, "Error putting revision", e1);
            RevisionInternal revisionInternal = null;
            return revisionInternal;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.endTransaction(resultStatus.isSuccessful());
        }
        this.notifyChange(newRev, winningRev, null, inConflict);
        return newRev;
    }

    @InterfaceAudience.Private
    RevisionInternal winner(long docNumericID, String oldWinningRevID, boolean oldWinnerWasDeletion, RevisionInternal newRev) throws CouchbaseLiteException {
        if (oldWinningRevID == null) {
            return newRev;
        }
        String newRevID = newRev.getRevId();
        if (!newRev.isDeleted()) {
            if (oldWinnerWasDeletion || RevisionInternal.CBLCompareRevIDs(newRevID, oldWinningRevID) > 0) {
                return newRev;
            }
        } else if (oldWinnerWasDeletion) {
            if (RevisionInternal.CBLCompareRevIDs(newRevID, oldWinningRevID) > 0) {
                return newRev;
            }
        } else {
            ArrayList<Boolean> outIsDeleted = new ArrayList<Boolean>();
            ArrayList<Boolean> outIsConflict = new ArrayList<Boolean>();
            String winningRevID = this.winningRevIDOfDoc(docNumericID, outIsDeleted, outIsConflict);
            if (!winningRevID.equals(oldWinningRevID)) {
                if (winningRevID.equals(newRev.getRevId())) {
                    return newRev;
                }
                boolean deleted = false;
                RevisionInternal winningRev = new RevisionInternal(newRev.getDocId(), winningRevID, deleted, this);
                return winningRev;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    private long getSequenceOfDocument(long docNumericId, String revId, boolean onlyCurrent) {
        long result = -1L;
        Cursor cursor = null;
        try {
            String extraSql = onlyCurrent ? "AND current=1" : "";
            String sql = String.format("SELECT sequence FROM revs WHERE doc_id=? AND revid=? %s LIMIT 1", extraSql);
            String[] args = new String[]{"" + docNumericId, revId};
            cursor = this.database.rawQuery(sql, args);
            result = cursor.moveToNext() ? cursor.getLong(0) : 0L;
        }
        catch (Exception e) {
            Log.e(TAG, "Error getting getSequenceOfDocument", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    Map<String, AttachmentInternal> getAttachmentsFromRevision(RevisionInternal rev) throws CouchbaseLiteException {
        Map revAttachments = (Map)rev.getPropertyForKey("_attachments");
        if (revAttachments == null || revAttachments.size() == 0 || rev.isDeleted()) {
            return new HashMap<String, AttachmentInternal>();
        }
        HashMap<String, AttachmentInternal> attachments = new HashMap<String, AttachmentInternal>();
        for (String name : revAttachments.keySet()) {
            Map attachInfo = (Map)revAttachments.get(name);
            String contentType = (String)attachInfo.get("content_type");
            AttachmentInternal attachment = new AttachmentInternal(name, contentType);
            String newContentBase64 = (String)attachInfo.get("data");
            if (newContentBase64 != null) {
                byte[] newContents;
                try {
                    newContents = Base64.decode(newContentBase64);
                }
                catch (IOException e) {
                    throw new CouchbaseLiteException((Throwable)e, 490);
                }
                attachment.setLength(newContents.length);
                BlobKey outBlobKey = new BlobKey();
                boolean storedBlob = this.getAttachments().storeBlob(newContents, outBlobKey);
                attachment.setBlobKey(outBlobKey);
                if (!storedBlob) {
                    throw new CouchbaseLiteException(592);
                }
            } else if (attachInfo.containsKey("follows") && ((Boolean)attachInfo.get("follows")).booleanValue()) {
                this.installAttachment(attachment, attachInfo);
            } else {
                if (!((Boolean)attachInfo.get("stub")).booleanValue()) {
                    throw new CouchbaseLiteException("Expected this attachment to be a stub", 491);
                }
                int revPos = (Integer)attachInfo.get("revpos");
                if (revPos > 0) continue;
                throw new CouchbaseLiteException("Invalid revpos: " + revPos, 491);
            }
            String encodingStr = (String)attachInfo.get("encoding");
            if (encodingStr != null && encodingStr.length() > 0) {
                if (!encodingStr.equalsIgnoreCase("gzip")) {
                    throw new CouchbaseLiteException("Unnkown encoding: " + encodingStr, 490);
                }
                attachment.setEncoding(AttachmentInternal.AttachmentEncoding.AttachmentEncodingGZIP);
                attachment.setEncodedLength(attachment.getLength());
                if (attachInfo.containsKey("length")) {
                    Number attachmentLength = (Number)attachInfo.get("length");
                    attachment.setLength(attachmentLength.longValue());
                }
            }
            if (attachInfo.containsKey("revpos")) {
                attachment.setRevpos((Integer)attachInfo.get("revpos"));
            }
            attachments.put(name, attachment);
        }
        return attachments;
    }

    @InterfaceAudience.Private
    public void forceInsert(RevisionInternal rev, List<String> revHistory, URL source) throws CouchbaseLiteException {
        RevisionInternal winningRev = null;
        boolean inConflict = false;
        String docId = rev.getDocId();
        String revId = rev.getRevId();
        if (!Database.isValidDocumentId(docId) || revId == null) {
            throw new CouchbaseLiteException(400);
        }
        int historyCount = 0;
        if (revHistory != null) {
            historyCount = revHistory.size();
        }
        if (historyCount == 0) {
            revHistory = new ArrayList<String>();
            revHistory.add(revId);
            historyCount = 1;
        } else if (!revHistory.get(0).equals(rev.getRevId())) {
            throw new CouchbaseLiteException(400);
        }
        boolean success = false;
        this.beginTransaction();
        try {
            long docNumericID = this.getOrInsertDocNumericID(docId);
            RevisionList localRevs = this.getAllRevisionsOfDocumentID(docId, docNumericID, false);
            if (localRevs == null) {
                throw new CouchbaseLiteException(500);
            }
            ArrayList<Boolean> outIsDeleted = new ArrayList<Boolean>();
            ArrayList<Boolean> outIsConflict = new ArrayList<Boolean>();
            boolean oldWinnerWasDeletion = false;
            String oldWinningRevID = this.winningRevIDOfDoc(docNumericID, outIsDeleted, outIsConflict);
            if (outIsDeleted.size() > 0) {
                oldWinnerWasDeletion = true;
            }
            if (outIsConflict.size() > 0) {
                inConflict = true;
            }
            long sequence = 0L;
            long localParentSequence = 0L;
            String localParentRevID = null;
            for (int i = revHistory.size() - 1; i >= 0; --i) {
                Map<String, AttachmentInternal> attachments;
                RevisionInternal newRev;
                revId = revHistory.get(i);
                RevisionInternal localRev = localRevs.revWithDocIdAndRevId(docId, revId);
                if (localRev != null) {
                    sequence = localRev.getSequence();
                    assert (sequence > 0L);
                    localParentSequence = sequence;
                    localParentRevID = revId;
                    continue;
                }
                byte[] data = null;
                boolean current = false;
                if (i == 0) {
                    newRev = rev;
                    if (!rev.isDeleted() && (data = this.encodeDocumentJSON(rev)) == null) {
                        throw new CouchbaseLiteException(400);
                    }
                    current = true;
                } else {
                    newRev = new RevisionInternal(docId, revId, false, this);
                }
                sequence = this.insertRevision(newRev, docNumericID, sequence, current, this.getAttachmentsFromRevision(newRev).size() > 0, data);
                if (sequence <= 0L) {
                    throw new CouchbaseLiteException(500);
                }
                if (i != 0 || (attachments = this.getAttachmentsFromRevision(rev)) == null) continue;
                this.processAttachmentsForRevision(attachments, rev, localParentSequence);
                this.stubOutAttachmentsInRevision(attachments, rev);
            }
            if (localParentSequence > 0L && localParentSequence != sequence) {
                ContentValues args = new ContentValues();
                args.put("current", 0);
                String[] whereArgs = new String[]{Long.toString(localParentSequence)};
                int numRowsChanged = 0;
                try {
                    numRowsChanged = this.database.update("revs", args, "sequence=? AND current!=0", whereArgs);
                    if (numRowsChanged == 0) {
                        inConflict = true;
                    }
                }
                catch (SQLException e) {
                    throw new CouchbaseLiteException(500);
                }
            }
            winningRev = this.winner(docNumericID, oldWinningRevID, oldWinnerWasDeletion, rev);
            success = true;
            this.notifyChange(rev, winningRev, source, inConflict);
        }
        catch (SQLException e) {
            throw new CouchbaseLiteException(500);
        }
        finally {
            this.endTransaction(success);
        }
    }

    @InterfaceAudience.Private
    public void validateRevision(RevisionInternal newRev, RevisionInternal oldRev, String parentRevID) throws CouchbaseLiteException {
        if (this.validations == null || this.validations.size() == 0) {
            return;
        }
        SavedRevision publicRev = new SavedRevision(this, newRev);
        publicRev.setParentRevisionID(parentRevID);
        ValidationContextImpl context = new ValidationContextImpl(this, oldRev, newRev);
        for (String validationName : this.validations.keySet()) {
            Validator validation = this.getValidation(validationName);
            validation.validate(publicRev, context);
            if (context.getRejectMessage() == null) continue;
            throw new CouchbaseLiteException(context.getRejectMessage(), 403);
        }
    }

    @InterfaceAudience.Private
    public Replication getActiveReplicator(URL remote, boolean push) {
        if (this.activeReplicators != null) {
            for (Replication replicator : this.activeReplicators) {
                if (!replicator.getRemoteUrl().equals(remote) || replicator.isPull() != !push || !replicator.isRunning()) continue;
                return replicator;
            }
        }
        return null;
    }

    @InterfaceAudience.Private
    public Replication getReplicator(URL remote, boolean push, boolean continuous, ScheduledExecutorService workExecutor) {
        Replication replicator = this.getReplicator(remote, null, push, continuous, workExecutor);
        return replicator;
    }

    @InterfaceAudience.Private
    public Replication getReplicator(String sessionId) {
        if (this.allReplicators != null) {
            for (Replication replicator : this.allReplicators) {
                if (!replicator.getSessionID().equals(sessionId)) continue;
                return replicator;
            }
        }
        return null;
    }

    @InterfaceAudience.Private
    public Replication getReplicator(URL remote, HttpClientFactory httpClientFactory, boolean push, boolean continuous, ScheduledExecutorService workExecutor) {
        Replication result = this.getActiveReplicator(remote, push);
        if (result != null) {
            return result;
        }
        result = push ? new Pusher(this, remote, continuous, httpClientFactory, workExecutor) : new Puller(this, remote, continuous, httpClientFactory, workExecutor);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public String lastSequenceWithCheckpointId(String checkpointId) {
        Cursor cursor = null;
        String result = null;
        try {
            String[] args = new String[]{checkpointId};
            cursor = this.database.rawQuery("SELECT last_sequence FROM replicators WHERE remote=?", args);
            if (cursor.moveToNext()) {
                result = cursor.getString(0);
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting last sequence", e);
            String string = null;
            return string;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public boolean setLastSequence(String lastSequence, String checkpointId, boolean push) {
        Log.v(TAG, "%s: setLastSequence() called with lastSequence: %s checkpointId: %s", this, lastSequence, checkpointId);
        ContentValues values = new ContentValues();
        values.put("remote", checkpointId);
        values.put("push", push);
        values.put("last_sequence", lastSequence);
        long newId = this.database.insertWithOnConflict("replicators", null, values, 5);
        return newId == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public String getLastSequenceStored(String checkpointId, boolean push) {
        if (!push) {
            throw new RuntimeException("need to unhardcode push = 1 before it will work with pull replications");
        }
        String sql = "SELECT last_sequence FROM replicators WHERE remote = ? AND push = 1 ";
        String[] args = new String[]{checkpointId};
        Cursor cursor = null;
        Object changes = null;
        String lastSequence = null;
        try {
            cursor = this.database.rawQuery(sql, args);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                lastSequence = cursor.getString(0);
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            Log.e(TAG, "Error", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return lastSequence;
    }

    @InterfaceAudience.Private
    public static String quote(String string) {
        return string.replace("'", "''");
    }

    @InterfaceAudience.Private
    public static String joinQuotedObjects(List<Object> objects) {
        ArrayList<String> strings = new ArrayList<String>();
        for (Object object : objects) {
            strings.add(object != null ? object.toString() : null);
        }
        return Database.joinQuoted(strings);
    }

    @InterfaceAudience.Private
    public static String joinQuoted(List<String> strings) {
        if (strings.size() == 0) {
            return "";
        }
        String result = "'";
        boolean first = true;
        for (String string : strings) {
            if (first) {
                first = false;
            } else {
                result = result + "','";
            }
            result = result + Database.quote(string);
        }
        result = result + "'";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public int findMissingRevisions(RevisionList touchRevs) throws SQLException {
        int numRevisionsRemoved = 0;
        if (touchRevs.size() == 0) {
            return numRevisionsRemoved;
        }
        String quotedDocIds = Database.joinQuoted(touchRevs.getAllDocIds());
        String quotedRevIds = Database.joinQuoted(touchRevs.getAllRevIds());
        String sql = "SELECT docid, revid FROM revs, docs WHERE docid IN (" + quotedDocIds + ") AND revid in (" + quotedRevIds + ")" + " AND revs.doc_id == docs.doc_id";
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery(sql, null);
            cursor.moveToNext();
            while (!cursor.isAfterLast()) {
                RevisionInternal rev = touchRevs.revWithDocIdAndRevId(cursor.getString(0), cursor.getString(1));
                if (rev != null) {
                    touchRevs.remove(rev);
                    ++numRevisionsRemoved;
                }
                cursor.moveToNext();
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return numRevisionsRemoved;
    }

    @InterfaceAudience.Private
    static String makeLocalDocumentId(String documentId) {
        return String.format("_local/%s", documentId);
    }

    @InterfaceAudience.Private
    public RevisionInternal putLocalRevision(RevisionInternal revision, String prevRevID) throws CouchbaseLiteException {
        String docID = revision.getDocId();
        if (!docID.startsWith("_local/")) {
            throw new CouchbaseLiteException(400);
        }
        if (!revision.isDeleted()) {
            String newRevID;
            block9: {
                byte[] json = this.encodeDocumentJSON(revision);
                if (prevRevID != null) {
                    int generation = RevisionInternal.generationFromRevID(prevRevID);
                    if (generation == 0) {
                        throw new CouchbaseLiteException(400);
                    }
                    newRevID = Integer.toString(++generation) + "-local";
                    ContentValues values = new ContentValues();
                    values.put("revid", newRevID);
                    values.put("json", json);
                    String[] whereArgs = new String[]{docID, prevRevID};
                    try {
                        int rowsUpdated = this.database.update("localdocs", values, "docid=? AND revid=?", whereArgs);
                        if (rowsUpdated == 0) {
                            throw new CouchbaseLiteException(409);
                        }
                        break block9;
                    }
                    catch (SQLException e) {
                        throw new CouchbaseLiteException((Throwable)e, 500);
                    }
                }
                newRevID = "1-local";
                ContentValues values = new ContentValues();
                values.put("docid", docID);
                values.put("revid", newRevID);
                values.put("json", json);
                try {
                    this.database.insertWithOnConflict("localdocs", null, values, 4);
                }
                catch (SQLException e) {
                    throw new CouchbaseLiteException((Throwable)e, 500);
                }
            }
            return revision.copyWithDocID(docID, newRevID);
        }
        this.deleteLocalDocument(docID, prevRevID);
        return revision;
    }

    @InterfaceAudience.Private
    public Query slowQuery(Mapper map) {
        return new Query(this, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    RevisionInternal getParentRevision(RevisionInternal rev) {
        long seq = rev.getSequence();
        if (seq > 0L) {
            seq = this.longForQuery("SELECT parent FROM revs WHERE sequence=?", new String[]{Long.toString(seq)});
        } else {
            long docNumericID = this.getDocNumericID(rev.getDocId());
            if (docNumericID <= 0L) {
                return null;
            }
            String[] args = new String[]{Long.toString(docNumericID), rev.getRevId()};
            seq = this.longForQuery("SELECT parent FROM revs WHERE doc_id=? and revid=?", args);
        }
        if (seq == 0L) {
            return null;
        }
        RevisionInternal result = null;
        String[] args = new String[]{Long.toString(seq)};
        String queryString = "SELECT revid, deleted FROM revs WHERE sequence=?";
        Cursor cursor = null;
        try {
            cursor = this.database.rawQuery(queryString, args);
            if (cursor.moveToNext()) {
                String revId = cursor.getString(0);
                boolean deleted = cursor.getInt(1) > 0;
                result = new RevisionInternal(rev.getDocId(), revId, deleted, this);
                result.setSequence(seq);
            }
        }
        finally {
            cursor.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    long longForQuery(String sqlQuery, String[] args) throws SQLException {
        Cursor cursor = null;
        long result = 0L;
        try {
            cursor = this.database.rawQuery(sqlQuery, args);
            if (cursor.moveToNext()) {
                result = cursor.getLong(0);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    @InterfaceAudience.Private
    public Map<String, Object> purgeRevisions(final Map<String, List<String>> docsToRevs) {
        final HashMap<String, Object> result = new HashMap<String, Object>();
        this.runInTransaction(new TransactionalTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run() {
                for (String docID : docsToRevs.keySet()) {
                    long docNumericID = Database.this.getDocNumericID(docID);
                    if (docNumericID == -1L) continue;
                    ArrayList<String> revsPurged = new ArrayList<String>();
                    List revIDs = (List)docsToRevs.get(docID);
                    if (revIDs == null) {
                        return false;
                    }
                    if (revIDs.size() == 0) {
                        revsPurged = new ArrayList();
                    } else if (revIDs.contains("*")) {
                        try {
                            Object[] args = new String[]{Long.toString(docNumericID)};
                            Database.this.database.execSQL("DELETE FROM revs WHERE doc_id=?", args);
                        }
                        catch (SQLException e) {
                            Log.e(Database.TAG, "Error deleting revisions", e);
                            return false;
                        }
                        revsPurged = new ArrayList();
                        revsPurged.add("*");
                    } else {
                        Cursor cursor = null;
                        try {
                            String[] args = new String[]{Long.toString(docNumericID)};
                            String queryString = "SELECT revid, sequence, parent FROM revs WHERE doc_id=? ORDER BY sequence DESC";
                            cursor = Database.this.database.rawQuery(queryString, args);
                            if (!cursor.moveToNext()) {
                                Log.w(Database.TAG, "No results for query: %s", queryString);
                                boolean bl = false;
                                return bl;
                            }
                            HashSet<Long> seqsToPurge = new HashSet<Long>();
                            HashSet<Long> seqsToKeep = new HashSet<Long>();
                            HashSet<String> revsToPurge = new HashSet<String>();
                            while (!cursor.isAfterLast()) {
                                String revID = cursor.getString(0);
                                long sequence = cursor.getLong(1);
                                long parent = cursor.getLong(2);
                                if (seqsToPurge.contains(sequence) || revIDs.contains(revID) && !seqsToKeep.contains(sequence)) {
                                    seqsToPurge.add(sequence);
                                    revsToPurge.add(revID);
                                    if (parent > 0L) {
                                        seqsToPurge.add(parent);
                                    }
                                } else {
                                    seqsToPurge.remove(sequence);
                                    revsToPurge.remove(revID);
                                    seqsToKeep.add(parent);
                                }
                                cursor.moveToNext();
                            }
                            seqsToPurge.removeAll(seqsToKeep);
                            Log.i(Database.TAG, "Purging doc '%s' revs (%s); asked for (%s)", docID, revsToPurge, revIDs);
                            if (seqsToPurge.size() > 0) {
                                String seqsToPurgeList = TextUtils.join(",", seqsToPurge);
                                String sql = String.format("DELETE FROM revs WHERE sequence in (%s)", seqsToPurgeList);
                                try {
                                    Database.this.database.execSQL(sql);
                                }
                                catch (SQLException e) {
                                    Log.e(Database.TAG, "Error deleting revisions via: " + sql, e);
                                    boolean bl = false;
                                    if (cursor != null) {
                                        cursor.close();
                                    }
                                    return bl;
                                }
                            }
                            revsPurged.addAll(revsToPurge);
                        }
                        catch (SQLException e) {
                            Log.e(Database.TAG, "Error getting revisions", e);
                            boolean bl = false;
                            return bl;
                        }
                        finally {
                            if (cursor != null) {
                                cursor.close();
                            }
                        }
                    }
                    result.put(docID, revsPurged);
                }
                return true;
            }
        });
        return result;
    }

    @InterfaceAudience.Private
    protected boolean replaceUUIDs() {
        String query = "UPDATE INFO SET value='" + Misc.TDCreateUUID() + "' where key = 'privateUUID';";
        try {
            this.database.execSQL(query);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error updating UUIDs", e);
            return false;
        }
        query = "UPDATE INFO SET value='" + Misc.TDCreateUUID() + "' where key = 'publicUUID';";
        try {
            this.database.execSQL(query);
        }
        catch (SQLException e) {
            Log.e(TAG, "Error updating UUIDs", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public RevisionInternal getLocalDocument(String docID, String revID) {
        RevisionInternal revisionInternal;
        RevisionInternal result = null;
        Cursor cursor = null;
        try {
            String[] args = new String[]{docID};
            cursor = this.database.rawQuery("SELECT revid, json FROM localdocs WHERE docid=?", args);
            if (cursor.moveToNext()) {
                String gotRevID = cursor.getString(0);
                if (revID != null && !revID.equals(gotRevID)) {
                    RevisionInternal revisionInternal2 = null;
                    return revisionInternal2;
                }
                byte[] json = cursor.getBlob(1);
                Map properties = null;
                try {
                    properties = (Map)Manager.getObjectMapper().readValue(json, Map.class);
                    properties.put("_id", docID);
                    properties.put("_rev", gotRevID);
                    result = new RevisionInternal(docID, gotRevID, false, this);
                    result.setProperties(properties);
                }
                catch (Exception e) {
                    Log.w(TAG, "Error parsing local doc JSON", e);
                    RevisionInternal revisionInternal3 = null;
                    if (cursor != null) {
                        cursor.close();
                    }
                    return revisionInternal3;
                }
            }
            revisionInternal = result;
            return revisionInternal;
        }
        catch (SQLException e) {
            Log.e(TAG, "Error getting local document", e);
            revisionInternal = null;
            return revisionInternal;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    @InterfaceAudience.Private
    public long getStartTime() {
        return this.startTime;
    }

    @InterfaceAudience.Private
    public void deleteLocalDocument(String docID, String revID) throws CouchbaseLiteException {
        if (docID == null) {
            throw new CouchbaseLiteException(400);
        }
        if (revID == null) {
            if (this.getLocalDocument(docID, null) != null) {
                throw new CouchbaseLiteException(409);
            }
            throw new CouchbaseLiteException(404);
        }
        String[] whereArgs = new String[]{docID, revID};
        try {
            int rowsDeleted = this.database.delete("localdocs", "docid=? AND revid=?", whereArgs);
            if (rowsDeleted == 0) {
                if (this.getLocalDocument(docID, null) != null) {
                    throw new CouchbaseLiteException(409);
                }
                throw new CouchbaseLiteException(404);
            }
        }
        catch (SQLException e) {
            throw new CouchbaseLiteException((Throwable)e, 500);
        }
    }

    @InterfaceAudience.Private
    public void setName(String name) {
        this.name = name;
    }

    @InterfaceAudience.Private
    int pruneRevsToMaxDepth(int maxDepth) throws CouchbaseLiteException {
        int outPruned = 0;
        boolean shouldCommit = false;
        HashMap<Long, Integer> toPrune = new HashMap<Long, Integer>();
        if (maxDepth == 0) {
            maxDepth = this.getMaxRevTreeDepth();
        }
        Cursor cursor = null;
        String[] args = new String[]{};
        long docNumericID = -1L;
        int minGen = 0;
        int maxGen = 0;
        try {
            cursor = this.database.rawQuery("SELECT doc_id, MIN(revid), MAX(revid) FROM revs GROUP BY doc_id", args);
            while (cursor.moveToNext()) {
                docNumericID = cursor.getLong(0);
                String minGenRevId = cursor.getString(1);
                String maxGenRevId = cursor.getString(2);
                minGen = Revision.generationFromRevID(minGenRevId);
                maxGen = Revision.generationFromRevID(maxGenRevId);
                if (maxGen - minGen + 1 <= maxDepth) continue;
                toPrune.put(docNumericID, maxGen - minGen);
            }
            this.beginTransaction();
            if (toPrune.size() == 0) {
                int minGenRevId = 0;
                return minGenRevId;
            }
            for (Long docNumericIDLong : toPrune.keySet()) {
                String minIDToKeep = String.format("%d-", (Integer)toPrune.get(docNumericIDLong) + 1);
                String[] deleteArgs = new String[]{Long.toString(docNumericID), minIDToKeep};
                int rowsDeleted = this.database.delete("revs", "doc_id=? AND revid < ? AND current=0", deleteArgs);
                outPruned += rowsDeleted;
            }
            shouldCommit = true;
        }
        catch (Exception e) {
            throw new CouchbaseLiteException((Throwable)e, 500);
        }
        finally {
            this.endTransaction(shouldCommit);
            if (cursor != null) {
                cursor.close();
            }
        }
        return outPruned;
    }

    @InterfaceAudience.Private
    public boolean isOpen() {
        return this.open;
    }

    @InterfaceAudience.Private
    public void addReplication(Replication replication) {
        if (this.allReplicators != null) {
            this.allReplicators.add(replication);
        }
    }

    @InterfaceAudience.Private
    public void forgetReplication(Replication replication) {
        this.allReplicators.remove(replication);
    }

    @InterfaceAudience.Private
    public void addActiveReplication(Replication replication) {
        if (this.activeReplicators != null) {
            this.activeReplicators.add(replication);
        }
        replication.addChangeListener(new Replication.ChangeListener(){

            @Override
            public void changed(Replication.ChangeEvent event) {
                if (!event.getSource().isRunning() && Database.this.activeReplicators != null) {
                    Database.this.activeReplicators.remove(event.getSource());
                }
            }
        });
    }

    @InterfaceAudience.Private
    public PersistentCookieStore getPersistentCookieStore() {
        if (this.persistentCookieStore == null) {
            this.persistentCookieStore = new PersistentCookieStore(this);
        }
        return this.persistentCookieStore;
    }

    static {
        kBigAttachmentLength = 16384;
        KNOWN_SPECIAL_KEYS = new HashSet<String>();
        KNOWN_SPECIAL_KEYS.add("_id");
        KNOWN_SPECIAL_KEYS.add("_rev");
        KNOWN_SPECIAL_KEYS.add("_attachments");
        KNOWN_SPECIAL_KEYS.add("_deleted");
        KNOWN_SPECIAL_KEYS.add("_revisions");
        KNOWN_SPECIAL_KEYS.add("_revs_info");
        KNOWN_SPECIAL_KEYS.add("_conflicts");
        KNOWN_SPECIAL_KEYS.add("_deleted_conflicts");
        KNOWN_SPECIAL_KEYS.add("_local_seq");
        KNOWN_SPECIAL_KEYS.add("_removed");
    }

    @InterfaceAudience.Public
    public static interface ChangeListener {
        public void changed(ChangeEvent var1);
    }

    @InterfaceAudience.Public
    public static class ChangeEvent {
        private Database source;
        private boolean isExternal;
        private List<DocumentChange> changes;

        public ChangeEvent(Database source, boolean isExternal, List<DocumentChange> changes) {
            this.source = source;
            this.isExternal = isExternal;
            this.changes = changes;
        }

        public Database getSource() {
            return this.source;
        }

        public boolean isExternal() {
            return this.isExternal;
        }

        public List<DocumentChange> getChanges() {
            return this.changes;
        }
    }

    public static enum TDContentOptions {
        TDIncludeAttachments,
        TDIncludeConflicts,
        TDIncludeRevs,
        TDIncludeRevsInfo,
        TDIncludeLocalSeq,
        TDNoBody,
        TDBigAttachmentsFollow,
        TDNoAttachments;

    }
}

