/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.BlobStore;
import com.couchbase.lite.Misc;
import com.couchbase.lite.support.Base64;
import com.couchbase.lite.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BlobStoreWriter {
    private BlobStore store;
    private int length;
    private BlobKey blobKey;
    private byte[] md5DigestResult;
    private MessageDigest sha1Digest;
    private MessageDigest md5Digest;
    private BufferedOutputStream outStream;
    private File tempFile;

    public BlobStoreWriter(BlobStore store) {
        this.store = store;
        try {
            this.sha1Digest = MessageDigest.getInstance("SHA-1");
            this.sha1Digest.reset();
            this.md5Digest = MessageDigest.getInstance("MD5");
            this.md5Digest.reset();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.openTempFile();
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void openTempFile() throws FileNotFoundException {
        String uuid = Misc.TDCreateUUID();
        String filename = String.format("%s.blobtmp", uuid);
        File tempDir = this.store.tempDir();
        this.tempFile = new File(tempDir, filename);
        this.outStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
    }

    public void appendData(byte[] data) {
        try {
            this.outStream.write(data);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to stream.", e);
        }
        this.length += data.length;
        this.sha1Digest.update(data);
        this.md5Digest.update(data);
    }

    void read(InputStream inputStream) {
        byte[] buffer = new byte[1024];
        this.length = 0;
        try {
            int len;
            while ((len = inputStream.read(buffer)) != -1) {
                this.outStream.write(buffer, 0, len);
                this.sha1Digest.update(buffer, 0, len);
                this.md5Digest.update(buffer, 0, len);
                this.length += len;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read from stream.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Log.w("BlobStore", "Exception closing input stream", e);
            }
        }
    }

    public void finish() {
        try {
            this.outStream.close();
        }
        catch (IOException e) {
            Log.w("BlobStore", "Exception closing output stream", e);
        }
        this.blobKey = new BlobKey(this.sha1Digest.digest());
        this.md5DigestResult = this.md5Digest.digest();
    }

    public void cancel() {
        try {
            this.outStream.close();
        }
        catch (IOException e) {
            Log.w("BlobStore", "Exception closing output stream", e);
        }
        this.tempFile.delete();
    }

    public void install() {
        if (this.tempFile == null) {
            return;
        }
        String destPath = this.store.pathForKey(this.blobKey);
        File destPathFile = new File(destPath);
        boolean result = this.tempFile.renameTo(destPathFile);
        if (!result) {
            this.cancel();
        }
        this.tempFile = null;
    }

    public String mD5DigestString() {
        String base64Md5Digest = Base64.encodeBytes(this.md5DigestResult);
        return String.format("md5-%s", base64Md5Digest);
    }

    public String sHA1DigestString() {
        String base64Sha1Digest = Base64.encodeBytes(this.blobKey.getBytes());
        return String.format("sha1-%s", base64Sha1Digest);
    }

    public int getLength() {
        return this.length;
    }

    public BlobKey getBlobKey() {
        return this.blobKey;
    }

    public String getFilePath() {
        return this.tempFile.getPath();
    }
}

