/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.lite;

import com.couchbase.lite.BlobKey;
import com.couchbase.lite.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BlobStore {
    public static String FILE_EXTENSION = ".blob";
    public static String TMP_FILE_EXTENSION = ".blobtmp";
    public static String TMP_FILE_PREFIX = "tmp";
    private String path;

    public BlobStore(String path) {
        this.path = path;
        File directory = new File(path);
        directory.mkdirs();
        if (!directory.isDirectory()) {
            throw new IllegalStateException(String.format("Unable to create directory for: %s", directory));
        }
    }

    public static BlobKey keyForBlob(byte[] data) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.e("BlobStore", "Error, SHA-1 digest is unavailable.");
            return null;
        }
        byte[] sha1hash = new byte[40];
        md.update(data, 0, data.length);
        sha1hash = md.digest();
        BlobKey result = new BlobKey(sha1hash);
        return result;
    }

    public static BlobKey keyForBlobFromFile(File file) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            Log.e("BlobStore", "Error, SHA-1 digest is unavailable.");
            return null;
        }
        byte[] sha1hash = new byte[40];
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[65536];
            int lenRead = fis.read(buffer);
            while (lenRead > 0) {
                md.update(buffer, 0, lenRead);
                lenRead = fis.read(buffer);
            }
            fis.close();
        }
        catch (IOException e) {
            Log.e("BlobStore", "Error readin tmp file to compute key");
        }
        sha1hash = md.digest();
        BlobKey result = new BlobKey(sha1hash);
        return result;
    }

    public String pathForKey(BlobKey key) {
        return this.path + File.separator + BlobKey.convertToHex(key.getBytes()) + FILE_EXTENSION;
    }

    public long getSizeOfBlob(BlobKey key) {
        String path = this.pathForKey(key);
        File file = new File(path);
        return file.length();
    }

    public boolean getKeyForFilename(BlobKey outKey, String filename) {
        if (!filename.endsWith(FILE_EXTENSION)) {
            return false;
        }
        String rest = filename.substring(this.path.length() + 1, filename.length() - FILE_EXTENSION.length());
        outKey.setBytes(BlobKey.convertFromHex(rest));
        return true;
    }

    public byte[] blobForKey(BlobKey key) {
        String path = this.pathForKey(key);
        File file = new File(path);
        byte[] result = null;
        try {
            result = BlobStore.getBytesFromFile(file);
        }
        catch (IOException e) {
            Log.e("BlobStore", "Error reading file", e);
        }
        return result;
    }

    public InputStream blobStreamForKey(BlobKey key) {
        String path = this.pathForKey(key);
        File file = new File(path);
        if (file.canRead()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                Log.e("BlobStore", "Unexpected file not found in blob store", e);
                return null;
            }
        }
        return null;
    }

    public boolean storeBlobStream(InputStream inputStream, BlobKey outKey) {
        File tmp = null;
        try {
            tmp = File.createTempFile(TMP_FILE_PREFIX, TMP_FILE_EXTENSION, new File(this.path));
            FileOutputStream fos = new FileOutputStream(tmp);
            byte[] buffer = new byte[65536];
            int lenRead = inputStream.read(buffer);
            while (lenRead > 0) {
                fos.write(buffer, 0, lenRead);
                lenRead = inputStream.read(buffer);
            }
            inputStream.close();
            fos.close();
        }
        catch (IOException e) {
            Log.e("BlobStore", "Error writing blog to tmp file", e);
            return false;
        }
        BlobKey newKey = BlobStore.keyForBlobFromFile(tmp);
        outKey.setBytes(newKey.getBytes());
        String path = this.pathForKey(outKey);
        File file = new File(path);
        if (file.canRead()) {
            tmp.delete();
            return true;
        }
        tmp.renameTo(file);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeBlob(byte[] data, BlobKey outKey) {
        BlobKey newKey = BlobStore.keyForBlob(data);
        outKey.setBytes(newKey.getBytes());
        String path = this.pathForKey(outKey);
        File file = new File(path);
        if (file.canRead()) {
            return true;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(data);
        }
        catch (FileNotFoundException e) {
            Log.e("BlobStore", "Error opening file for output", e);
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            Log.e("BlobStore", "Error writing to file", ioe);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    private static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public Set<BlobKey> allKeys() {
        File[] contents;
        HashSet<BlobKey> result = new HashSet<BlobKey>();
        File file = new File(this.path);
        for (File attachment : contents = file.listFiles()) {
            if (attachment.isDirectory()) continue;
            BlobKey attachmentKey = new BlobKey();
            this.getKeyForFilename(attachmentKey, attachment.getPath());
            result.add(attachmentKey);
        }
        return result;
    }

    public int count() {
        File file = new File(this.path);
        File[] contents = file.listFiles();
        return contents.length;
    }

    public long totalDataSize() {
        File[] contents;
        long total = 0L;
        File file = new File(this.path);
        for (File attachment : contents = file.listFiles()) {
            total += attachment.length();
        }
        return total;
    }

    public int deleteBlobsExceptWithKeys(List<BlobKey> keysToKeep) {
        File[] contents;
        int numDeleted = 0;
        File file = new File(this.path);
        for (File attachment : contents = file.listFiles()) {
            BlobKey attachmentKey = new BlobKey();
            this.getKeyForFilename(attachmentKey, attachment.getPath());
            if (keysToKeep.contains(attachmentKey)) continue;
            boolean result = attachment.delete();
            if (result) {
                ++numDeleted;
                continue;
            }
            Log.e("BlobStore", "Error deleting attachment: %s", attachment);
        }
        return numDeleted;
    }

    public int deleteBlobs() {
        return this.deleteBlobsExceptWithKeys(new ArrayList<BlobKey>());
    }

    public boolean isGZipped(BlobKey key) {
        int magic = 0;
        String path = this.pathForKey(key);
        File file = new File(path);
        if (file.canRead()) {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "r");
                magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
                raf.close();
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
            }
        }
        return magic == 35615;
    }

    public File tempDir() {
        File directory = new File(this.path);
        File tempDirectory = new File(directory, "temp_attachments");
        tempDirectory.mkdirs();
        if (!tempDirectory.isDirectory()) {
            throw new IllegalStateException(String.format("Unable to create directory for: %s", tempDirectory));
        }
        return tempDirectory;
    }
}

